/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Trace;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.DelegateLastClassLoader;
import dalvik.system.DexClassLoader;
import dalvik.system.PathClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderFactory {
    private static final String PATH_CLASS_LOADER_NAME = PathClassLoader.class.getName();
    private static final String DEX_CLASS_LOADER_NAME = DexClassLoader.class.getName();
    private static final String DELEGATE_LAST_CLASS_LOADER_NAME = DelegateLastClassLoader.class.getName();

    private ClassLoaderFactory() {
    }

    public static String getPathClassLoaderName() {
        return PATH_CLASS_LOADER_NAME;
    }

    public static boolean isValidClassLoaderName(String name) {
        return name != null && (ClassLoaderFactory.isPathClassLoaderName(name) || ClassLoaderFactory.isDelegateLastClassLoaderName(name));
    }

    public static boolean isPathClassLoaderName(String name) {
        return name == null || PATH_CLASS_LOADER_NAME.equals(name) || DEX_CLASS_LOADER_NAME.equals(name);
    }

    public static boolean isDelegateLastClassLoaderName(String name) {
        return DELEGATE_LAST_CLASS_LOADER_NAME.equals(name);
    }

    public static ClassLoader createClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, String classloaderName, List<ClassLoader> sharedLibraries, List<ClassLoader> sharedLibrariesLoadedAfter) {
        ClassLoader[] arrayOfSharedLibrariesLoadedAfterApp;
        ClassLoader[] arrayOfSharedLibraries = sharedLibraries == null ? null : sharedLibraries.toArray(new ClassLoader[sharedLibraries.size()]);
        ClassLoader[] classLoaderArray = arrayOfSharedLibrariesLoadedAfterApp = sharedLibrariesLoadedAfter == null ? null : sharedLibrariesLoadedAfter.toArray(new ClassLoader[sharedLibrariesLoadedAfter.size()]);
        if (ClassLoaderFactory.isPathClassLoaderName(classloaderName)) {
            return new PathClassLoader(dexPath, librarySearchPath, parent, arrayOfSharedLibraries, arrayOfSharedLibrariesLoadedAfterApp);
        }
        if (ClassLoaderFactory.isDelegateLastClassLoaderName(classloaderName)) {
            return new DelegateLastClassLoader(dexPath, librarySearchPath, parent, arrayOfSharedLibraries, arrayOfSharedLibrariesLoadedAfterApp);
        }
        throw new AssertionError((Object)("Invalid classLoaderName: " + classloaderName));
    }

    public static ClassLoader createClassLoader(String dexPath, String librarySearchPath, String libraryPermittedPath, ClassLoader parent, int targetSdkVersion, boolean isNamespaceShared, String classLoaderName) {
        ArrayList<String> nativeSharedLibraries = new ArrayList<String>();
        nativeSharedLibraries.add("ALL");
        return ClassLoaderFactory.createClassLoader(dexPath, librarySearchPath, libraryPermittedPath, parent, targetSdkVersion, isNamespaceShared, classLoaderName, null, nativeSharedLibraries, null);
    }

    public static ClassLoader createClassLoader(String dexPath, String librarySearchPath, String libraryPermittedPath, ClassLoader parent, int targetSdkVersion, boolean isNamespaceShared, String classLoaderName, List<ClassLoader> sharedLibraries, List<String> nativeSharedLibraries, List<ClassLoader> sharedLibrariesAfter) {
        ClassLoader classLoader = ClassLoaderFactory.createClassLoader(dexPath, librarySearchPath, parent, classLoaderName, sharedLibraries, sharedLibrariesAfter);
        String sonameList = "";
        if (nativeSharedLibraries != null) {
            sonameList = String.join((CharSequence)":", nativeSharedLibraries);
        }
        Trace.traceBegin(64L, "createClassloaderNamespace");
        String errorMessage = ClassLoaderFactory.createClassloaderNamespace(classLoader, targetSdkVersion, librarySearchPath, libraryPermittedPath, isNamespaceShared, dexPath, sonameList);
        Trace.traceEnd(64L);
        if (errorMessage != null) {
            throw new UnsatisfiedLinkError("Unable to create namespace for the classloader " + classLoader + ": " + errorMessage);
        }
        return classLoader;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static String createClassloaderNamespace(ClassLoader classLoader, int n, String string2, String string3, boolean bl, String string4, String string5) {
        return (String)OverrideMethod.invokeA("com.android.internal.os.ClassLoaderFactory#createClassloaderNamespace(Ljava/lang/ClassLoader;ILjava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)Ljava/lang/String;", true, null);
    }
}

