/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.org.bouncycastle.asn1;

import com.android.internal.org.bouncycastle.asn1.ASN1Encodable;
import com.android.internal.org.bouncycastle.asn1.ASN1OutputStream;
import com.android.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.android.internal.org.bouncycastle.asn1.ASN1String;
import com.android.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import com.android.internal.org.bouncycastle.asn1.ASN1UniversalType;
import com.android.internal.org.bouncycastle.asn1.DERIA5String;
import com.android.internal.org.bouncycastle.asn1.DEROctetString;
import com.android.internal.org.bouncycastle.util.Arrays;
import com.android.internal.org.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1IA5String
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1IA5String.class, 22){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1IA5String.createPrimitive(octetString.getOctets());
        }
    };
    final byte[] contents;

    public static ASN1IA5String getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1IA5String) {
            return (ASN1IA5String)obj;
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1IA5String) {
            return (ASN1IA5String)primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1IA5String)TYPE.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + ((Object)e).toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1IA5String getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1IA5String)TYPE.getContextInstance(taggedObject, explicit);
    }

    ASN1IA5String(String string2, boolean validate) {
        if (string2 == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        if (validate && !ASN1IA5String.isIA5String(string2)) {
            throw new IllegalArgumentException("'string' contains illegal characters");
        }
        this.contents = Strings.toByteArray(string2);
    }

    ASN1IA5String(byte[] contents, boolean clone) {
        this.contents = clone ? Arrays.clone(contents) : contents;
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    @Override
    boolean encodeConstructed() {
        return false;
    }

    @Override
    int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 22, this.contents);
    }

    @Override
    boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1IA5String)) {
            return false;
        }
        ASN1IA5String that = (ASN1IA5String)other;
        return Arrays.areEqual(this.contents, that.contents);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public static boolean isIA5String(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }

    static ASN1IA5String createPrimitive(byte[] contents) {
        return new DERIA5String(contents, false);
    }
}

