/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.crypto;

import com.android.internal.net.crypto.KeyGenerationUtils;
import com.android.internal.net.ipsec.ike.crypto.IkeCrypto;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

abstract class IkeMac
extends IkeCrypto
implements KeyGenerationUtils.ByteSigner {
    private final boolean mIsJceSupported;
    private final Mac mMac;

    protected IkeMac(int algorithmId, int keyLength, String algorithmName, boolean isJceSupported) {
        super(algorithmId, keyLength, algorithmName);
        this.mIsJceSupported = isJceSupported;
        try {
            this.mMac = this.mIsJceSupported ? Mac.getInstance(this.getAlgorithmName()) : null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Failed to construct " + this.getTypeString(), e);
        }
    }

    @Override
    public byte[] signBytes(byte[] keyBytes, byte[] dataToSign) {
        try {
            if (this.mIsJceSupported) {
                SecretKeySpec secretKey = new SecretKeySpec(keyBytes, this.getAlgorithmName());
                ByteBuffer inputBuffer = ByteBuffer.wrap(dataToSign);
                this.mMac.init(secretKey);
                this.mMac.update(inputBuffer);
                return this.mMac.doFinal();
            }
            throw new IllegalStateException("Invalid algorithm: " + this.getAlgorithmId());
        }
        catch (IllegalStateException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Failed to generate MAC: ", e);
        }
    }
}

