/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.crypto;

import com.android.internal.net.ipsec.ike.utils.HexDump;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesXCbcImpl {
    private static final String AES_CBC = "AES/CBC/NoPadding";
    private static final int AES_CBC_IV_LEN = 16;
    private static final int AES_CBC_BLOCK_LEN = 16;
    private static final int AES_XCBC_96_MAC_LEN = 12;
    private final Cipher mCipher = Cipher.getInstance("AES/CBC/NoPadding");
    private static final String KEY1_SEED_HEX_STRING = "01010101010101010101010101010101";
    private static final String KEY2_SEED_HEX_STRING = "02020202020202020202020202020202";
    private static final String KEY3_SEED_HEX_STRING = "03030303030303030303030303030303";
    private static final byte[] E_INITIAL = new byte[16];

    public byte[] mac(byte[] keyBytes, byte[] dataToSign, boolean needTruncation) {
        byte[] message;
        int blockSize = this.mCipher.getBlockSize();
        boolean isPaddingNeeded = dataToSign.length % blockSize != 0;
        byte[] paddedData = dataToSign;
        if (isPaddingNeeded) {
            paddedData = AesXCbcImpl.padData(dataToSign, blockSize);
        }
        byte[] key1 = this.encryptAesBlock(keyBytes, HexDump.hexStringToByteArray(KEY1_SEED_HEX_STRING));
        byte[] key2 = this.encryptAesBlock(keyBytes, HexDump.hexStringToByteArray(KEY2_SEED_HEX_STRING));
        byte[] key3 = this.encryptAesBlock(keyBytes, HexDump.hexStringToByteArray(KEY3_SEED_HEX_STRING));
        byte[] e = E_INITIAL;
        int numMessageBlocks = paddedData.length / blockSize;
        for (int i = 0; i < numMessageBlocks - 1; ++i) {
            message = Arrays.copyOfRange(paddedData, i * blockSize, i * blockSize + blockSize);
            message = AesXCbcImpl.xorByteArrays(message, e);
            e = this.encryptAesBlock(key1, message);
        }
        message = Arrays.copyOfRange(paddedData, paddedData.length - blockSize, paddedData.length);
        message = AesXCbcImpl.xorByteArrays(message, e);
        message = isPaddingNeeded ? AesXCbcImpl.xorByteArrays(message, key3) : AesXCbcImpl.xorByteArrays(message, key2);
        byte[] encryptedMessage = this.encryptAesBlock(key1, message);
        if (needTruncation) {
            encryptedMessage = Arrays.copyOfRange(encryptedMessage, 0, 12);
        }
        return encryptedMessage;
    }

    private static byte[] xorByteArrays(byte[] message, byte[] e) {
        byte[] output = new byte[message.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)(message[i] ^ e[i]);
        }
        return output;
    }

    private static byte[] padData(byte[] dataToSign, int blockSize) {
        int dataLen = dataToSign.length;
        int padLen = (dataLen + blockSize - 1) / blockSize * blockSize - dataLen;
        ByteBuffer paddedData = ByteBuffer.allocate(dataLen + padLen);
        byte[] padding = new byte[padLen];
        padding[0] = -128;
        paddedData.put(dataToSign).put(padding);
        return paddedData.array();
    }

    private byte[] encryptAesBlock(byte[] keyBytes, byte[] dataToEncrypt) {
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        ByteBuffer inputBuffer = ByteBuffer.wrap(dataToEncrypt);
        ByteBuffer outputBuffer = ByteBuffer.allocate(dataToEncrypt.length);
        try {
            this.mCipher.init(1, (Key)new SecretKeySpec(keyBytes, this.mCipher.getAlgorithm()), iv);
            this.mCipher.doFinal(inputBuffer, outputBuffer);
            return outputBuffer.array();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IllegalArgumentException("Failed to sign data: ", e);
        }
    }
}

