/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.Quantizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuantizerMap
implements Quantizer {
    private HashMap<Integer, Integer> mColorToCount;
    private Palette mPalette;

    @Override
    public void quantize(@NonNull int[] pixels, int colorCount) {
        HashMap<Integer, Integer> colorToCount = new HashMap<Integer, Integer>();
        for (int pixel : pixels) {
            colorToCount.merge(pixel, 1, Integer::sum);
        }
        this.mColorToCount = colorToCount;
        ArrayList<Palette.Swatch> swatches = new ArrayList<Palette.Swatch>();
        for (Map.Entry entry : colorToCount.entrySet()) {
            swatches.add(new Palette.Swatch((Integer)entry.getKey(), (Integer)entry.getValue()));
        }
        this.mPalette = Palette.from(swatches);
    }

    @Override
    public List<Palette.Swatch> getQuantizedColors() {
        return this.mPalette.getSwatches();
    }

    @Nullable
    public Map<Integer, Integer> getColorToCount() {
        return this.mColorToCount;
    }
}

