/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.dynamicanimation.animation;

import com.android.internal.dynamicanimation.animation.DynamicAnimation;
import com.android.internal.dynamicanimation.animation.FloatValueHolder;
import com.android.internal.dynamicanimation.animation.Force;

public class FlingAnimation
extends DynamicAnimation<FlingAnimation> {
    private final DragForce mFlingForce = new DragForce();

    public FlingAnimation(FloatValueHolder floatValueHolder) {
        super(floatValueHolder);
        this.mFlingForce.setValueThreshold(this.getValueThreshold());
    }

    public FlingAnimation setFriction(float friction) {
        if (friction <= 0.0f) {
            throw new IllegalArgumentException("Friction must be positive");
        }
        this.mFlingForce.setFrictionScalar(friction);
        return this;
    }

    public float getFriction() {
        return this.mFlingForce.getFrictionScalar();
    }

    @Override
    public FlingAnimation setMinValue(float minValue) {
        super.setMinValue(minValue);
        return this;
    }

    @Override
    public FlingAnimation setMaxValue(float maxValue) {
        super.setMaxValue(maxValue);
        return this;
    }

    @Override
    public FlingAnimation setStartVelocity(float startVelocity) {
        super.setStartVelocity(startVelocity);
        return this;
    }

    @Override
    boolean updateValueAndVelocity(long deltaT) {
        DynamicAnimation.MassState state = this.mFlingForce.updateValueAndVelocity(this.mValue, this.mVelocity, deltaT);
        this.mValue = state.mValue;
        this.mVelocity = state.mVelocity;
        if (this.mValue < this.mMinValue) {
            this.mValue = this.mMinValue;
            return true;
        }
        if (this.mValue > this.mMaxValue) {
            this.mValue = this.mMaxValue;
            return true;
        }
        return this.isAtEquilibrium(this.mValue, this.mVelocity);
    }

    @Override
    float getAcceleration(float value, float velocity) {
        return this.mFlingForce.getAcceleration(value, velocity);
    }

    @Override
    boolean isAtEquilibrium(float value, float velocity) {
        return value >= this.mMaxValue || value <= this.mMinValue || this.mFlingForce.isAtEquilibrium(value, velocity);
    }

    @Override
    void setValueThreshold(float threshold) {
        this.mFlingForce.setValueThreshold(threshold);
    }

    private static class DragForce
    implements Force {
        private static final float DEFAULT_FRICTION = -4.2f;
        private static final float VELOCITY_THRESHOLD_MULTIPLIER = 62.5f;
        private float mFriction = -4.2f;
        private float mVelocityThreshold;
        private final DynamicAnimation.MassState mMassState = new DynamicAnimation.MassState();

        private DragForce() {
        }

        void setFrictionScalar(float frictionScalar) {
            this.mFriction = frictionScalar * -4.2f;
        }

        float getFrictionScalar() {
            return this.mFriction / -4.2f;
        }

        DynamicAnimation.MassState updateValueAndVelocity(float value, float velocity, long deltaT) {
            this.mMassState.mVelocity = (float)((double)velocity * Math.exp((float)deltaT / 1000.0f * this.mFriction));
            this.mMassState.mValue = (float)((double)(value - velocity / this.mFriction) + (double)(velocity / this.mFriction) * Math.exp(this.mFriction * (float)deltaT / 1000.0f));
            if (this.isAtEquilibrium(this.mMassState.mValue, this.mMassState.mVelocity)) {
                this.mMassState.mVelocity = 0.0f;
            }
            return this.mMassState;
        }

        @Override
        public float getAcceleration(float position, float velocity) {
            return velocity * this.mFriction;
        }

        @Override
        public boolean isAtEquilibrium(float value, float velocity) {
            return Math.abs(velocity) < this.mVelocityThreshold;
        }

        void setValueThreshold(float threshold) {
            this.mVelocityThreshold = threshold * 62.5f;
        }
    }
}

