/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.appwidget;

import android.app.IApplicationThread;
import android.app.IServiceConnection;
import android.appwidget.AppWidgetEvent;
import android.appwidget.AppWidgetProviderInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;

public interface IAppWidgetService
extends IInterface {
    public ParceledListSlice startListening(IAppWidgetHost var1, String var2, int var3, int[] var4) throws RemoteException;

    public void stopListening(String var1, int var2) throws RemoteException;

    public int allocateAppWidgetId(String var1, int var2) throws RemoteException;

    public void deleteAppWidgetId(String var1, int var2) throws RemoteException;

    public void deleteHost(String var1, int var2) throws RemoteException;

    public void deleteAllHosts() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/appwidget/IAppWidgetService.aidl:47:1:47:69")
    public RemoteViews getAppWidgetViews(String var1, int var2) throws RemoteException;

    public int[] getAppWidgetIdsForHost(String var1, int var2) throws RemoteException;

    public void setAppWidgetHidden(String var1, int var2) throws RemoteException;

    public IntentSender createAppWidgetConfigIntentSender(String var1, int var2, int var3) throws RemoteException;

    public void updateAppWidgetIds(String var1, int[] var2, RemoteViews var3) throws RemoteException;

    public void updateAppWidgetOptions(String var1, int var2, Bundle var3) throws RemoteException;

    public Bundle getAppWidgetOptions(String var1, int var2) throws RemoteException;

    public void partiallyUpdateAppWidgetIds(String var1, int[] var2, RemoteViews var3) throws RemoteException;

    public void updateAppWidgetProvider(ComponentName var1, RemoteViews var2) throws RemoteException;

    public void updateAppWidgetProviderInfo(ComponentName var1, String var2) throws RemoteException;

    public void notifyAppWidgetViewDataChanged(String var1, int[] var2, int var3) throws RemoteException;

    public ParceledListSlice getInstalledProvidersForProfile(int var1, int var2, String var3) throws RemoteException;

    public AppWidgetProviderInfo getAppWidgetInfo(String var1, int var2) throws RemoteException;

    public boolean hasBindAppWidgetPermission(String var1, int var2) throws RemoteException;

    public void setBindAppWidgetPermission(String var1, int var2, boolean var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/appwidget/IAppWidgetService.aidl:70:1:70:69")
    public boolean bindAppWidgetId(String var1, int var2, int var3, ComponentName var4, Bundle var5) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/appwidget/IAppWidgetService.aidl:73:1:73:69")
    public boolean bindRemoteViewsService(String var1, int var2, Intent var3, IApplicationThread var4, IBinder var5, IServiceConnection var6, long var7) throws RemoteException;

    public void notifyProviderInheritance(ComponentName[] var1) throws RemoteException;

    public int getMaxBitmapMemory() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/com/android/internal/appwidget/IAppWidgetService.aidl:79:1:79:25")
    public int[] getAppWidgetIds(ComponentName var1) throws RemoteException;

    public boolean isBoundWidgetPackage(String var1, int var2) throws RemoteException;

    public boolean requestPinAppWidget(String var1, ComponentName var2, Bundle var3, IntentSender var4) throws RemoteException;

    public boolean isRequestPinAppWidgetSupported() throws RemoteException;

    public void noteAppWidgetTapped(String var1, int var2) throws RemoteException;

    public boolean setWidgetPreview(ComponentName var1, int var2, RemoteViews var3) throws RemoteException;

    public RemoteViews getWidgetPreview(String var1, ComponentName var2, int var3, int var4) throws RemoteException;

    public void removeWidgetPreview(ComponentName var1, int var2) throws RemoteException;

    public void reportWidgetEvents(String var1, AppWidgetEvent[] var2) throws RemoteException;

    public boolean isFirstConfigActivityPending(String var1, int var2) throws RemoteException;

    public void setConfigActivityComplete(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAppWidgetService {
        public static final String DESCRIPTOR = "com.android.internal.appwidget.IAppWidgetService";
        static final int TRANSACTION_startListening = 1;
        static final int TRANSACTION_stopListening = 2;
        static final int TRANSACTION_allocateAppWidgetId = 3;
        static final int TRANSACTION_deleteAppWidgetId = 4;
        static final int TRANSACTION_deleteHost = 5;
        static final int TRANSACTION_deleteAllHosts = 6;
        static final int TRANSACTION_getAppWidgetViews = 7;
        static final int TRANSACTION_getAppWidgetIdsForHost = 8;
        static final int TRANSACTION_setAppWidgetHidden = 9;
        static final int TRANSACTION_createAppWidgetConfigIntentSender = 10;
        static final int TRANSACTION_updateAppWidgetIds = 11;
        static final int TRANSACTION_updateAppWidgetOptions = 12;
        static final int TRANSACTION_getAppWidgetOptions = 13;
        static final int TRANSACTION_partiallyUpdateAppWidgetIds = 14;
        static final int TRANSACTION_updateAppWidgetProvider = 15;
        static final int TRANSACTION_updateAppWidgetProviderInfo = 16;
        static final int TRANSACTION_notifyAppWidgetViewDataChanged = 17;
        static final int TRANSACTION_getInstalledProvidersForProfile = 18;
        static final int TRANSACTION_getAppWidgetInfo = 19;
        static final int TRANSACTION_hasBindAppWidgetPermission = 20;
        static final int TRANSACTION_setBindAppWidgetPermission = 21;
        static final int TRANSACTION_bindAppWidgetId = 22;
        static final int TRANSACTION_bindRemoteViewsService = 23;
        static final int TRANSACTION_notifyProviderInheritance = 24;
        static final int TRANSACTION_getMaxBitmapMemory = 25;
        static final int TRANSACTION_getAppWidgetIds = 26;
        static final int TRANSACTION_isBoundWidgetPackage = 27;
        static final int TRANSACTION_requestPinAppWidget = 28;
        static final int TRANSACTION_isRequestPinAppWidgetSupported = 29;
        static final int TRANSACTION_noteAppWidgetTapped = 30;
        static final int TRANSACTION_setWidgetPreview = 31;
        static final int TRANSACTION_getWidgetPreview = 32;
        static final int TRANSACTION_removeWidgetPreview = 33;
        static final int TRANSACTION_reportWidgetEvents = 34;
        static final int TRANSACTION_isFirstConfigActivityPending = 35;
        static final int TRANSACTION_setConfigActivityComplete = 36;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAppWidgetService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAppWidgetService) {
                return (IAppWidgetService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startListening";
                }
                case 2: {
                    return "stopListening";
                }
                case 3: {
                    return "allocateAppWidgetId";
                }
                case 4: {
                    return "deleteAppWidgetId";
                }
                case 5: {
                    return "deleteHost";
                }
                case 6: {
                    return "deleteAllHosts";
                }
                case 7: {
                    return "getAppWidgetViews";
                }
                case 8: {
                    return "getAppWidgetIdsForHost";
                }
                case 9: {
                    return "setAppWidgetHidden";
                }
                case 10: {
                    return "createAppWidgetConfigIntentSender";
                }
                case 11: {
                    return "updateAppWidgetIds";
                }
                case 12: {
                    return "updateAppWidgetOptions";
                }
                case 13: {
                    return "getAppWidgetOptions";
                }
                case 14: {
                    return "partiallyUpdateAppWidgetIds";
                }
                case 15: {
                    return "updateAppWidgetProvider";
                }
                case 16: {
                    return "updateAppWidgetProviderInfo";
                }
                case 17: {
                    return "notifyAppWidgetViewDataChanged";
                }
                case 18: {
                    return "getInstalledProvidersForProfile";
                }
                case 19: {
                    return "getAppWidgetInfo";
                }
                case 20: {
                    return "hasBindAppWidgetPermission";
                }
                case 21: {
                    return "setBindAppWidgetPermission";
                }
                case 22: {
                    return "bindAppWidgetId";
                }
                case 23: {
                    return "bindRemoteViewsService";
                }
                case 24: {
                    return "notifyProviderInheritance";
                }
                case 25: {
                    return "getMaxBitmapMemory";
                }
                case 26: {
                    return "getAppWidgetIds";
                }
                case 27: {
                    return "isBoundWidgetPackage";
                }
                case 28: {
                    return "requestPinAppWidget";
                }
                case 29: {
                    return "isRequestPinAppWidgetSupported";
                }
                case 30: {
                    return "noteAppWidgetTapped";
                }
                case 31: {
                    return "setWidgetPreview";
                }
                case 32: {
                    return "getWidgetPreview";
                }
                case 33: {
                    return "removeWidgetPreview";
                }
                case 34: {
                    return "reportWidgetEvents";
                }
                case 35: {
                    return "isFirstConfigActivityPending";
                }
                case 36: {
                    return "setConfigActivityComplete";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IAppWidgetHost _arg0 = IAppWidgetHost.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int[] _arg3 = data.createIntArray();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.startListening(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopListening(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.allocateAppWidgetId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteAppWidgetId(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteHost(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.deleteAllHosts();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    RemoteViews _result = this.getAppWidgetViews(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int[] _result = this.getAppWidgetIdsForHost(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAppWidgetHidden(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    IntentSender _result = this.createAppWidgetConfigIntentSender(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    RemoteViews _arg2 = data.readTypedObject(RemoteViews.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateAppWidgetIds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateAppWidgetOptions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Bundle _result = this.getAppWidgetOptions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    RemoteViews _arg2 = data.readTypedObject(RemoteViews.CREATOR);
                    data.enforceNoDataAvail();
                    this.partiallyUpdateAppWidgetIds(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    RemoteViews _arg1 = data.readTypedObject(RemoteViews.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateAppWidgetProvider(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.updateAppWidgetProviderInfo(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    int[] _arg1 = data.createIntArray();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAppWidgetViewDataChanged(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getInstalledProvidersForProfile(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    AppWidgetProviderInfo _result = this.getAppWidgetInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasBindAppWidgetPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setBindAppWidgetPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ComponentName _arg3 = data.readTypedObject(ComponentName.CREATOR);
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.bindAppWidgetId(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    Intent _arg2 = data.readTypedObject(Intent.CREATOR);
                    IApplicationThread _arg3 = IApplicationThread.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg4 = data.readStrongBinder();
                    IServiceConnection _arg5 = IServiceConnection.Stub.asInterface(data.readStrongBinder());
                    long _arg6 = data.readLong();
                    data.enforceNoDataAvail();
                    boolean _result = this.bindRemoteViewsService(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    ComponentName[] _arg0 = data.createTypedArray(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyProviderInheritance(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _result = this.getMaxBitmapMemory();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 26: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    int[] _result = this.getAppWidgetIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isBoundWidgetPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    IntentSender _arg3 = data.readTypedObject(IntentSender.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.requestPinAppWidget(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _result = this.isRequestPinAppWidgetSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.noteAppWidgetTapped(_arg0, _arg1);
                    break;
                }
                case 31: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    RemoteViews _arg2 = data.readTypedObject(RemoteViews.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setWidgetPreview(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    String _arg0 = data.readString();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    RemoteViews _result = this.getWidgetPreview(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 33: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeWidgetPreview(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    String _arg0 = data.readString();
                    AppWidgetEvent[] _arg1 = data.createTypedArray(AppWidgetEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportWidgetEvents(_arg0, _arg1);
                    break;
                }
                case 35: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isFirstConfigActivityPending(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setConfigActivityComplete(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 35;
        }

        private static class Proxy
        implements IAppWidgetService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice startListening(IAppWidgetHost host, String callingPackage, int hostId, int[] appWidgetIds) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(host);
                    _data.writeString(callingPackage);
                    _data.writeInt(hostId);
                    _data.writeIntArray(appWidgetIds);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopListening(String callingPackage, int hostId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(hostId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int allocateAppWidgetId(String callingPackage, int hostId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(hostId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteAppWidgetId(String callingPackage, int appWidgetId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteHost(String packageName, int hostId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(hostId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteAllHosts() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RemoteViews getAppWidgetViews(String callingPackage, int appWidgetId) throws RemoteException {
                RemoteViews _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RemoteViews.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAppWidgetIdsForHost(String callingPackage, int hostId) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(hostId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppWidgetHidden(String callingPackage, int hostId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(hostId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IntentSender createAppWidgetConfigIntentSender(String callingPackage, int appWidgetId, int intentFlags) throws RemoteException {
                IntentSender _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    _data.writeInt(intentFlags);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(IntentSender.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeIntArray(appWidgetIds);
                    _data.writeTypedObject(views, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAppWidgetOptions(String callingPackage, int appWidgetId, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getAppWidgetOptions(String callingPackage, int appWidgetId) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void partiallyUpdateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeIntArray(appWidgetIds);
                    _data.writeTypedObject(views, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAppWidgetProvider(ComponentName provider, RemoteViews views) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(provider, 0);
                    _data.writeTypedObject(views, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAppWidgetProviderInfo(ComponentName provider, String metadataKey) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(provider, 0);
                    _data.writeString(metadataKey);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAppWidgetViewDataChanged(String packageName, int[] appWidgetIds, int viewId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeIntArray(appWidgetIds);
                    _data.writeInt(viewId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getInstalledProvidersForProfile(int categoryFilter, int profileId, String packageName) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(categoryFilter);
                    _data.writeInt(profileId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AppWidgetProviderInfo getAppWidgetInfo(String callingPackage, int appWidgetId) throws RemoteException {
                AppWidgetProviderInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(AppWidgetProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasBindAppWidgetPermission(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBindAppWidgetPermission(String packageName, int userId, boolean permission2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeBoolean(permission2);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean bindAppWidgetId(String callingPackage, int appWidgetId, int providerProfileId, ComponentName providerComponent, Bundle options) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    _data.writeInt(providerProfileId);
                    _data.writeTypedObject(providerComponent, 0);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean bindRemoteViewsService(String callingPackage, int appWidgetId, Intent intent, IApplicationThread caller, IBinder token, IServiceConnection connection, long flags) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    _data.writeTypedObject(intent, 0);
                    _data.writeStrongInterface(caller);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(connection);
                    _data.writeLong(flags);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyProviderInheritance(ComponentName[] componentNames) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(componentNames, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMaxBitmapMemory() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAppWidgetIds(ComponentName providerComponent) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(providerComponent, 0);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBoundWidgetPackage(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestPinAppWidget(String packageName, ComponentName providerComponent, Bundle extras, IntentSender resultIntent) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(providerComponent, 0);
                    _data.writeTypedObject(extras, 0);
                    _data.writeTypedObject(resultIntent, 0);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRequestPinAppWidgetSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noteAppWidgetTapped(String callingPackage, int appWidgetId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWidgetPreview(ComponentName providerComponent, int widgetCategories, RemoteViews preview) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(providerComponent, 0);
                    _data.writeInt(widgetCategories);
                    _data.writeTypedObject(preview, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RemoteViews getWidgetPreview(String callingPackage, ComponentName providerComponent, int profileId, int widgetCategory) throws RemoteException {
                RemoteViews _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(providerComponent, 0);
                    _data.writeInt(profileId);
                    _data.writeInt(widgetCategory);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RemoteViews.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWidgetPreview(ComponentName providerComponent, int widgetCategories) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(providerComponent, 0);
                    _data.writeInt(widgetCategories);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportWidgetEvents(String callingPackage, AppWidgetEvent[] events) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeTypedArray(events, 0);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isFirstConfigActivityPending(String callingPackage, int appWidgetId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(appWidgetId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConfigActivityComplete(int appWidgetId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(appWidgetId);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAppWidgetService {
        @Override
        public ParceledListSlice startListening(IAppWidgetHost host, String callingPackage, int hostId, int[] appWidgetIds) throws RemoteException {
            return null;
        }

        @Override
        public void stopListening(String callingPackage, int hostId) throws RemoteException {
        }

        @Override
        public int allocateAppWidgetId(String callingPackage, int hostId) throws RemoteException {
            return 0;
        }

        @Override
        public void deleteAppWidgetId(String callingPackage, int appWidgetId) throws RemoteException {
        }

        @Override
        public void deleteHost(String packageName, int hostId) throws RemoteException {
        }

        @Override
        public void deleteAllHosts() throws RemoteException {
        }

        @Override
        public RemoteViews getAppWidgetViews(String callingPackage, int appWidgetId) throws RemoteException {
            return null;
        }

        @Override
        public int[] getAppWidgetIdsForHost(String callingPackage, int hostId) throws RemoteException {
            return null;
        }

        @Override
        public void setAppWidgetHidden(String callingPackage, int hostId) throws RemoteException {
        }

        @Override
        public IntentSender createAppWidgetConfigIntentSender(String callingPackage, int appWidgetId, int intentFlags) throws RemoteException {
            return null;
        }

        @Override
        public void updateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views) throws RemoteException {
        }

        @Override
        public void updateAppWidgetOptions(String callingPackage, int appWidgetId, Bundle extras) throws RemoteException {
        }

        @Override
        public Bundle getAppWidgetOptions(String callingPackage, int appWidgetId) throws RemoteException {
            return null;
        }

        @Override
        public void partiallyUpdateAppWidgetIds(String callingPackage, int[] appWidgetIds, RemoteViews views) throws RemoteException {
        }

        @Override
        public void updateAppWidgetProvider(ComponentName provider, RemoteViews views) throws RemoteException {
        }

        @Override
        public void updateAppWidgetProviderInfo(ComponentName provider, String metadataKey) throws RemoteException {
        }

        @Override
        public void notifyAppWidgetViewDataChanged(String packageName, int[] appWidgetIds, int viewId) throws RemoteException {
        }

        @Override
        public ParceledListSlice getInstalledProvidersForProfile(int categoryFilter, int profileId, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public AppWidgetProviderInfo getAppWidgetInfo(String callingPackage, int appWidgetId) throws RemoteException {
            return null;
        }

        @Override
        public boolean hasBindAppWidgetPermission(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setBindAppWidgetPermission(String packageName, int userId, boolean permission2) throws RemoteException {
        }

        @Override
        public boolean bindAppWidgetId(String callingPackage, int appWidgetId, int providerProfileId, ComponentName providerComponent, Bundle options) throws RemoteException {
            return false;
        }

        @Override
        public boolean bindRemoteViewsService(String callingPackage, int appWidgetId, Intent intent, IApplicationThread caller, IBinder token, IServiceConnection connection, long flags) throws RemoteException {
            return false;
        }

        @Override
        public void notifyProviderInheritance(ComponentName[] componentNames) throws RemoteException {
        }

        @Override
        public int getMaxBitmapMemory() throws RemoteException {
            return 0;
        }

        @Override
        public int[] getAppWidgetIds(ComponentName providerComponent) throws RemoteException {
            return null;
        }

        @Override
        public boolean isBoundWidgetPackage(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean requestPinAppWidget(String packageName, ComponentName providerComponent, Bundle extras, IntentSender resultIntent) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRequestPinAppWidgetSupported() throws RemoteException {
            return false;
        }

        @Override
        public void noteAppWidgetTapped(String callingPackage, int appWidgetId) throws RemoteException {
        }

        @Override
        public boolean setWidgetPreview(ComponentName providerComponent, int widgetCategories, RemoteViews preview) throws RemoteException {
            return false;
        }

        @Override
        public RemoteViews getWidgetPreview(String callingPackage, ComponentName providerComponent, int profileId, int widgetCategory) throws RemoteException {
            return null;
        }

        @Override
        public void removeWidgetPreview(ComponentName providerComponent, int widgetCategories) throws RemoteException {
        }

        @Override
        public void reportWidgetEvents(String callingPackage, AppWidgetEvent[] events) throws RemoteException {
        }

        @Override
        public boolean isFirstConfigActivityPending(String callingPackage, int appWidgetId) throws RemoteException {
            return false;
        }

        @Override
        public void setConfigActivityComplete(int appWidgetId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

