/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.prediction.AppPredictor;
import android.app.prediction.AppTarget;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.AppTargetId;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Message;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.ChooserActivityLogger;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverAppPredictorCallback;
import com.android.internal.app.ResolverComparatorModel;
import com.android.internal.app.ResolverRankerServiceResolverComparator;
import com.android.internal.app.chooser.TargetInfo;
import com.google.android.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;

class AppPredictionServiceResolverComparator
extends AbstractResolverComparator {
    private static final String TAG = "APSResolverComparator";
    private final AppPredictor mAppPredictor;
    private final Context mContext;
    private final UserHandle mUser;
    private final Intent mIntent;
    private final String mReferrerPackage;
    private final ModelBuilder mModelBuilder;
    private ResolverComparatorModel mComparatorModel;
    private ResolverAppPredictorCallback mSortingCallback;
    private ResolverRankerServiceResolverComparator mResolverRankerService;

    AppPredictionServiceResolverComparator(Context context, Intent intent, String referrerPackage, AppPredictor appPredictor, UserHandle user, ChooserActivityLogger chooserActivityLogger) {
        super(context, intent, Lists.newArrayList(user));
        this.mContext = context;
        this.mIntent = intent;
        this.mAppPredictor = appPredictor;
        this.mUser = user;
        this.mReferrerPackage = referrerPackage;
        this.setChooserActivityLogger(chooserActivityLogger);
        this.mModelBuilder = new ModelBuilder(appPredictor, user);
        this.mComparatorModel = this.mModelBuilder.buildFromRankedList(Collections.emptyList());
    }

    @Override
    void destroy() {
        if (this.mResolverRankerService != null) {
            this.mResolverRankerService.destroy();
            this.mResolverRankerService = null;
            this.mComparatorModel = this.mModelBuilder.buildFallbackModel(this.mResolverRankerService);
        }
        if (this.mSortingCallback != null) {
            this.mSortingCallback.destroy();
        }
    }

    @Override
    int compare(ResolveInfo lhs, ResolveInfo rhs) {
        return this.mComparatorModel.getComparator().compare(lhs, rhs);
    }

    @Override
    float getScore(TargetInfo targetInfo) {
        return this.mComparatorModel.getScore(targetInfo);
    }

    @Override
    void updateModel(TargetInfo targetInfo) {
        this.mComparatorModel.notifyOnTargetSelected(targetInfo);
    }

    @Override
    void handleResultMessage(Message msg) {
        if (msg.what == 0 && msg.obj != null) {
            this.mComparatorModel = this.mModelBuilder.buildFromRankedList((List)msg.obj);
        } else if (msg.obj == null && this.mResolverRankerService == null) {
            Log.e(TAG, "Unexpected null result");
        }
    }

    @Override
    void doCompute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        if (targets.isEmpty()) {
            this.mHandler.sendEmptyMessage(0);
            return;
        }
        ArrayList<AppTarget> appTargets = new ArrayList<AppTarget>();
        for (ResolverActivity.ResolvedComponentInfo target : targets) {
            appTargets.add(new AppTarget.Builder(new AppTargetId(target.name.flattenToString()), target.name.getPackageName(), this.mUser).setClassName(target.name.getClassName()).build());
        }
        if (this.mSortingCallback != null) {
            this.mSortingCallback.destroy();
        }
        this.mSortingCallback = new ResolverAppPredictorCallback(sortedAppTargets -> {
            if (sortedAppTargets.isEmpty()) {
                Log.i(TAG, "AppPredictionService disabled. Using resolver.");
                this.setupFallbackModel(targets);
            } else {
                Log.i(TAG, "AppPredictionService response received");
                this.handleResult((List<AppTarget>)sortedAppTargets);
            }
        });
        this.mAppPredictor.sortTargets(appTargets, Executors.newSingleThreadExecutor(), this.mSortingCallback.asConsumer());
    }

    private void setupFallbackModel(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.mResolverRankerService = new ResolverRankerServiceResolverComparator(this.mContext, this.mIntent, this.mReferrerPackage, () -> this.mHandler.sendEmptyMessage(0), this.getChooserActivityLogger(), this.mUser);
        this.mComparatorModel = this.mModelBuilder.buildFallbackModel(this.mResolverRankerService);
        this.mResolverRankerService.compute(targets);
    }

    private void handleResult(List<AppTarget> sortedAppTargets) {
        if (this.mHandler.hasMessages(1)) {
            this.mComparatorModel = this.mModelBuilder.buildFromRankedList(sortedAppTargets);
            this.mHandler.removeMessages(1);
            this.afterCompute();
        }
    }

    static class ModelBuilder {
        private final AppPredictor mAppPredictor;
        private final UserHandle mUser;

        ModelBuilder(AppPredictor appPredictor, UserHandle user) {
            this.mAppPredictor = appPredictor;
            this.mUser = user;
        }

        ResolverComparatorModel buildFromRankedList(List<AppTarget> sortedAppTargets) {
            return new AppPredictionServiceComparatorModel(this.mAppPredictor, this.mUser, this.buildTargetRanksMapFromSortedTargets(sortedAppTargets));
        }

        ResolverComparatorModel buildFallbackModel(ResolverRankerServiceResolverComparator fallback) {
            return this.adaptLegacyResolverComparatorToComparatorModel(fallback);
        }

        private Map<ComponentName, Integer> buildTargetRanksMapFromSortedTargets(List<AppTarget> sortedAppTargets) {
            HashMap<ComponentName, Integer> targetRanks = new HashMap<ComponentName, Integer>();
            for (int i = 0; i < sortedAppTargets.size(); ++i) {
                ComponentName componentName = new ComponentName(sortedAppTargets.get(i).getPackageName(), sortedAppTargets.get(i).getClassName());
                targetRanks.put(componentName, i);
                Log.i(AppPredictionServiceResolverComparator.TAG, "handleSortedAppTargets, sortedAppTargets #" + i + ": " + componentName);
            }
            return targetRanks;
        }

        private ResolverComparatorModel adaptLegacyResolverComparatorToComparatorModel(final AbstractResolverComparator comparator) {
            return new ResolverComparatorModel(){

                @Override
                public Comparator<ResolveInfo> getComparator() {
                    return (lhs, rhs) -> comparator.compare((ResolveInfo)lhs, (ResolveInfo)rhs);
                }

                @Override
                public float getScore(TargetInfo targetInfo) {
                    return comparator.getScore(targetInfo);
                }

                @Override
                public void notifyOnTargetSelected(TargetInfo targetInfo) {
                    comparator.updateModel(targetInfo);
                }
            };
        }
    }

    static class AppPredictionServiceComparatorModel
    implements ResolverComparatorModel {
        private final AppPredictor mAppPredictor;
        private final UserHandle mUser;
        private final Map<ComponentName, Integer> mTargetRanks;

        AppPredictionServiceComparatorModel(AppPredictor appPredictor, UserHandle user, Map<ComponentName, Integer> targetRanks) {
            this.mAppPredictor = appPredictor;
            this.mUser = user;
            this.mTargetRanks = targetRanks;
        }

        @Override
        public Comparator<ResolveInfo> getComparator() {
            return (lhs, rhs) -> {
                Integer lhsRank = this.mTargetRanks.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
                Integer rhsRank = this.mTargetRanks.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
                if (lhsRank == null && rhsRank == null) {
                    return 0;
                }
                if (lhsRank == null) {
                    return -1;
                }
                if (rhsRank == null) {
                    return 1;
                }
                return lhsRank - rhsRank;
            };
        }

        @Override
        public float getScore(TargetInfo targetInfo) {
            Integer rank = this.mTargetRanks.get(targetInfo.getResolvedComponentName());
            if (rank == null) {
                Log.w(AppPredictionServiceResolverComparator.TAG, "Score requested for unknown component. Did you call compute yet?");
                return 0.0f;
            }
            int consecutiveSumOfRanks = (this.mTargetRanks.size() - 1) * this.mTargetRanks.size() / 2;
            return 1.0f - (float)rank.intValue() / (float)consecutiveSumOfRanks;
        }

        @Override
        public void notifyOnTargetSelected(TargetInfo targetInfo) {
            this.mAppPredictor.notifyAppTargetEvent(new AppTargetEvent.Builder(new AppTarget.Builder(new AppTargetId(targetInfo.getResolvedComponentName().toString()), targetInfo.getResolvedComponentName().getPackageName(), this.mUser).setClassName(targetInfo.getResolvedComponentName().getClassName()).build(), 1).build());
        }
    }
}

