/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import com.android.i18n.timezone.CountryTimeZones;
import com.android.i18n.timezone.XmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CountryZonesFinder {
    private final List<CountryTimeZones> countryTimeZonesList;

    CountryZonesFinder(List<CountryTimeZones> countryTimeZonesList) {
        this.countryTimeZonesList = new ArrayList<CountryTimeZones>(countryTimeZonesList);
    }

    public static CountryZonesFinder createForTests(List<CountryTimeZones> countryTimeZonesList) {
        return new CountryZonesFinder(countryTimeZonesList);
    }

    public List<String> lookupAllCountryIsoCodes() {
        ArrayList<String> isoCodes = new ArrayList<String>(this.countryTimeZonesList.size());
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            isoCodes.add(countryTimeZones.getCountryIso());
        }
        return Collections.unmodifiableList(isoCodes);
    }

    public List<CountryTimeZones> lookupCountryTimeZonesForZoneId(String zoneId) {
        ArrayList<CountryTimeZones> matches = new ArrayList<CountryTimeZones>(2);
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            boolean match = false;
            List<CountryTimeZones.TimeZoneMapping> countryTimeZoneMappings = countryTimeZones.getTimeZoneMappings();
            for (CountryTimeZones.TimeZoneMapping timeZoneMapping : countryTimeZoneMappings) {
                if (!timeZoneMapping.getTimeZoneId().equals(zoneId) && !timeZoneMapping.getAlternativeIds().contains(zoneId)) continue;
                match = true;
                break;
            }
            if (!match) continue;
            matches.add(countryTimeZones);
        }
        return Collections.unmodifiableList(matches);
    }

    public CountryTimeZones lookupCountryTimeZones(String countryIso) {
        String normalizedCountryIso = XmlUtils.normalizeCountryIso(countryIso);
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            if (!countryTimeZones.getCountryIso().equals(normalizedCountryIso)) continue;
            return countryTimeZones;
        }
        return null;
    }

    public String findCanonicalTimeZoneId(String timeZoneId) {
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            List<CountryTimeZones.TimeZoneMapping> countryTimeZoneMappings = countryTimeZones.getTimeZoneMappings();
            for (CountryTimeZones.TimeZoneMapping timeZoneMapping : countryTimeZoneMappings) {
                if (!timeZoneMapping.getTimeZoneId().equals(timeZoneId) && !timeZoneMapping.getAlternativeIds().contains(timeZoneId)) continue;
                return timeZoneMapping.getTimeZoneId();
            }
        }
        return null;
    }
}

