/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers.metadata.source;

import com.android.i18n.phonenumbers.MetadataLoader;
import com.android.i18n.phonenumbers.Phonemetadata;
import com.android.i18n.phonenumbers.metadata.init.MetadataParser;
import com.android.i18n.phonenumbers.metadata.source.MetadataBootstrappingGuard;
import com.android.i18n.phonenumbers.metadata.source.MetadataContainer;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class BlockingMetadataBootstrappingGuard<T extends MetadataContainer>
implements MetadataBootstrappingGuard<T> {
    private final MetadataLoader metadataLoader;
    private final MetadataParser metadataParser;
    private final T metadataContainer;
    private final Map<String, String> loadedFiles;

    BlockingMetadataBootstrappingGuard(MetadataLoader metadataLoader, MetadataParser metadataParser, T metadataContainer) {
        this.metadataLoader = metadataLoader;
        this.metadataParser = metadataParser;
        this.metadataContainer = metadataContainer;
        this.loadedFiles = new ConcurrentHashMap<String, String>();
    }

    @Override
    public T getOrBootstrap(String phoneMetadataFile) {
        if (!this.loadedFiles.containsKey(phoneMetadataFile)) {
            this.bootstrapMetadata(phoneMetadataFile);
        }
        return this.metadataContainer;
    }

    private synchronized void bootstrapMetadata(String phoneMetadataFile) {
        if (this.loadedFiles.containsKey(phoneMetadataFile)) {
            return;
        }
        Collection<Phonemetadata.PhoneMetadata> phoneMetadata = this.read(phoneMetadataFile);
        for (Phonemetadata.PhoneMetadata metadata : phoneMetadata) {
            this.metadataContainer.accept(metadata);
        }
        this.loadedFiles.put(phoneMetadataFile, phoneMetadataFile);
    }

    private Collection<Phonemetadata.PhoneMetadata> read(String phoneMetadataFile) {
        try {
            InputStream metadataStream = this.metadataLoader.loadMetadata(phoneMetadataFile);
            return this.metadataParser.parse(metadataStream);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IllegalStateException("Failed to read file " + phoneMetadataFile, e);
        }
    }
}

