/*
 * Decompiled with CFR 0.152.
 */
package com.android.federatedcompute.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import com.android.federatedcompute.internal.util.AbstractServiceBinder;
import com.android.federatedcompute.internal.util.LogUtil;
import com.android.internal.annotations.GuardedBy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class AndroidServiceBinder<T>
extends AbstractServiceBinder<T> {
    private static final String TAG = AndroidServiceBinder.class.getSimpleName();
    private static final int BINDER_CONNECTION_TIMEOUT_MS = 5000;
    private static final int MAX_GET_SERVICE_RETRIES = 2;
    private static final long GET_SERVICE_RETRY_DELAY_MS = 100L;
    private final String mServiceIntentActionOrName;
    private final List<String> mServicePackages;
    private final Function<IBinder, T> mBinderConverter;
    private final Context mContext;
    private final boolean mEnableLookupByServiceName;
    private final String mIsolatedProcessName;
    private final int mBindFlags;
    private final Object mLock = new Object();
    private CountDownLatch mConnectionCountDownLatch;
    @GuardedBy(value={"mLock"})
    private T mService;
    @GuardedBy(value={"mLock"})
    private ServiceConnection mServiceConnection;

    AndroidServiceBinder(@NonNull Context context, @NonNull String serviceIntentAction, @NonNull String servicePackage, @NonNull Function<IBinder, T> converter) {
        this(context, serviceIntentAction, List.of(servicePackage), converter);
    }

    AndroidServiceBinder(@NonNull Context context, @NonNull String serviceIntentAction, @NonNull List<String> servicePackages, @NonNull Function<IBinder, T> converter) {
        this(context, serviceIntentAction, servicePackages, 0, converter);
    }

    AndroidServiceBinder(@NonNull Context context, @NonNull String serviceIntentAction, @NonNull List<String> servicePackages, int bindFlags, @NonNull Function<IBinder, T> converter) {
        this(context, serviceIntentAction, servicePackages, null, false, bindFlags, converter);
    }

    AndroidServiceBinder(@NonNull Context context, @NonNull String serviceIntentActionOrName, @NonNull String servicePackage, boolean enableLookupByName, @NonNull Function<IBinder, T> converter) {
        this(context, serviceIntentActionOrName, servicePackage, null, enableLookupByName, 0, converter);
    }

    AndroidServiceBinder(@NonNull Context context, @NonNull String serviceIntentActionOrName, @NonNull String servicePackage, @NonNull String isolatedProcessName, boolean enableLookupByName, int bindFlags, @NonNull Function<IBinder, T> converter) {
        this(context, serviceIntentActionOrName, List.of(servicePackage), isolatedProcessName, enableLookupByName, bindFlags, converter);
    }

    private AndroidServiceBinder(@NonNull Context context, @NonNull String serviceIntentActionOrName, @NonNull List<String> servicePackages, @NonNull String isolatedProcessName, boolean enableLookupByName, int bindFlags, @NonNull Function<IBinder, T> converter) {
        this.mServiceIntentActionOrName = serviceIntentActionOrName;
        this.mContext = context;
        this.mBinderConverter = converter;
        this.mServicePackages = servicePackages;
        this.mEnableLookupByServiceName = enableLookupByName;
        this.mBindFlags = bindFlags;
        this.mIsolatedProcessName = isolatedProcessName;
    }

    @Override
    public T getService(@NonNull Executor executor) {
        int retryAttempts = 0;
        IllegalStateException exceptionInfo = null;
        while (retryAttempts < 2) {
            try {
                T service = this.getServiceWithoutRetry(executor);
                if (service != null) {
                    return service;
                }
            }
            catch (IllegalStateException e) {
                LogUtil.e(TAG, e, "Failed to get service on attempt " + (retryAttempts + 1));
                exceptionInfo = e;
            }
            ++retryAttempts;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LogUtil.w(TAG, "Thread sleep interrupted");
            }
        }
        throw exceptionInfo != null ? exceptionInfo : new IllegalStateException(String.format("Failed to get non-null service %s after %d retries", this.mServiceIntentActionOrName, retryAttempts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getServiceWithoutRetry(@NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null) {
                return this.mService;
            }
            if (this.mServiceConnection == null) {
                boolean result;
                Intent bindIntent = this.mEnableLookupByServiceName ? this.getIntentBasedOnServiceName() : this.getIntentBasedOnAction();
                this.mConnectionCountDownLatch = new CountDownLatch(1);
                this.mServiceConnection = new GenericServiceConnection();
                boolean bl = result = this.mIsolatedProcessName != null ? this.mContext.bindIsolatedService(bindIntent, 1 | this.mBindFlags, this.mIsolatedProcessName, executor, this.mServiceConnection) : this.mContext.bindService(bindIntent, 1 | this.mBindFlags, executor, this.mServiceConnection);
                if (!result) {
                    this.mServiceConnection = null;
                    throw new IllegalStateException(String.format("Unable to bind to the service %s", this.mServiceIntentActionOrName));
                }
                LogUtil.i(TAG, "bindService() %s succeeded...", this.mServiceIntentActionOrName);
            } else {
                LogUtil.i(TAG, "bindService() %s already pending...", this.mServiceIntentActionOrName);
            }
        }
        try {
            this.mConnectionCountDownLatch.await(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LogUtil.e(TAG, "Failed to connect to the service %s ", this.mServiceIntentActionOrName);
            throw new IllegalStateException("Thread interrupted");
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mService == null) {
                throw new IllegalStateException(String.format("Failed to connect to the service %s", this.mServiceIntentActionOrName));
            }
            return this.mService;
        }
    }

    private Intent getIntentBasedOnServiceName() {
        Intent intent = new Intent();
        ComponentName serviceComponent = new ComponentName(this.mServicePackages.get(0), this.mServiceIntentActionOrName);
        intent.setComponent(serviceComponent);
        return intent;
    }

    private Intent getIntentBasedOnAction() {
        Intent intent = new Intent(this.mServiceIntentActionOrName);
        ComponentName serviceComponent = this.resolveComponentName(intent);
        if (serviceComponent == null) {
            LogUtil.e(TAG, "Invalid component for %s intent", this.mServiceIntentActionOrName);
            throw new IllegalStateException(String.format("Invalid component for %s service", this.mServiceIntentActionOrName));
        }
        intent.setComponent(serviceComponent);
        return intent;
    }

    @Nullable
    private ComponentName resolveComponentName(@NonNull Intent intent) {
        List<ResolveInfo> services = this.mContext.getPackageManager().queryIntentServices(intent, 0x100000);
        if (services == null || services.isEmpty()) {
            LogUtil.e(TAG, "Failed to find service %s!", intent.getAction());
            return null;
        }
        if (services.size() != 1) {
            LogUtil.i(TAG, "Found more than 1 (%d) service by intent %s!", services.size(), intent);
        }
        for (ResolveInfo ri : services) {
            if (ri != null && ri.serviceInfo != null && ri.serviceInfo.packageName != null && this.mServicePackages.contains(ri.serviceInfo.packageName)) {
                LogUtil.d(TAG, "Resolved component with pkg %s, class %s", ri.serviceInfo.packageName, ri.serviceInfo.name);
                return new ComponentName(ri.serviceInfo.packageName, ri.serviceInfo.name);
            }
            if (ri != null && ri.serviceInfo != null) {
                LogUtil.d(TAG, "Resolved component with pkg %s, class %s", ri.serviceInfo.packageName, ri.serviceInfo.name);
                continue;
            }
            LogUtil.d(TAG, "Resolved component is null or service info is null");
        }
        LogUtil.e(TAG, "Didn't find any matching service %s.", intent.getAction());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFromService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                LogUtil.d(TAG, "unbinding %s...", this.mServiceIntentActionOrName);
                try {
                    this.mContext.unbindService(this.mServiceConnection);
                }
                catch (IllegalArgumentException e) {
                    LogUtil.e(TAG, e, "unbinding failed %s", this.mServiceIntentActionOrName);
                }
            }
            this.mServiceConnection = null;
            this.mService = null;
        }
    }

    private class GenericServiceConnection
    implements ServiceConnection {
        private GenericServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            LogUtil.d(TAG, "onServiceConnected " + AndroidServiceBinder.this.mServiceIntentActionOrName);
            Object object = AndroidServiceBinder.this.mLock;
            synchronized (object) {
                AndroidServiceBinder.this.mService = AndroidServiceBinder.this.mBinderConverter.apply(service);
            }
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            LogUtil.d(TAG, "onServiceDisconnected " + AndroidServiceBinder.this.mServiceIntentActionOrName);
            AndroidServiceBinder.this.unbindFromService();
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }

        @Override
        public void onBindingDied(ComponentName name) {
            LogUtil.w(TAG, "onBindingDied " + AndroidServiceBinder.this.mServiceIntentActionOrName);
            AndroidServiceBinder.this.unbindFromService();
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }

        @Override
        public void onNullBinding(ComponentName name) {
            LogUtil.w(TAG, "onNullBinding shouldn't happen. " + AndroidServiceBinder.this.mServiceIntentActionOrName);
            AndroidServiceBinder.this.unbindFromService();
            AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
        }
    }
}

