/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.TaskFragmentOrganizerToken;

public class TaskFragmentCreationParams
implements Parcelable {
    @NonNull
    private final TaskFragmentOrganizerToken mOrganizer;
    @NonNull
    private final IBinder mFragmentToken;
    @NonNull
    private final IBinder mOwnerToken;
    @NonNull
    private final Rect mInitialRelativeBounds = new Rect();
    private final int mWindowingMode;
    @Nullable
    private final IBinder mPairedPrimaryFragmentToken;
    @Nullable
    private final IBinder mPairedActivityToken;
    private final boolean mAllowTransitionWhenEmpty;
    private final int mOverrideOrientation;
    private final int mConfigurationChangeMask;
    @NonNull
    public static final Parcelable.Creator<TaskFragmentCreationParams> CREATOR = new Parcelable.Creator<TaskFragmentCreationParams>(){

        @Override
        public TaskFragmentCreationParams createFromParcel(Parcel in) {
            return new TaskFragmentCreationParams(in);
        }

        public TaskFragmentCreationParams[] newArray(int size) {
            return new TaskFragmentCreationParams[size];
        }
    };

    private TaskFragmentCreationParams(@NonNull TaskFragmentOrganizerToken organizer, @NonNull IBinder fragmentToken, @NonNull IBinder ownerToken, @NonNull Rect initialRelativeBounds, int windowingMode, @Nullable IBinder pairedPrimaryFragmentToken, @Nullable IBinder pairedActivityToken, boolean allowTransitionWhenEmpty, int overrideOrientation, int configurationChangeMask) {
        if (pairedPrimaryFragmentToken != null && pairedActivityToken != null) {
            throw new IllegalArgumentException("pairedPrimaryFragmentToken and pairedActivityToken should not be set at the same time.");
        }
        this.mOrganizer = organizer;
        this.mFragmentToken = fragmentToken;
        this.mOwnerToken = ownerToken;
        this.mInitialRelativeBounds.set(initialRelativeBounds);
        this.mWindowingMode = windowingMode;
        this.mPairedPrimaryFragmentToken = pairedPrimaryFragmentToken;
        this.mPairedActivityToken = pairedActivityToken;
        this.mAllowTransitionWhenEmpty = allowTransitionWhenEmpty;
        this.mOverrideOrientation = overrideOrientation;
        this.mConfigurationChangeMask = configurationChangeMask;
    }

    @NonNull
    public TaskFragmentOrganizerToken getOrganizer() {
        return this.mOrganizer;
    }

    @NonNull
    public IBinder getFragmentToken() {
        return this.mFragmentToken;
    }

    @NonNull
    public IBinder getOwnerToken() {
        return this.mOwnerToken;
    }

    @NonNull
    public Rect getInitialRelativeBounds() {
        return this.mInitialRelativeBounds;
    }

    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    @Nullable
    public IBinder getPairedPrimaryFragmentToken() {
        return this.mPairedPrimaryFragmentToken;
    }

    @Nullable
    public IBinder getPairedActivityToken() {
        return this.mPairedActivityToken;
    }

    public boolean getAllowTransitionWhenEmpty() {
        return this.mAllowTransitionWhenEmpty;
    }

    public int getOverrideOrientation() {
        return this.mOverrideOrientation;
    }

    public int getConfigurationChangeMask() {
        return this.mConfigurationChangeMask;
    }

    private TaskFragmentCreationParams(Parcel in) {
        this.mOrganizer = TaskFragmentOrganizerToken.CREATOR.createFromParcel(in);
        this.mFragmentToken = in.readStrongBinder();
        this.mOwnerToken = in.readStrongBinder();
        this.mInitialRelativeBounds.readFromParcel(in);
        this.mWindowingMode = in.readInt();
        this.mPairedPrimaryFragmentToken = in.readStrongBinder();
        this.mPairedActivityToken = in.readStrongBinder();
        this.mAllowTransitionWhenEmpty = in.readBoolean();
        this.mOverrideOrientation = in.readInt();
        this.mConfigurationChangeMask = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mOrganizer.writeToParcel(dest, flags);
        dest.writeStrongBinder(this.mFragmentToken);
        dest.writeStrongBinder(this.mOwnerToken);
        this.mInitialRelativeBounds.writeToParcel(dest, flags);
        dest.writeInt(this.mWindowingMode);
        dest.writeStrongBinder(this.mPairedPrimaryFragmentToken);
        dest.writeStrongBinder(this.mPairedActivityToken);
        dest.writeBoolean(this.mAllowTransitionWhenEmpty);
        dest.writeInt(this.mOverrideOrientation);
        dest.writeInt(this.mConfigurationChangeMask);
    }

    public String toString() {
        return "TaskFragmentCreationParams{ organizer=" + this.mOrganizer + " fragmentToken=" + this.mFragmentToken + " ownerToken=" + this.mOwnerToken + " initialRelativeBounds=" + this.mInitialRelativeBounds + " windowingMode=" + this.mWindowingMode + " pairedFragmentToken=" + this.mPairedPrimaryFragmentToken + " pairedActivityToken=" + this.mPairedActivityToken + " allowTransitionWhenEmpty=" + this.mAllowTransitionWhenEmpty + " overrideOrientation=" + this.mOverrideOrientation + " configurationChangeMask=" + this.mConfigurationChangeMask + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        @NonNull
        private final TaskFragmentOrganizerToken mOrganizer;
        @NonNull
        private final IBinder mFragmentToken;
        @NonNull
        private final IBinder mOwnerToken;
        @NonNull
        private final Rect mInitialRelativeBounds = new Rect();
        private int mWindowingMode = 0;
        @Nullable
        private IBinder mPairedPrimaryFragmentToken;
        @Nullable
        private IBinder mPairedActivityToken;
        private boolean mAllowTransitionWhenEmpty;
        private int mOverrideOrientation = -1;
        private int mConfigurationChangeMask = 0;

        public Builder(@NonNull TaskFragmentOrganizerToken organizer, @NonNull IBinder fragmentToken, @NonNull IBinder ownerToken) {
            this.mOrganizer = organizer;
            this.mFragmentToken = fragmentToken;
            this.mOwnerToken = ownerToken;
        }

        @NonNull
        public Builder setInitialRelativeBounds(@NonNull Rect bounds) {
            this.mInitialRelativeBounds.set(bounds);
            return this;
        }

        @NonNull
        public Builder setWindowingMode(int windowingMode) {
            this.mWindowingMode = windowingMode;
            return this;
        }

        @NonNull
        public Builder setPairedPrimaryFragmentToken(@Nullable IBinder fragmentToken) {
            this.mPairedPrimaryFragmentToken = fragmentToken;
            return this;
        }

        @NonNull
        public Builder setPairedActivityToken(@Nullable IBinder activityToken) {
            this.mPairedActivityToken = activityToken;
            return this;
        }

        @NonNull
        public Builder setAllowTransitionWhenEmpty(boolean allowTransitionWhenEmpty) {
            this.mAllowTransitionWhenEmpty = allowTransitionWhenEmpty;
            return this;
        }

        @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
        @NonNull
        public Builder setOverrideOrientation(int overrideOrientation) {
            this.mOverrideOrientation = overrideOrientation;
            return this;
        }

        @NonNull
        public Builder setConfigurationChangeMask(int configurationChangeMask) {
            this.mConfigurationChangeMask = configurationChangeMask;
            return this;
        }

        @NonNull
        public TaskFragmentCreationParams build() {
            return new TaskFragmentCreationParams(this.mOrganizer, this.mFragmentToken, this.mOwnerToken, this.mInitialRelativeBounds, this.mWindowingMode, this.mPairedPrimaryFragmentToken, this.mPairedActivityToken, this.mAllowTransitionWhenEmpty, this.mOverrideOrientation, this.mConfigurationChangeMask);
        }
    }
}

