/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.window.ConfigurationDispatcher;
import android.window.WindowTokenClient;
import android.window.WindowTokenClientController;
import java.util.Objects;

public class SystemUiContext
extends ContextWrapper
implements ConfigurationDispatcher {
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();

    public SystemUiContext(Context base) {
        super(base);
    }

    @Override
    public void registerComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.registerCallbacks(callback);
    }

    @Override
    public void unregisterComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.unregisterCallbacks(callback);
    }

    @Override
    public void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        this.mCallbacksController.dispatchConfigurationChanged(newConfig);
    }

    @Override
    public boolean shouldReportPrivateChanges() {
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            WindowTokenClient token = (WindowTokenClient)this.getWindowContextToken();
            WindowTokenClientController.getInstance().detachIfNeeded(Objects.requireNonNull(token));
        }
        finally {
            super.finalize();
        }
    }
}

