/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;

public class SizeConfigurationBuckets
implements Parcelable {
    @Nullable
    private final int[] mHorizontal;
    @Nullable
    private final int[] mVertical;
    @Nullable
    private final int[] mSmallest;
    @Nullable
    private final int[] mScreenLayoutSize;
    private final boolean mScreenLayoutLongSet;
    @NonNull
    public static final Parcelable.Creator<SizeConfigurationBuckets> CREATOR = new Parcelable.Creator<SizeConfigurationBuckets>(){

        public SizeConfigurationBuckets[] newArray(int size) {
            return new SizeConfigurationBuckets[size];
        }

        @Override
        public SizeConfigurationBuckets createFromParcel(@NonNull Parcel in) {
            return new SizeConfigurationBuckets(in);
        }
    };

    public SizeConfigurationBuckets(Configuration[] sizeConfigurations) {
        SparseIntArray horizontal = new SparseIntArray();
        SparseIntArray vertical = new SparseIntArray();
        SparseIntArray smallest = new SparseIntArray();
        SparseIntArray screenLayoutSize = new SparseIntArray();
        boolean screenLayoutLongSet = false;
        for (int i = sizeConfigurations.length - 1; i >= 0; --i) {
            int curScreenLayoutSize;
            Configuration config = sizeConfigurations[i];
            if (config.screenHeightDp != 0) {
                vertical.put(config.screenHeightDp, 0);
            }
            if (config.screenWidthDp != 0) {
                horizontal.put(config.screenWidthDp, 0);
            }
            if (config.smallestScreenWidthDp != 0) {
                smallest.put(config.smallestScreenWidthDp, 0);
            }
            if ((curScreenLayoutSize = config.screenLayout & 0xF) != 0) {
                screenLayoutSize.put(curScreenLayoutSize, 0);
            }
            if (screenLayoutLongSet || (config.screenLayout & 0x30) == 0) continue;
            screenLayoutLongSet = true;
        }
        this.mHorizontal = horizontal.copyKeys();
        this.mVertical = vertical.copyKeys();
        this.mSmallest = smallest.copyKeys();
        this.mScreenLayoutSize = screenLayoutSize.copyKeys();
        this.mScreenLayoutLongSet = screenLayoutLongSet;
    }

    public static int filterDiff(int diff, @NonNull Configuration oldConfig, @NonNull Configuration newConfig, @Nullable SizeConfigurationBuckets buckets) {
        int newSmallest;
        int oldSmallest;
        if (buckets == null) {
            return diff;
        }
        boolean nonSizeLayoutFieldsUnchanged = SizeConfigurationBuckets.areNonSizeLayoutFieldsUnchanged(oldConfig.screenLayout, newConfig.screenLayout);
        if ((diff & 0x400) != 0) {
            boolean crosses;
            boolean bl = crosses = buckets.crossesHorizontalSizeThreshold(oldConfig.screenWidthDp, newConfig.screenWidthDp) || buckets.crossesVerticalSizeThreshold(oldConfig.screenHeightDp, newConfig.screenHeightDp);
            if (!crosses) {
                diff &= 0xFFFFFBFF;
            }
        }
        if ((diff & 0x800) != 0 && !buckets.crossesSmallestSizeThreshold(oldSmallest = oldConfig.smallestScreenWidthDp, newSmallest = newConfig.smallestScreenWidthDp)) {
            diff &= 0xFFFFF7FF;
        }
        if ((diff & 0x100) != 0 && nonSizeLayoutFieldsUnchanged && !buckets.crossesScreenLayoutSizeThreshold(oldConfig, newConfig) && !buckets.crossesScreenLayoutLongThreshold(oldConfig.screenLayout, newConfig.screenLayout)) {
            diff &= 0xFFFFFEFF;
        }
        return diff;
    }

    private boolean crossesHorizontalSizeThreshold(int firstDp, int secondDp) {
        return SizeConfigurationBuckets.crossesSizeThreshold(this.mHorizontal, firstDp, secondDp);
    }

    private boolean crossesVerticalSizeThreshold(int firstDp, int secondDp) {
        return SizeConfigurationBuckets.crossesSizeThreshold(this.mVertical, firstDp, secondDp);
    }

    private boolean crossesSmallestSizeThreshold(int firstDp, int secondDp) {
        return SizeConfigurationBuckets.crossesSizeThreshold(this.mSmallest, firstDp, secondDp);
    }

    @VisibleForTesting
    public boolean crossesScreenLayoutSizeThreshold(@NonNull Configuration firstConfig, @NonNull Configuration secondConfig) {
        if ((firstConfig.screenLayout & 0xF) == (secondConfig.screenLayout & 0xF)) {
            return false;
        }
        if (!secondConfig.isLayoutSizeAtLeast(firstConfig.screenLayout & 0xF)) {
            return true;
        }
        if (this.mScreenLayoutSize != null) {
            for (int screenLayoutSize : this.mScreenLayoutSize) {
                if (firstConfig.isLayoutSizeAtLeast(screenLayoutSize) == secondConfig.isLayoutSizeAtLeast(screenLayoutSize)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean crossesScreenLayoutLongThreshold(int firstScreenLayout, int secondScreenLayout) {
        int firstScreenLayoutLongValue = firstScreenLayout & 0x30;
        int secondScreenLayoutLongValue = secondScreenLayout & 0x30;
        return this.mScreenLayoutLongSet && firstScreenLayoutLongValue != secondScreenLayoutLongValue;
    }

    @VisibleForTesting
    public static boolean areNonSizeLayoutFieldsUnchanged(int oldScreenLayout, int newScreenLayout) {
        int nonSizeRelatedFields = 268436416;
        return (oldScreenLayout & 0x100003C0) == (newScreenLayout & 0x100003C0);
    }

    @VisibleForTesting
    public static boolean crossesSizeThreshold(int[] thresholds, int firstDp, int secondDp) {
        if (thresholds == null) {
            return false;
        }
        for (int i = thresholds.length - 1; i >= 0; --i) {
            int threshold = thresholds[i];
            if ((firstDp >= threshold || secondDp < threshold) && (firstDp < threshold || secondDp >= threshold)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.mHorizontal) + " " + Arrays.toString(this.mVertical) + " " + Arrays.toString(this.mSmallest) + " " + Arrays.toString(this.mScreenLayoutSize) + " " + this.mScreenLayoutLongSet;
    }

    public SizeConfigurationBuckets(@Nullable int[] horizontal, @Nullable int[] vertical, @Nullable int[] smallest, @Nullable int[] screenLayoutSize, boolean screenLayoutLongSet) {
        this.mHorizontal = horizontal;
        this.mVertical = vertical;
        this.mSmallest = smallest;
        this.mScreenLayoutSize = screenLayoutSize;
        this.mScreenLayoutLongSet = screenLayoutLongSet;
    }

    @Nullable
    public int[] getHorizontal() {
        return this.mHorizontal;
    }

    @Nullable
    public int[] getVertical() {
        return this.mVertical;
    }

    @Nullable
    public int[] getSmallest() {
        return this.mSmallest;
    }

    @Nullable
    public int[] getScreenLayoutSize() {
        return this.mScreenLayoutSize;
    }

    public boolean isScreenLayoutLongSet() {
        return this.mScreenLayoutLongSet;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mScreenLayoutLongSet) {
            flg = (byte)(flg | 0x10);
        }
        if (this.mHorizontal != null) {
            flg = (byte)(flg | 1);
        }
        if (this.mVertical != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mSmallest != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mScreenLayoutSize != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        if (this.mHorizontal != null) {
            dest.writeIntArray(this.mHorizontal);
        }
        if (this.mVertical != null) {
            dest.writeIntArray(this.mVertical);
        }
        if (this.mSmallest != null) {
            dest.writeIntArray(this.mSmallest);
        }
        if (this.mScreenLayoutSize != null) {
            dest.writeIntArray(this.mScreenLayoutSize);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    SizeConfigurationBuckets(@NonNull Parcel in) {
        byte flg = in.readByte();
        boolean screenLayoutLongSet = (flg & 0x10) != 0;
        int[] horizontal = (flg & 1) == 0 ? null : in.createIntArray();
        int[] vertical = (flg & 2) == 0 ? null : in.createIntArray();
        int[] smallest = (flg & 4) == 0 ? null : in.createIntArray();
        int[] screenLayoutSize = (flg & 8) == 0 ? null : in.createIntArray();
        this.mHorizontal = horizontal;
        this.mVertical = vertical;
        this.mSmallest = smallest;
        this.mScreenLayoutSize = screenLayoutSize;
        this.mScreenLayoutLongSet = screenLayoutLongSet;
    }

    @Deprecated
    private void __metadata() {
    }
}

