/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.Gainmap;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.util.Log;
import android.view.SurfaceControl;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.ObjIntConsumer;
import libcore.util.NativeAllocationRegistry;

public class ScreenCapture {
    private static final String TAG = "ScreenCapture";
    private static final int SCREENSHOT_WAIT_TIME_S = 4 * _Original_Build.HW_TIMEOUT_MULTIPLIER;

    private static int nativeCaptureDisplay(DisplayCaptureArgs displayCaptureArgs, long l) {
        return OverrideMethod.invokeI("android.window.ScreenCapture#nativeCaptureDisplay(Landroid/window/ScreenCapture$DisplayCaptureArgs;J)I", true, null);
    }

    private static int nativeCaptureLayers(LayerCaptureArgs layerCaptureArgs, long l, boolean bl) {
        return OverrideMethod.invokeI("android.window.ScreenCapture#nativeCaptureLayers(Landroid/window/ScreenCapture$LayerCaptureArgs;JZ)I", true, null);
    }

    private static long nativeCreateScreenCaptureListener(ObjIntConsumer<ScreenshotHardwareBuffer> objIntConsumer) {
        return OverrideMethod.invokeL("android.window.ScreenCapture#nativeCreateScreenCaptureListener(Ljava/util/function/ObjIntConsumer;)J", true, null);
    }

    private static void nativeWriteListenerToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.window.ScreenCapture#nativeWriteListenerToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nativeReadListenerFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.window.ScreenCapture#nativeReadListenerFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static long getNativeListenerFinalizer() {
        return OverrideMethod.invokeL("android.window.ScreenCapture#getNativeListenerFinalizer()J", true, null);
    }

    public static int captureDisplay(@NonNull DisplayCaptureArgs captureArgs, @NonNull ScreenCaptureListener captureListener) {
        return ScreenCapture.nativeCaptureDisplay(captureArgs, captureListener.mNativeObject);
    }

    public static ScreenshotHardwareBuffer captureDisplay(DisplayCaptureArgs captureArgs) {
        SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        int status = ScreenCapture.captureDisplay(captureArgs, syncScreenCapture);
        if (status != 0) {
            return null;
        }
        try {
            return syncScreenCapture.getBuffer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ScreenshotHardwareBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale) {
        return ScreenCapture.captureLayers(layer, sourceCrop, frameScale, 1);
    }

    public static ScreenshotHardwareBuffer captureLayers(@NonNull SurfaceControl layer, @Nullable Rect sourceCrop, float frameScale, int format) {
        LayerCaptureArgs captureArgs = ((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)new LayerCaptureArgs.Builder(layer).setSourceCrop(sourceCrop)).setFrameScale(frameScale)).setPixelFormat(format)).build();
        return ScreenCapture.captureLayers(captureArgs);
    }

    public static ScreenshotHardwareBuffer captureLayers(LayerCaptureArgs captureArgs) {
        SynchronousScreenCaptureListener syncScreenCapture = ScreenCapture.createSyncCaptureListener();
        int status = ScreenCapture.nativeCaptureLayers(captureArgs, syncScreenCapture.mNativeObject, Flags.syncScreenCapture());
        if (status != 0) {
            return null;
        }
        try {
            return syncScreenCapture.getBuffer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ScreenshotHardwareBuffer captureLayersExcluding(SurfaceControl layer, Rect sourceCrop, float frameScale, int format, SurfaceControl[] exclude) {
        LayerCaptureArgs captureArgs = ((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)new LayerCaptureArgs.Builder(layer).setSourceCrop(sourceCrop)).setFrameScale(frameScale)).setPixelFormat(format)).setExcludeLayers(exclude)).build();
        return ScreenCapture.captureLayers(captureArgs);
    }

    public static int captureLayers(@NonNull LayerCaptureArgs captureArgs, @NonNull ScreenCaptureListener captureListener) {
        return ScreenCapture.nativeCaptureLayers(captureArgs, captureListener.mNativeObject, false);
    }

    public static SynchronousScreenCaptureListener createSyncCaptureListener() {
        final ScreenshotHardwareBuffer[] bufferRef = new ScreenshotHardwareBuffer[1];
        final CountDownLatch latch = new CountDownLatch(1);
        final ObjIntConsumer<ScreenshotHardwareBuffer> consumer = (buffer, status) -> {
            if (status != 0) {
                bufferRef[0] = null;
                Log.e(TAG, "Failed to generate screen capture. Error code: " + status);
            } else {
                bufferRef[0] = buffer;
            }
            latch.countDown();
        };
        return new SynchronousScreenCaptureListener(consumer){
            private ObjIntConsumer<ScreenshotHardwareBuffer> mConsumer;
            {
                super(consumer2);
                this.mConsumer = consumer;
            }

            @Override
            public ScreenshotHardwareBuffer getBuffer() {
                try {
                    if (!latch.await(SCREENSHOT_WAIT_TIME_S, TimeUnit.SECONDS)) {
                        Log.e(ScreenCapture.TAG, "Timed out waiting for screenshot results");
                        return null;
                    }
                    return bufferRef[0];
                }
                catch (Exception e) {
                    Log.e(ScreenCapture.TAG, "Failed to wait for screen capture result", e);
                    return null;
                }
            }
        };
    }

    public static class ScreenCaptureListener
    implements Parcelable {
        final long mNativeObject;
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(ScreenCaptureListener.class.getClassLoader(), ScreenCapture.getNativeListenerFinalizer());
        public static final Parcelable.Creator<ScreenCaptureListener> CREATOR = new Parcelable.Creator<ScreenCaptureListener>(){

            @Override
            public ScreenCaptureListener createFromParcel(Parcel in) {
                return new ScreenCaptureListener(in);
            }

            public ScreenCaptureListener[] newArray(int size) {
                return new ScreenCaptureListener[0];
            }
        };

        public ScreenCaptureListener(ObjIntConsumer<ScreenshotHardwareBuffer> consumer) {
            this.mNativeObject = ScreenCapture.nativeCreateScreenCaptureListener(consumer);
            sRegistry.registerNativeAllocation(this, this.mNativeObject);
        }

        private ScreenCaptureListener(Parcel in) {
            if (in.readBoolean()) {
                this.mNativeObject = ScreenCapture.nativeReadListenerFromParcel(in);
                sRegistry.registerNativeAllocation(this, this.mNativeObject);
            } else {
                this.mNativeObject = 0L;
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            if (this.mNativeObject == 0L) {
                dest.writeBoolean(false);
            } else {
                dest.writeBoolean(true);
                ScreenCapture.nativeWriteListenerToParcel(this.mNativeObject, dest);
            }
        }
    }

    public static class DisplayCaptureArgs
    extends CaptureArgs {
        private final IBinder mDisplayToken;
        private final int mWidth;
        private final int mHeight;

        private DisplayCaptureArgs(Builder builder) {
            super(builder);
            this.mDisplayToken = builder.mDisplayToken;
            this.mWidth = builder.mWidth;
            this.mHeight = builder.mHeight;
        }

        public static class Builder
        extends CaptureArgs.Builder<Builder> {
            private IBinder mDisplayToken;
            private int mWidth;
            private int mHeight;

            @Override
            public DisplayCaptureArgs build() {
                if (this.mDisplayToken == null) {
                    throw new IllegalStateException("Can't take screenshot with null display token");
                }
                return new DisplayCaptureArgs(this);
            }

            public Builder(IBinder displayToken) {
                this.setDisplayToken(displayToken);
            }

            public Builder setDisplayToken(IBinder displayToken) {
                this.mDisplayToken = displayToken;
                return this;
            }

            public Builder setSize(int width, int height) {
                this.mWidth = width;
                this.mHeight = height;
                return this;
            }

            @Override
            Builder getThis() {
                return this;
            }
        }
    }

    public static abstract class SynchronousScreenCaptureListener
    extends ScreenCaptureListener {
        SynchronousScreenCaptureListener(ObjIntConsumer<ScreenshotHardwareBuffer> consumer) {
            super(consumer);
        }

        @Nullable
        public abstract ScreenshotHardwareBuffer getBuffer();
    }

    public static class ScreenshotHardwareBuffer {
        private static final float EPSILON = 0.015625f;
        private final HardwareBuffer mHardwareBuffer;
        private final ColorSpace mColorSpace;
        private final boolean mContainsSecureLayers;
        private final boolean mContainsHdrLayers;
        private final HardwareBuffer mGainmap;
        private final float mHdrSdrRatio;

        public ScreenshotHardwareBuffer(HardwareBuffer hardwareBuffer, ColorSpace colorSpace, boolean containsSecureLayers, boolean containsHdrLayers) {
            this(hardwareBuffer, colorSpace, containsSecureLayers, containsHdrLayers, null, 1.0f);
        }

        public ScreenshotHardwareBuffer(HardwareBuffer hardwareBuffer, ColorSpace colorSpace, boolean containsSecureLayers, boolean containsHdrLayers, HardwareBuffer gainmap, float hdrSdrRatio) {
            this.mHardwareBuffer = hardwareBuffer;
            this.mColorSpace = colorSpace;
            this.mContainsSecureLayers = containsSecureLayers;
            this.mContainsHdrLayers = containsHdrLayers;
            this.mGainmap = gainmap;
            this.mHdrSdrRatio = hdrSdrRatio;
        }

        private static ScreenshotHardwareBuffer createFromNative(HardwareBuffer hardwareBuffer, int dataspace, boolean containsSecureLayers, boolean containsHdrLayers, HardwareBuffer gainmap, float hdrSdrRatio) {
            ColorSpace colorSpace = ColorSpace.getFromDataSpace(dataspace);
            return new ScreenshotHardwareBuffer(hardwareBuffer, colorSpace != null ? colorSpace : ColorSpace.get(ColorSpace.Named.SRGB), containsSecureLayers, containsHdrLayers, gainmap, hdrSdrRatio);
        }

        public ColorSpace getColorSpace() {
            return this.mColorSpace;
        }

        public HardwareBuffer getHardwareBuffer() {
            return this.mHardwareBuffer;
        }

        public boolean containsSecureLayers() {
            return this.mContainsSecureLayers;
        }

        public boolean containsHdrLayers() {
            return this.mContainsHdrLayers;
        }

        public Bitmap asBitmap() {
            if (this.mHardwareBuffer == null) {
                Log.w(ScreenCapture.TAG, "Failed to take screenshot. Null screenshot object");
                return null;
            }
            Bitmap bitmap = Bitmap.wrapHardwareBuffer(this.mHardwareBuffer, this.mColorSpace);
            if (this.mGainmap != null) {
                Bitmap gainmapBitmap = Bitmap.wrapHardwareBuffer(this.mGainmap, null);
                Gainmap gainmap = new Gainmap(gainmapBitmap);
                gainmap.setRatioMin(1.0f, 1.0f, 1.0f);
                gainmap.setRatioMax(this.mHdrSdrRatio, this.mHdrSdrRatio, this.mHdrSdrRatio);
                gainmap.setGamma(1.0f, 1.0f, 1.0f);
                gainmap.setEpsilonSdr(0.015625f, 0.015625f, 0.015625f);
                gainmap.setEpsilonHdr(0.015625f, 0.015625f, 0.015625f);
                gainmap.setMinDisplayRatioForHdrTransition(1.0f);
                gainmap.setDisplayRatioForFullHdr(this.mHdrSdrRatio);
                bitmap.setGainmap(gainmap);
            }
            return bitmap;
        }
    }

    public static class LayerCaptureArgs
    extends CaptureArgs {
        private final long mNativeLayer;
        private final boolean mChildrenOnly;

        private LayerCaptureArgs(Builder builder) {
            super(builder);
            this.mChildrenOnly = builder.mChildrenOnly;
            this.mNativeLayer = builder.mLayer.mNativeObject;
        }

        public static class Builder
        extends CaptureArgs.Builder<Builder> {
            private SurfaceControl mLayer;
            private boolean mChildrenOnly = true;

            @Override
            public LayerCaptureArgs build() {
                if (this.mLayer == null) {
                    throw new IllegalStateException("Can't take screenshot with null layer");
                }
                return new LayerCaptureArgs(this);
            }

            public Builder(SurfaceControl layer, CaptureArgs args) {
                this.setLayer(layer);
                this.setPixelFormat(args.mPixelFormat);
                this.setSourceCrop(args.mSourceCrop);
                this.setFrameScale(args.mFrameScaleX, args.mFrameScaleY);
                this.setCaptureSecureLayers(args.mCaptureSecureLayers);
                this.setAllowProtected(args.mAllowProtected);
                this.setUid(args.mUid);
                this.setGrayscale(args.mGrayscale);
                this.setExcludeLayers(args.mExcludeLayers);
                this.setHintForSeamlessTransition(args.mHintForSeamlessTransition);
            }

            public Builder(SurfaceControl layer) {
                this.setLayer(layer);
            }

            public Builder setLayer(SurfaceControl layer) {
                this.mLayer = layer;
                return this;
            }

            public Builder setChildrenOnly(boolean childrenOnly) {
                this.mChildrenOnly = childrenOnly;
                return this;
            }

            @Override
            Builder getThis() {
                return this;
            }
        }
    }

    public static class CaptureArgs
    implements Parcelable {
        public final int mPixelFormat;
        public final Rect mSourceCrop = new Rect();
        public final float mFrameScaleX;
        public final float mFrameScaleY;
        public final boolean mCaptureSecureLayers;
        public final boolean mAllowProtected;
        public final long mUid;
        public final boolean mGrayscale;
        final SurfaceControl[] mExcludeLayers;
        public final boolean mHintForSeamlessTransition;
        public static final Parcelable.Creator<CaptureArgs> CREATOR = new Parcelable.Creator<CaptureArgs>(){

            @Override
            public CaptureArgs createFromParcel(Parcel in) {
                return new CaptureArgs(in);
            }

            public CaptureArgs[] newArray(int size) {
                return new CaptureArgs[size];
            }
        };

        private CaptureArgs(Builder<? extends Builder<?>> builder) {
            this.mPixelFormat = builder.mPixelFormat;
            this.mSourceCrop.set(builder.mSourceCrop);
            this.mFrameScaleX = builder.mFrameScaleX;
            this.mFrameScaleY = builder.mFrameScaleY;
            this.mCaptureSecureLayers = builder.mCaptureSecureLayers;
            this.mAllowProtected = builder.mAllowProtected;
            this.mUid = builder.mUid;
            this.mGrayscale = builder.mGrayscale;
            this.mExcludeLayers = builder.mExcludeLayers;
            this.mHintForSeamlessTransition = builder.mHintForSeamlessTransition;
        }

        private CaptureArgs(Parcel in) {
            this.mPixelFormat = in.readInt();
            this.mSourceCrop.readFromParcel(in);
            this.mFrameScaleX = in.readFloat();
            this.mFrameScaleY = in.readFloat();
            this.mCaptureSecureLayers = in.readBoolean();
            this.mAllowProtected = in.readBoolean();
            this.mUid = in.readLong();
            this.mGrayscale = in.readBoolean();
            int excludeLayersLength = in.readInt();
            if (excludeLayersLength > 0) {
                this.mExcludeLayers = new SurfaceControl[excludeLayersLength];
                for (int index = 0; index < excludeLayersLength; ++index) {
                    this.mExcludeLayers[index] = SurfaceControl.CREATOR.createFromParcel(in);
                }
            } else {
                this.mExcludeLayers = null;
            }
            this.mHintForSeamlessTransition = in.readBoolean();
        }

        public void release() {
            if (this.mExcludeLayers == null || this.mExcludeLayers.length == 0) {
                return;
            }
            for (SurfaceControl surfaceControl : this.mExcludeLayers) {
                if (surfaceControl == null) continue;
                surfaceControl.release();
            }
        }

        private long[] getNativeExcludeLayers() {
            if (this.mExcludeLayers == null || this.mExcludeLayers.length == 0) {
                return new long[0];
            }
            long[] nativeExcludeLayers = new long[this.mExcludeLayers.length];
            for (int index = 0; index < this.mExcludeLayers.length; ++index) {
                nativeExcludeLayers[index] = this.mExcludeLayers[index].mNativeObject;
            }
            return nativeExcludeLayers;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mPixelFormat);
            this.mSourceCrop.writeToParcel(dest, flags);
            dest.writeFloat(this.mFrameScaleX);
            dest.writeFloat(this.mFrameScaleY);
            dest.writeBoolean(this.mCaptureSecureLayers);
            dest.writeBoolean(this.mAllowProtected);
            dest.writeLong(this.mUid);
            dest.writeBoolean(this.mGrayscale);
            if (this.mExcludeLayers != null) {
                dest.writeInt(this.mExcludeLayers.length);
                for (SurfaceControl excludeLayer : this.mExcludeLayers) {
                    excludeLayer.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
            dest.writeBoolean(this.mHintForSeamlessTransition);
        }

        public static class Builder<T extends Builder<T>> {
            private int mPixelFormat = 1;
            private final Rect mSourceCrop = new Rect();
            private float mFrameScaleX = 1.0f;
            private float mFrameScaleY = 1.0f;
            private boolean mCaptureSecureLayers;
            private boolean mAllowProtected;
            private long mUid = -1L;
            private boolean mGrayscale;
            private SurfaceControl[] mExcludeLayers;
            private boolean mHintForSeamlessTransition;

            public CaptureArgs build() {
                return new CaptureArgs(this);
            }

            public T setPixelFormat(int pixelFormat) {
                this.mPixelFormat = pixelFormat;
                return this.getThis();
            }

            public T setSourceCrop(@Nullable Rect sourceCrop) {
                if (sourceCrop == null) {
                    this.mSourceCrop.setEmpty();
                } else {
                    this.mSourceCrop.set(sourceCrop);
                }
                return this.getThis();
            }

            public T setFrameScale(float frameScale) {
                this.mFrameScaleX = frameScale;
                this.mFrameScaleY = frameScale;
                return this.getThis();
            }

            public T setFrameScale(float frameScaleX, float frameScaleY) {
                this.mFrameScaleX = frameScaleX;
                this.mFrameScaleY = frameScaleY;
                return this.getThis();
            }

            public T setCaptureSecureLayers(boolean captureSecureLayers) {
                this.mCaptureSecureLayers = captureSecureLayers;
                return this.getThis();
            }

            public T setAllowProtected(boolean allowProtected) {
                this.mAllowProtected = allowProtected;
                return this.getThis();
            }

            public T setUid(long uid) {
                this.mUid = uid;
                return this.getThis();
            }

            public T setGrayscale(boolean grayscale) {
                this.mGrayscale = grayscale;
                return this.getThis();
            }

            public T setExcludeLayers(@Nullable SurfaceControl[] excludeLayers) {
                this.mExcludeLayers = excludeLayers;
                return this.getThis();
            }

            public T setHintForSeamlessTransition(boolean hintForSeamlessTransition) {
                this.mHintForSeamlessTransition = hintForSeamlessTransition;
                return this.getThis();
            }

            T getThis() {
                return (T)this;
            }
        }
    }
}

