/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITaskFpsCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITaskFpsCallback";

    public void onFpsReported(float var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskFpsCallback {
        static final int TRANSACTION_onFpsReported = 1;

        public Stub() {
            this.attachInterface(this, ITaskFpsCallback.DESCRIPTOR);
        }

        public static ITaskFpsCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskFpsCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskFpsCallback) {
                return (ITaskFpsCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onFpsReported";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskFpsCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.onFpsReported(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ITaskFpsCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskFpsCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFpsReported(float fps) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ITaskFpsCallback.DESCRIPTOR);
                    _data.writeFloat(fps);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskFpsCallback {
        @Override
        public void onFpsReported(float fps) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

