/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMultitaskingControllerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IMultitaskingControllerCallback";

    public void onBubbleRemoved(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMultitaskingControllerCallback {
        static final int TRANSACTION_onBubbleRemoved = 1;

        public Stub() {
            this.attachInterface(this, IMultitaskingControllerCallback.DESCRIPTOR);
        }

        public static IMultitaskingControllerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMultitaskingControllerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMultitaskingControllerCallback) {
                return (IMultitaskingControllerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onBubbleRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMultitaskingControllerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.onBubbleRemoved(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IMultitaskingControllerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMultitaskingControllerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBubbleRemoved(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMultitaskingControllerCallback.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMultitaskingControllerCallback {
        @Override
        public void onBubbleRemoved(IBinder token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

