/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.RequiresPermission;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.IMultitaskingControllerCallback;
import android.window.IMultitaskingDelegate;

public interface IMultitaskingController
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IMultitaskingController";

    @RequiresPermission(value="android.permission.MANAGE_ACTIVITY_TASKS")
    public IMultitaskingControllerCallback setMultitaskingDelegate(IMultitaskingDelegate var1) throws RemoteException;

    @RequiresPermission(value="android.permission.REQUEST_SYSTEM_MULTITASKING_CONTROLS")
    public IMultitaskingDelegate getClientInterface(IMultitaskingControllerCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMultitaskingController {
        static final int TRANSACTION_setMultitaskingDelegate = 1;
        static final int TRANSACTION_getClientInterface = 2;

        public Stub() {
            this.attachInterface(this, IMultitaskingController.DESCRIPTOR);
        }

        public static IMultitaskingController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMultitaskingController.DESCRIPTOR);
            if (iin != null && iin instanceof IMultitaskingController) {
                return (IMultitaskingController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setMultitaskingDelegate";
                }
                case 2: {
                    return "getClientInterface";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMultitaskingController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IMultitaskingDelegate _arg0 = IMultitaskingDelegate.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IMultitaskingControllerCallback _result = this.setMultitaskingDelegate(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    IMultitaskingControllerCallback _arg0 = IMultitaskingControllerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IMultitaskingDelegate _result = this.getClientInterface(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IMultitaskingController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMultitaskingController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IMultitaskingControllerCallback setMultitaskingDelegate(IMultitaskingDelegate delegate) throws RemoteException {
                IMultitaskingControllerCallback _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMultitaskingController.DESCRIPTOR);
                    _data.writeStrongInterface(delegate);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IMultitaskingControllerCallback.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IMultitaskingDelegate getClientInterface(IMultitaskingControllerCallback callback) throws RemoteException {
                IMultitaskingDelegate _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IMultitaskingController.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = IMultitaskingDelegate.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IMultitaskingController {
        @Override
        public IMultitaskingControllerCallback setMultitaskingDelegate(IMultitaskingDelegate delegate) throws RemoteException {
            return null;
        }

        @Override
        public IMultitaskingDelegate getClientInterface(IMultitaskingControllerCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

