/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.WrapperListAdapter;
import java.util.ArrayList;

public class HeaderViewListAdapter
implements WrapperListAdapter,
Filterable {
    @UnsupportedAppUsage
    private final ListAdapter mAdapter;
    @UnsupportedAppUsage
    ArrayList<ListView.FixedViewInfo> mHeaderViewInfos;
    @UnsupportedAppUsage
    ArrayList<ListView.FixedViewInfo> mFooterViewInfos;
    static final ArrayList<ListView.FixedViewInfo> EMPTY_INFO_LIST = new ArrayList();
    boolean mAreAllFixedViewsSelectable;
    private final boolean mIsFilterable;

    public HeaderViewListAdapter(ArrayList<ListView.FixedViewInfo> headerViewInfos, ArrayList<ListView.FixedViewInfo> footerViewInfos, ListAdapter adapter) {
        this.mAdapter = adapter;
        this.mIsFilterable = adapter instanceof Filterable;
        this.mHeaderViewInfos = headerViewInfos == null ? EMPTY_INFO_LIST : headerViewInfos;
        this.mFooterViewInfos = footerViewInfos == null ? EMPTY_INFO_LIST : footerViewInfos;
        this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
    }

    public int getHeadersCount() {
        return this.mHeaderViewInfos.size();
    }

    public int getFootersCount() {
        return this.mFooterViewInfos.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mAdapter == null || this.mAdapter.isEmpty();
    }

    private boolean areAllListInfosSelectable(ArrayList<ListView.FixedViewInfo> infos) {
        if (infos != null) {
            for (ListView.FixedViewInfo info : infos) {
                if (info.isSelectable) continue;
                return false;
            }
        }
        return true;
    }

    public boolean removeHeader(View v) {
        for (int i = 0; i < this.mHeaderViewInfos.size(); ++i) {
            ListView.FixedViewInfo info = this.mHeaderViewInfos.get(i);
            if (info.view != v) continue;
            this.mHeaderViewInfos.remove(i);
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
            return true;
        }
        return false;
    }

    public boolean removeFooter(View v) {
        for (int i = 0; i < this.mFooterViewInfos.size(); ++i) {
            ListView.FixedViewInfo info = this.mFooterViewInfos.get(i);
            if (info.view != v) continue;
            this.mFooterViewInfos.remove(i);
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
            return true;
        }
        return false;
    }

    @Override
    public int getCount() {
        if (this.mAdapter != null) {
            return this.getFootersCount() + this.getHeadersCount() + this.mAdapter.getCount();
        }
        return this.getFootersCount() + this.getHeadersCount();
    }

    @Override
    public boolean areAllItemsEnabled() {
        if (this.mAdapter != null) {
            return this.mAreAllFixedViewsSelectable && this.mAdapter.areAllItemsEnabled();
        }
        return true;
    }

    @Override
    public boolean isEnabled(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).isSelectable;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.isEnabled(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).isSelectable;
    }

    @Override
    public Object getItem(int position) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).data;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItem(adjPosition);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).data;
    }

    @Override
    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.mAdapter != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItemId(adjPosition);
        }
        return -1L;
    }

    @Override
    public boolean hasStableIds() {
        if (this.mAdapter != null) {
            return this.mAdapter.hasStableIds();
        }
        return false;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        int numHeaders = this.getHeadersCount();
        if (position < numHeaders) {
            return this.mHeaderViewInfos.get((int)position).view;
        }
        int adjPosition = position - numHeaders;
        int adapterCount = 0;
        if (this.mAdapter != null && adjPosition < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getView(adjPosition, convertView, parent);
        }
        return this.mFooterViewInfos.get((int)(adjPosition - adapterCount)).view;
    }

    @Override
    public int getItemViewType(int position) {
        int adapterCount;
        int adjPosition;
        int numHeaders = this.getHeadersCount();
        if (this.mAdapter != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.mAdapter.getCount())) {
            return this.mAdapter.getItemViewType(adjPosition);
        }
        return -2;
    }

    @Override
    public int getViewTypeCount() {
        if (this.mAdapter != null) {
            return this.mAdapter.getViewTypeCount();
        }
        return 1;
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        if (this.mAdapter != null) {
            this.mAdapter.registerDataSetObserver(observer);
        }
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(observer);
        }
    }

    @Override
    public Filter getFilter() {
        if (this.mIsFilterable) {
            return ((Filterable)((Object)this.mAdapter)).getFilter();
        }
        return null;
    }

    @Override
    public ListAdapter getWrappedAdapter() {
        return this.mAdapter;
    }
}

