/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.CursorFilter;
import android.widget.Filter;
import android.widget.FilterQueryProvider;
import android.widget.Filterable;

public abstract class CursorTreeAdapter
extends BaseExpandableListAdapter
implements Filterable,
CursorFilter.CursorFilterClient {
    private Context mContext;
    private Handler mHandler;
    private boolean mAutoRequery;
    MyCursorHelper mGroupCursorHelper;
    SparseArray<MyCursorHelper> mChildrenCursorHelpers;
    CursorFilter mCursorFilter;
    FilterQueryProvider mFilterQueryProvider;

    public CursorTreeAdapter(Cursor cursor, Context context) {
        this.init(cursor, context, true);
    }

    public CursorTreeAdapter(Cursor cursor, Context context, boolean autoRequery) {
        this.init(cursor, context, autoRequery);
    }

    private void init(Cursor cursor, Context context, boolean autoRequery) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mAutoRequery = autoRequery;
        this.mGroupCursorHelper = new MyCursorHelper(cursor);
        this.mChildrenCursorHelpers = new SparseArray();
    }

    synchronized MyCursorHelper getChildrenCursorHelper(int groupPosition, boolean requestCursor) {
        MyCursorHelper cursorHelper = this.mChildrenCursorHelpers.get(groupPosition);
        if (cursorHelper == null) {
            if (this.mGroupCursorHelper.moveTo(groupPosition) == null) {
                return null;
            }
            Cursor cursor = this.getChildrenCursor(this.mGroupCursorHelper.getCursor());
            cursorHelper = new MyCursorHelper(cursor);
            this.mChildrenCursorHelpers.put(groupPosition, cursorHelper);
        }
        return cursorHelper;
    }

    protected abstract Cursor getChildrenCursor(Cursor var1);

    public void setGroupCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, false);
    }

    public void setChildrenCursor(int groupPosition, Cursor childrenCursor) {
        MyCursorHelper childrenCursorHelper = this.getChildrenCursorHelper(groupPosition, false);
        childrenCursorHelper.changeCursor(childrenCursor, false);
    }

    @Override
    public Cursor getChild(int groupPosition, int childPosition) {
        return this.getChildrenCursorHelper(groupPosition, true).moveTo(childPosition);
    }

    @Override
    public long getChildId(int groupPosition, int childPosition) {
        return this.getChildrenCursorHelper(groupPosition, true).getId(childPosition);
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        MyCursorHelper helper = this.getChildrenCursorHelper(groupPosition, true);
        return this.mGroupCursorHelper.isValid() && helper != null ? helper.getCount() : 0;
    }

    @Override
    public Cursor getGroup(int groupPosition) {
        return this.mGroupCursorHelper.moveTo(groupPosition);
    }

    @Override
    public int getGroupCount() {
        return this.mGroupCursorHelper.getCount();
    }

    @Override
    public long getGroupId(int groupPosition) {
        return this.mGroupCursorHelper.getId(groupPosition);
    }

    @Override
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        Cursor cursor = this.mGroupCursorHelper.moveTo(groupPosition);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View v = convertView == null ? this.newGroupView(this.mContext, cursor, isExpanded, parent) : convertView;
        this.bindGroupView(v, this.mContext, cursor, isExpanded);
        return v;
    }

    protected abstract View newGroupView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    protected abstract void bindGroupView(View var1, Context var2, Cursor var3, boolean var4);

    @Override
    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        MyCursorHelper cursorHelper = this.getChildrenCursorHelper(groupPosition, true);
        Cursor cursor = cursorHelper.moveTo(childPosition);
        if (cursor == null) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        View v = convertView == null ? this.newChildView(this.mContext, cursor, isLastChild, parent) : convertView;
        this.bindChildView(v, this.mContext, cursor, isLastChild);
        return v;
    }

    protected abstract View newChildView(Context var1, Cursor var2, boolean var3, ViewGroup var4);

    protected abstract void bindChildView(View var1, Context var2, Cursor var3, boolean var4);

    @Override
    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    private synchronized void releaseCursorHelpers() {
        for (int pos = this.mChildrenCursorHelpers.size() - 1; pos >= 0; --pos) {
            this.mChildrenCursorHelpers.valueAt(pos).deactivate();
        }
        this.mChildrenCursorHelpers.clear();
    }

    @Override
    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(true);
    }

    public void notifyDataSetChanged(boolean releaseCursors) {
        if (releaseCursors) {
            this.releaseCursorHelpers();
        }
        super.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetInvalidated() {
        this.releaseCursorHelpers();
        super.notifyDataSetInvalidated();
    }

    @Override
    public void onGroupCollapsed(int groupPosition) {
        this.deactivateChildrenCursorHelper(groupPosition);
    }

    synchronized void deactivateChildrenCursorHelper(int groupPosition) {
        MyCursorHelper cursorHelper = this.getChildrenCursorHelper(groupPosition, true);
        this.mChildrenCursorHelpers.remove(groupPosition);
        cursorHelper.deactivate();
    }

    @Override
    public String convertToString(Cursor cursor) {
        return cursor == null ? "" : cursor.toString();
    }

    @Override
    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        if (this.mFilterQueryProvider != null) {
            return this.mFilterQueryProvider.runQuery(constraint);
        }
        return this.mGroupCursorHelper.getCursor();
    }

    @Override
    public Filter getFilter() {
        if (this.mCursorFilter == null) {
            this.mCursorFilter = new CursorFilter(this);
        }
        return this.mCursorFilter;
    }

    public FilterQueryProvider getFilterQueryProvider() {
        return this.mFilterQueryProvider;
    }

    public void setFilterQueryProvider(FilterQueryProvider filterQueryProvider) {
        this.mFilterQueryProvider = filterQueryProvider;
    }

    @Override
    public void changeCursor(Cursor cursor) {
        this.mGroupCursorHelper.changeCursor(cursor, true);
    }

    @Override
    public Cursor getCursor() {
        return this.mGroupCursorHelper.getCursor();
    }

    class MyCursorHelper {
        private Cursor mCursor;
        private boolean mDataValid;
        private int mRowIDColumn;
        private MyContentObserver mContentObserver;
        private MyDataSetObserver mDataSetObserver;

        MyCursorHelper(Cursor cursor) {
            boolean cursorPresent = cursor != null;
            this.mCursor = cursor;
            this.mDataValid = cursorPresent;
            this.mRowIDColumn = cursorPresent ? cursor.getColumnIndex("_id") : -1;
            this.mContentObserver = new MyContentObserver();
            this.mDataSetObserver = new MyDataSetObserver();
            if (cursorPresent) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
            }
        }

        Cursor getCursor() {
            return this.mCursor;
        }

        int getCount() {
            if (this.mDataValid && this.mCursor != null) {
                return this.mCursor.getCount();
            }
            return 0;
        }

        long getId(int position) {
            if (this.mDataValid && this.mCursor != null) {
                if (this.mCursor.moveToPosition(position)) {
                    return this.mCursor.getLong(this.mRowIDColumn);
                }
                return 0L;
            }
            return 0L;
        }

        Cursor moveTo(int position) {
            if (this.mDataValid && this.mCursor != null && this.mCursor.moveToPosition(position)) {
                return this.mCursor;
            }
            return null;
        }

        void changeCursor(Cursor cursor, boolean releaseCursors) {
            if (cursor == this.mCursor) {
                return;
            }
            this.deactivate();
            this.mCursor = cursor;
            if (cursor != null) {
                cursor.registerContentObserver(this.mContentObserver);
                cursor.registerDataSetObserver(this.mDataSetObserver);
                this.mRowIDColumn = cursor.getColumnIndex("_id");
                this.mDataValid = true;
                CursorTreeAdapter.this.notifyDataSetChanged(releaseCursors);
            } else {
                this.mRowIDColumn = -1;
                this.mDataValid = false;
                CursorTreeAdapter.this.notifyDataSetInvalidated();
            }
        }

        void deactivate() {
            if (this.mCursor == null) {
                return;
            }
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mCursor.unregisterDataSetObserver(this.mDataSetObserver);
            this.mCursor.close();
            this.mCursor = null;
        }

        boolean isValid() {
            return this.mDataValid && this.mCursor != null;
        }

        private class MyContentObserver
        extends ContentObserver {
            public MyContentObserver() {
                super(CursorTreeAdapter.this.mHandler);
            }

            @Override
            public boolean deliverSelfNotifications() {
                return true;
            }

            @Override
            public void onChange(boolean selfChange) {
                if (CursorTreeAdapter.this.mAutoRequery && MyCursorHelper.this.mCursor != null && !MyCursorHelper.this.mCursor.isClosed()) {
                    MyCursorHelper.this.mDataValid = MyCursorHelper.this.mCursor.requery();
                }
            }
        }

        private class MyDataSetObserver
        extends DataSetObserver {
            private MyDataSetObserver() {
            }

            @Override
            public void onChanged() {
                MyCursorHelper.this.mDataValid = true;
                CursorTreeAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void onInvalidated() {
                MyCursorHelper.this.mDataValid = false;
                CursorTreeAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

