/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.content.pm.PackageInfo;
import android.os.RemoteException;
import android.webkit.IWebViewUpdateService;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@FlaggedApi(value="android.webkit.update_service_ipc_wrapper")
public class WebViewUpdateManager {
    private final IWebViewUpdateService mService;

    public WebViewUpdateManager(@NonNull IWebViewUpdateService service) {
        this.mService = service;
    }

    @SuppressLint(value={"ManagerLookup"})
    @NonNull
    public static WebViewUpdateManager getInstance() {
        WebViewUpdateManager manager = (WebViewUpdateManager)SystemServiceRegistry.getSystemServiceWithNoContext("webviewupdate");
        if (manager == null) {
            throw new UnsupportedOperationException("WebView not supported by device");
        }
        return manager;
    }

    @NonNull
    public WebViewProviderResponse waitForAndGetProvider() {
        try {
            return this.mService.waitForAndGetProvider();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public PackageInfo getCurrentWebViewPackage() {
        try {
            return this.mService.getCurrentWebViewPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"ParcelableList", "ArrayReturn"})
    @NonNull
    public WebViewProviderInfo[] getAllWebViewPackages() {
        try {
            return this.mService.getAllWebViewPackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"ParcelableList", "ArrayReturn"})
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    @NonNull
    public WebViewProviderInfo[] getValidWebViewPackages() {
        try {
            return this.mService.getValidWebViewPackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public String getCurrentWebViewPackageName() {
        try {
            return this.mService.getCurrentWebViewPackageName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    @Nullable
    public String changeProviderAndSetting(@NonNull String newProvider) {
        try {
            return this.mService.changeProviderAndSetting(newProvider);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void notifyRelroCreationCompleted() {
        try {
            this.mService.notifyRelroCreationCompleted();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.webkit.update_service_v2")
    @NonNull
    public WebViewProviderInfo getDefaultWebViewPackage() {
        try {
            return this.mService.getDefaultWebViewPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

