/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.webkit.MimeTypeMap;
import com.android.internal.hidden_from_bootclasspath.android.os.Flags;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLUtil {
    static final long PARSE_CONTENT_DISPOSITION_USING_RFC_6266 = 319400769L;
    private static final String LOGTAG = "webkit";
    private static final boolean TRACE = false;
    static final String ASSET_BASE = "file:///android_asset/";
    static final String RESOURCE_BASE = "file:///android_res/";
    static final String FILE_BASE = "file:";
    static final String PROXY_BASE = "file:///cookieless_proxy/";
    static final String CONTENT_BASE = "content:";
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*(\"?)([^\"]*)\\1\\s*$", 2);
    private static final Pattern DISPOSITION_PATTERN = Pattern.compile("\\s*(\\S+?) # Group 1: parameter name\n\\s*=\\s* # Match equals sign\n(?: # non-capturing group of options\n   '( (?: [^'\\\\] | \\\\. )* )' # Group 2: single-quoted\n | \"( (?: [^\"\\\\] | \\\\. )*  )\" # Group 3: double-quoted\n | ( [^'\"][^;\\s]* ) # Group 4: un-quoted parameter\n)\\s*;? # Optional end semicolon", 4);

    public static String guessUrl(String inUrl) {
        WebAddress webAddress;
        String retVal = inUrl;
        if (inUrl.length() == 0) {
            return inUrl;
        }
        if (inUrl.startsWith("about:")) {
            return inUrl;
        }
        if (inUrl.startsWith("data:")) {
            return inUrl;
        }
        if (inUrl.startsWith(FILE_BASE)) {
            return inUrl;
        }
        if (inUrl.startsWith("javascript:")) {
            return inUrl;
        }
        if (inUrl.endsWith(".")) {
            inUrl = inUrl.substring(0, inUrl.length() - 1);
        }
        try {
            webAddress = new WebAddress(inUrl);
        }
        catch (ParseException ex) {
            return retVal;
        }
        if (webAddress.getHost().indexOf(46) == -1) {
            webAddress.setHost("www." + webAddress.getHost() + ".com");
        }
        return webAddress.toString();
    }

    public static String composeSearchUrl(String inQuery, String template, String queryPlaceHolder) {
        int placeHolderIndex = template.indexOf(queryPlaceHolder);
        if (placeHolderIndex < 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(template.substring(0, placeHolderIndex));
        try {
            String query = URLEncoder.encode(inQuery, "utf-8");
            buffer.append(query);
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        buffer.append(template.substring(placeHolderIndex + queryPlaceHolder.length()));
        return buffer.toString();
    }

    public static byte[] decode(byte[] url) throws IllegalArgumentException {
        if (url.length == 0) {
            return new byte[0];
        }
        byte[] tempData = new byte[url.length];
        int tempCount = 0;
        for (int i = 0; i < url.length; ++i) {
            byte b = url[i];
            if (b == 37) {
                if (url.length - i > 2) {
                    b = (byte)(URLUtil.parseHex(url[i + 1]) * 16 + URLUtil.parseHex(url[i + 2]));
                    i += 2;
                } else {
                    throw new IllegalArgumentException("Invalid format");
                }
            }
            tempData[tempCount++] = b;
        }
        byte[] retData = new byte[tempCount];
        System.arraycopy(tempData, 0, retData, 0, tempCount);
        return retData;
    }

    @UnsupportedAppUsage
    static boolean verifyURLEncoding(String url) {
        int count = url.length();
        if (count == 0) {
            return false;
        }
        int index = url.indexOf(37);
        while (index >= 0 && index < count) {
            if (index < count - 2) {
                try {
                    URLUtil.parseHex((byte)url.charAt(++index));
                    URLUtil.parseHex((byte)url.charAt(++index));
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            } else {
                return false;
            }
            index = url.indexOf(37, index + 1);
        }
        return true;
    }

    private static int parseHex(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 65 && b <= 70) {
            return b - 65 + 10;
        }
        if (b >= 97 && b <= 102) {
            return b - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char '" + b + "'");
    }

    public static boolean isAssetUrl(String url) {
        return null != url && url.startsWith(ASSET_BASE);
    }

    @UnsupportedAppUsage
    public static boolean isResourceUrl(String url) {
        return null != url && url.startsWith(RESOURCE_BASE);
    }

    @Deprecated
    public static boolean isCookielessProxyUrl(String url) {
        return null != url && url.startsWith(PROXY_BASE);
    }

    public static boolean isFileUrl(String url) {
        return null != url && url.startsWith(FILE_BASE) && !url.startsWith(ASSET_BASE) && !url.startsWith(PROXY_BASE);
    }

    public static boolean isAboutUrl(String url) {
        return null != url && url.startsWith("about:");
    }

    public static boolean isDataUrl(String url) {
        return null != url && url.startsWith("data:");
    }

    public static boolean isJavaScriptUrl(String url) {
        return null != url && url.startsWith("javascript:");
    }

    public static boolean isHttpUrl(String url) {
        return null != url && url.length() > 6 && url.substring(0, 7).equalsIgnoreCase("http://");
    }

    public static boolean isHttpsUrl(String url) {
        return null != url && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("https://");
    }

    public static boolean isNetworkUrl(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        return URLUtil.isHttpUrl(url) || URLUtil.isHttpsUrl(url);
    }

    public static boolean isContentUrl(String url) {
        return null != url && url.startsWith(CONTENT_BASE);
    }

    public static boolean isValidUrl(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        return URLUtil.isAssetUrl(url) || URLUtil.isResourceUrl(url) || URLUtil.isFileUrl(url) || URLUtil.isAboutUrl(url) || URLUtil.isHttpUrl(url) || URLUtil.isHttpsUrl(url) || URLUtil.isJavaScriptUrl(url) || URLUtil.isContentUrl(url);
    }

    public static String stripAnchor(String url) {
        int anchorIndex = url.indexOf(35);
        if (anchorIndex != -1) {
            return url.substring(0, anchorIndex);
        }
        return url;
    }

    public static String guessFileName(String url, @Nullable String contentDisposition, @Nullable String mimeType) {
        if (Flags.androidOsBuildVanillaIceCream() && Compatibility.isChangeEnabled(319400769L)) {
            return URLUtil.guessFileNameRfc6266(url, contentDisposition, mimeType);
        }
        return URLUtil.guessFileNameRfc2616(url, contentDisposition, mimeType);
    }

    private static String guessFileNameRfc2616(String url, @Nullable String contentDisposition, @Nullable String mimeType) {
        int dotIndex;
        String decodedUrl;
        int index;
        String filename = null;
        String extension = null;
        if (contentDisposition != null && (filename = URLUtil.parseContentDispositionRfc2616(contentDisposition)) != null && (index = filename.lastIndexOf(47) + 1) > 0) {
            filename = filename.substring(index);
        }
        if (filename == null && (decodedUrl = Uri.decode(url)) != null) {
            int index2;
            int queryIndex = decodedUrl.indexOf(63);
            if (queryIndex > 0) {
                decodedUrl = decodedUrl.substring(0, queryIndex);
            }
            if (!decodedUrl.endsWith("/") && (index2 = decodedUrl.lastIndexOf(47) + 1) > 0) {
                filename = decodedUrl.substring(index2);
            }
        }
        if (filename == null) {
            filename = "downloadfile";
        }
        if ((dotIndex = filename.indexOf(46)) < 0) {
            if (mimeType != null && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                extension = "." + extension;
            }
            if (extension == null) {
                extension = mimeType != null && mimeType.toLowerCase(Locale.ROOT).startsWith("text/") ? (mimeType.equalsIgnoreCase("text/html") ? ".html" : ".txt") : ".bin";
            }
        } else {
            if (mimeType != null) {
                int lastDotIndex = filename.lastIndexOf(46);
                String typeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(filename.substring(lastDotIndex + 1));
                if (typeFromExt != null && !typeFromExt.equalsIgnoreCase(mimeType) && (extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType)) != null) {
                    extension = "." + extension;
                }
            }
            if (extension == null) {
                extension = filename.substring(dotIndex);
            }
            filename = filename.substring(0, dotIndex);
        }
        return filename + extension;
    }

    @NonNull
    private static String guessFileNameRfc6266(@NonNull String url, @Nullable String contentDisposition, @Nullable String mimeType) {
        String filename = URLUtil.getFilenameSuggestion(url, contentDisposition);
        String extensionFromMimeType = URLUtil.suggestExtensionFromMimeType(mimeType);
        if (filename.indexOf(46) < 0) {
            return filename + extensionFromMimeType;
        }
        if (mimeType != null && URLUtil.extensionDifferentFromMimeType(filename, mimeType)) {
            return filename + extensionFromMimeType;
        }
        return filename;
    }

    @NonNull
    private static String getFilenameSuggestion(String url, @Nullable String contentDisposition) {
        Uri parsedUri;
        String lastPathSegment;
        String filename;
        if (contentDisposition != null && (filename = URLUtil.getFilenameFromContentDispositionRfc6266(contentDisposition)) != null) {
            return URLUtil.replacePathSeparators(filename);
        }
        if (url != null && (lastPathSegment = (parsedUri = Uri.parse(url)).getLastPathSegment()) != null) {
            return URLUtil.replacePathSeparators(lastPathSegment);
        }
        return "downloadfile";
    }

    @NonNull
    private static String replacePathSeparators(@NonNull String raw2) {
        return raw2.replaceAll("/", "_");
    }

    private static boolean extensionDifferentFromMimeType(@NonNull String filename, @NonNull String mimeType) {
        int lastDotIndex = filename.lastIndexOf(46);
        String typeFromExt = MimeTypeMap.getSingleton().getMimeTypeFromExtension(filename.substring(lastDotIndex + 1));
        return typeFromExt != null && !typeFromExt.equalsIgnoreCase(mimeType);
    }

    @NonNull
    private static String suggestExtensionFromMimeType(@Nullable String mimeType) {
        if (mimeType == null) {
            return ".bin";
        }
        String extensionFromMimeType = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
        if (extensionFromMimeType != null) {
            return "." + extensionFromMimeType;
        }
        if (mimeType.equalsIgnoreCase("text/html")) {
            return ".html";
        }
        if (mimeType.toLowerCase(Locale.ROOT).startsWith("text/")) {
            return ".txt";
        }
        return ".bin";
    }

    @UnsupportedAppUsage
    static String parseContentDisposition(String contentDisposition) {
        if (Flags.androidOsBuildVanillaIceCream() && Compatibility.isChangeEnabled(319400769L)) {
            return URLUtil.getFilenameFromContentDispositionRfc6266(contentDisposition);
        }
        return URLUtil.parseContentDispositionRfc2616(contentDisposition);
    }

    private static String parseContentDispositionRfc2616(String contentDisposition) {
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String getFilenameFromContentDispositionRfc6266(@NonNull String contentDisposition) {
        String[] parts = contentDisposition.trim().split(";", 2);
        if (parts.length < 2) {
            return null;
        }
        String dispositionType = parts[0].trim();
        if ("inline".equalsIgnoreCase(dispositionType)) {
            return null;
        }
        String dispositionParameters = parts[1];
        Matcher matcher = DISPOSITION_PATTERN.matcher(dispositionParameters);
        String filename = null;
        String filenameExt = null;
        while (matcher.find()) {
            String parameter = matcher.group(1);
            String value = matcher.group(2) != null ? URLUtil.removeSlashEscapes(matcher.group(2)) : (matcher.group(3) != null ? URLUtil.removeSlashEscapes(matcher.group(3)) : matcher.group(4));
            if (parameter == null || value == null) continue;
            if ("filename*".equalsIgnoreCase(parameter)) {
                filenameExt = URLUtil.parseExtValueString(value);
                continue;
            }
            if (!"filename".equalsIgnoreCase(parameter)) continue;
            filename = value;
        }
        if (filenameExt != null) {
            return filenameExt;
        }
        return filename;
    }

    private static String removeSlashEscapes(String raw2) {
        if (raw2 == null) {
            return null;
        }
        return raw2.replaceAll("\\\\(.)", "$1");
    }

    private static String parseExtValueString(String raw2) {
        String[] parts = raw2.split("'", 3);
        if (parts.length < 3) {
            return null;
        }
        String encoding = parts[0];
        String valueChars = parts[2];
        try {
            Charset charset = Charset.forName(encoding);
            String valueWithEncodedPlus = URLUtil.encodePlusCharacters(valueChars, charset);
            return URLDecoder.decode(valueWithEncodedPlus, charset);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    @NonNull
    private static String encodePlusCharacters(@NonNull String valueChars, Charset charset) {
        StringBuilder sb = new StringBuilder();
        for (byte b : charset.encode("+").array()) {
            sb.append(String.format("%02x", b));
        }
        return valueChars.replaceAll("\\+", sb.toString());
    }
}

