/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.view.autofill.AutofillId;
import android.view.translation.TranslationResponseValue;
import com.android.internal.util.AnnotationValidations;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ViewTranslationResponse
implements Parcelable {
    @NonNull
    private final AutofillId mAutofillId;
    @NonNull
    private final Map<String, TranslationResponseValue> mTranslationResponseValues;
    @NonNull
    public static final Parcelable.Creator<ViewTranslationResponse> CREATOR = new Parcelable.Creator<ViewTranslationResponse>(){

        public ViewTranslationResponse[] newArray(int size) {
            return new ViewTranslationResponse[size];
        }

        @Override
        public ViewTranslationResponse createFromParcel(@NonNull Parcel in) {
            return new ViewTranslationResponse(in);
        }
    };

    @NonNull
    public TranslationResponseValue getValue(@NonNull String key) {
        Objects.requireNonNull(key);
        if (!this.mTranslationResponseValues.containsKey(key)) {
            throw new IllegalArgumentException("Request does not contain value for key=" + key);
        }
        return this.mTranslationResponseValues.get(key);
    }

    @NonNull
    public Set<String> getKeys() {
        return this.mTranslationResponseValues.keySet();
    }

    @NonNull
    public AutofillId getAutofillId() {
        return this.mAutofillId;
    }

    private static Map<String, TranslationResponseValue> defaultTranslationResponseValues() {
        return Collections.emptyMap();
    }

    ViewTranslationResponse(@NonNull AutofillId autofillId, @NonNull Map<String, TranslationResponseValue> translationResponseValues) {
        this.mAutofillId = autofillId;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        this.mTranslationResponseValues = translationResponseValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationResponseValues);
    }

    public String toString() {
        return "ViewTranslationResponse { autofillId = " + this.mAutofillId + ", translationResponseValues = " + this.mTranslationResponseValues + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewTranslationResponse that = (ViewTranslationResponse)o;
        return Objects.equals(this.mAutofillId, that.mAutofillId) && Objects.equals(this.mTranslationResponseValues, that.mTranslationResponseValues);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mAutofillId);
        _hash = 31 * _hash + Objects.hashCode(this.mTranslationResponseValues);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mAutofillId, flags);
        dest.writeMap(this.mTranslationResponseValues);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ViewTranslationResponse(@NonNull Parcel in) {
        AutofillId autofillId = in.readTypedObject(AutofillId.CREATOR);
        LinkedHashMap<String, TranslationResponseValue> translationResponseValues = new LinkedHashMap<String, TranslationResponseValue>();
        in.readMap(translationResponseValues, TranslationResponseValue.class.getClassLoader());
        this.mAutofillId = autofillId;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        this.mTranslationResponseValues = translationResponseValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationResponseValues);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        @NonNull
        private AutofillId mAutofillId;
        @NonNull
        private Map<String, TranslationResponseValue> mTranslationResponseValues;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull AutofillId autofillId) {
            this.mAutofillId = autofillId;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAutofillId);
        }

        @Override
        @NonNull
        Builder setTranslationResponseValues(@NonNull Map<String, TranslationResponseValue> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mTranslationResponseValues = value;
            return this;
        }

        @NonNull
        public ViewTranslationResponse build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mTranslationResponseValues = ViewTranslationResponse.defaultTranslationResponseValues();
            }
            ViewTranslationResponse o = new ViewTranslationResponse(this.mAutofillId, this.mTranslationResponseValues);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 4L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }

        abstract Builder setTranslationResponseValues(Map<String, TranslationResponseValue> var1);

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setValue(String key, TranslationResponseValue value) {
            Builder builder = (Builder)this;
            if (builder.mTranslationResponseValues == null) {
                this.setTranslationResponseValues(new ArrayMap<String, TranslationResponseValue>());
            }
            builder.mTranslationResponseValues.put(key, value);
            return builder;
        }
    }
}

