/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.translation.TranslationRequestValue;
import android.view.translation.ViewTranslationRequest;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TranslationRequest
implements Parcelable {
    public static final int FLAG_TRANSLATION_RESULT = 1;
    public static final int FLAG_DICTIONARY_RESULT = 2;
    public static final int FLAG_TRANSLITERATION_RESULT = 4;
    public static final int FLAG_PARTIAL_RESPONSES = 8;
    private final int mFlags;
    @NonNull
    private final List<TranslationRequestValue> mTranslationRequestValues;
    @NonNull
    private final List<ViewTranslationRequest> mViewTranslationRequests;
    @NonNull
    public static final Parcelable.Creator<TranslationRequest> CREATOR = new Parcelable.Creator<TranslationRequest>(){

        public TranslationRequest[] newArray(int size) {
            return new TranslationRequest[size];
        }

        @Override
        public TranslationRequest createFromParcel(@NonNull Parcel in) {
            return new TranslationRequest(in);
        }
    };

    private static int defaultFlags() {
        return 1;
    }

    private static List<TranslationRequestValue> defaultTranslationRequestValues() {
        return Collections.emptyList();
    }

    private static List<ViewTranslationRequest> defaultViewTranslationRequests() {
        return Collections.emptyList();
    }

    public static String requestFlagsToString(int value) {
        return BitUtils.flagsToString(value, TranslationRequest::singleRequestFlagsToString);
    }

    static String singleRequestFlagsToString(int value) {
        switch (value) {
            case 1: {
                return "FLAG_TRANSLATION_RESULT";
            }
            case 2: {
                return "FLAG_DICTIONARY_RESULT";
            }
            case 4: {
                return "FLAG_TRANSLITERATION_RESULT";
            }
            case 8: {
                return "FLAG_PARTIAL_RESPONSES";
            }
        }
        return Integer.toHexString(value);
    }

    TranslationRequest(int flags, @NonNull List<TranslationRequestValue> translationRequestValues, @NonNull List<ViewTranslationRequest> viewTranslationRequests) {
        this.mFlags = flags;
        Preconditions.checkFlagsArgument(this.mFlags, 15);
        this.mTranslationRequestValues = translationRequestValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationRequestValues);
        this.mViewTranslationRequests = viewTranslationRequests;
        AnnotationValidations.validate(NonNull.class, null, this.mViewTranslationRequests);
    }

    public int getFlags() {
        return this.mFlags;
    }

    @NonNull
    public List<TranslationRequestValue> getTranslationRequestValues() {
        return this.mTranslationRequestValues;
    }

    @NonNull
    public List<ViewTranslationRequest> getViewTranslationRequests() {
        return this.mViewTranslationRequests;
    }

    public String toString() {
        return "TranslationRequest { flags = " + TranslationRequest.requestFlagsToString(this.mFlags) + ", translationRequestValues = " + this.mTranslationRequestValues + ", viewTranslationRequests = " + this.mViewTranslationRequests + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mFlags);
        dest.writeParcelableList(this.mTranslationRequestValues, flags);
        dest.writeParcelableList(this.mViewTranslationRequests, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationRequest(@NonNull Parcel in) {
        int flags = in.readInt();
        ArrayList<TranslationRequestValue> translationRequestValues = new ArrayList<TranslationRequestValue>();
        in.readParcelableList(translationRequestValues, TranslationRequestValue.class.getClassLoader(), TranslationRequestValue.class);
        ArrayList<ViewTranslationRequest> viewTranslationRequests = new ArrayList<ViewTranslationRequest>();
        in.readParcelableList(viewTranslationRequests, ViewTranslationRequest.class.getClassLoader(), ViewTranslationRequest.class);
        this.mFlags = flags;
        Preconditions.checkFlagsArgument(this.mFlags, 15);
        this.mTranslationRequestValues = translationRequestValues;
        AnnotationValidations.validate(NonNull.class, null, this.mTranslationRequestValues);
        this.mViewTranslationRequests = viewTranslationRequests;
        AnnotationValidations.validate(NonNull.class, null, this.mViewTranslationRequests);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        private int mFlags;
        @NonNull
        private List<TranslationRequestValue> mTranslationRequestValues;
        @NonNull
        private List<ViewTranslationRequest> mViewTranslationRequests;
        private long mBuilderFieldsSet = 0L;

        @NonNull
        public Builder setFlags(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mFlags = value;
            return this;
        }

        @NonNull
        public Builder setTranslationRequestValues(@NonNull List<TranslationRequestValue> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mTranslationRequestValues = value;
            return this;
        }

        @Override
        @Deprecated
        @NonNull
        public Builder addTranslationRequestValue(@NonNull TranslationRequestValue value) {
            if (this.mTranslationRequestValues == null) {
                this.setTranslationRequestValues(new ArrayList<TranslationRequestValue>());
            }
            this.mTranslationRequestValues.add(value);
            return this;
        }

        @NonNull
        public Builder setViewTranslationRequests(@NonNull List<ViewTranslationRequest> value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mViewTranslationRequests = value;
            return this;
        }

        @Override
        @Deprecated
        @NonNull
        public Builder addViewTranslationRequest(@NonNull ViewTranslationRequest value) {
            if (this.mViewTranslationRequests == null) {
                this.setViewTranslationRequests(new ArrayList<ViewTranslationRequest>());
            }
            this.mViewTranslationRequests.add(value);
            return this;
        }

        @NonNull
        public TranslationRequest build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mFlags = TranslationRequest.defaultFlags();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mTranslationRequestValues = TranslationRequest.defaultTranslationRequestValues();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mViewTranslationRequests = TranslationRequest.defaultViewTranslationRequests();
            }
            TranslationRequest o = new TranslationRequest(this.mFlags, this.mTranslationRequestValues, this.mViewTranslationRequests);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 8L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestFlags {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }

        @Deprecated
        public abstract Builder addTranslationRequestValue(@NonNull TranslationRequestValue var1);

        @Deprecated
        public abstract Builder addViewTranslationRequest(@NonNull ViewTranslationRequest var1);
    }
}

