/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.HandwritingGesture;
import java.util.Objects;

public class RemoveSpaceGesture
extends HandwritingGesture
implements Parcelable {
    private final PointF mStartPoint;
    private final PointF mEndPoint;
    @NonNull
    public static final Parcelable.Creator<RemoveSpaceGesture> CREATOR = new Parcelable.Creator<RemoveSpaceGesture>(){

        @Override
        public RemoveSpaceGesture createFromParcel(Parcel source) {
            return new RemoveSpaceGesture(source);
        }

        public RemoveSpaceGesture[] newArray(int size) {
            return new RemoveSpaceGesture[size];
        }
    };

    private RemoveSpaceGesture(PointF startPoint, PointF endPoint, String fallbackText) {
        this.mType = 8;
        this.mStartPoint = startPoint;
        this.mEndPoint = endPoint;
        this.mFallbackText = fallbackText;
    }

    private RemoveSpaceGesture(@NonNull Parcel source) {
        this.mType = 8;
        this.mStartPoint = source.readTypedObject(PointF.CREATOR);
        this.mEndPoint = source.readTypedObject(PointF.CREATOR);
        this.mFallbackText = source.readString8();
    }

    @NonNull
    public PointF getStartPoint() {
        return this.mStartPoint;
    }

    @NonNull
    public PointF getEndPoint() {
        return this.mEndPoint;
    }

    public int hashCode() {
        return Objects.hash(this.mStartPoint, this.mEndPoint, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoveSpaceGesture)) {
            return false;
        }
        RemoveSpaceGesture that = (RemoveSpaceGesture)o;
        return Objects.equals(this.mStartPoint, that.mStartPoint) && Objects.equals(this.mEndPoint, that.mEndPoint) && Objects.equals(this.mFallbackText, that.mFallbackText);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mStartPoint, flags);
        dest.writeTypedObject(this.mEndPoint, flags);
        dest.writeString8(this.mFallbackText);
    }

    public static class Builder {
        private PointF mStartPoint;
        private PointF mEndPoint;
        private String mFallbackText;

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setPoints(@NonNull PointF startPoint, @NonNull PointF endPoint) {
            this.mStartPoint = startPoint;
            this.mEndPoint = endPoint;
            return this;
        }

        @NonNull
        public Builder setFallbackText(@Nullable String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        @NonNull
        public RemoveSpaceGesture build() {
            if (this.mStartPoint == null || this.mEndPoint == null) {
                throw new IllegalArgumentException("Start and end points must be set.");
            }
            return new RemoveSpaceGesture(this.mStartPoint, this.mEndPoint, this.mFallbackText);
        }
    }
}

