/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.HandwritingGesture;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.PreviewableHandwritingGesture;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import android.view.inputmethod.TextBoundsInfoResult;
import android.view.inputmethod.TextSnapshot;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public interface InputConnection {
    public static final int GET_TEXT_WITH_STYLES = 1;
    public static final int GET_EXTRACTED_TEXT_MONITOR = 1;
    public static final int HANDWRITING_GESTURE_RESULT_UNKNOWN = 0;
    public static final int HANDWRITING_GESTURE_RESULT_SUCCESS = 1;
    public static final int HANDWRITING_GESTURE_RESULT_UNSUPPORTED = 2;
    public static final int HANDWRITING_GESTURE_RESULT_FAILED = 3;
    public static final int HANDWRITING_GESTURE_RESULT_CANCELLED = 4;
    public static final int HANDWRITING_GESTURE_RESULT_FALLBACK = 5;
    public static final int CURSOR_UPDATE_IMMEDIATE = 1;
    public static final int CURSOR_UPDATE_MONITOR = 2;
    public static final int CURSOR_UPDATE_FILTER_EDITOR_BOUNDS = 4;
    public static final int CURSOR_UPDATE_FILTER_CHARACTER_BOUNDS = 8;
    public static final int CURSOR_UPDATE_FILTER_INSERTION_MARKER = 16;
    public static final int CURSOR_UPDATE_FILTER_VISIBLE_LINE_BOUNDS = 32;
    public static final int CURSOR_UPDATE_FILTER_TEXT_APPEARANCE = 64;
    public static final int INPUT_CONTENT_GRANT_READ_URI_PERMISSION = 1;

    @Nullable
    public CharSequence getTextBeforeCursor(int var1, int var2);

    @Nullable
    public CharSequence getTextAfterCursor(int var1, int var2);

    public CharSequence getSelectedText(int var1);

    @Nullable
    default public SurroundingText getSurroundingText(int beforeLength, int afterLength, int flags) {
        Preconditions.checkArgumentNonnegative(beforeLength);
        Preconditions.checkArgumentNonnegative(afterLength);
        CharSequence textBeforeCursor = this.getTextBeforeCursor(beforeLength, flags);
        if (textBeforeCursor == null) {
            return null;
        }
        CharSequence textAfterCursor = this.getTextAfterCursor(afterLength, flags);
        if (textAfterCursor == null) {
            return null;
        }
        CharSequence selectedText = this.getSelectedText(flags);
        if (selectedText == null) {
            selectedText = "";
        }
        CharSequence surroundingText = TextUtils.concat(textBeforeCursor, selectedText, textAfterCursor);
        return new SurroundingText(surroundingText, textBeforeCursor.length(), textBeforeCursor.length() + selectedText.length(), -1);
    }

    public int getCursorCapsMode(int var1);

    public ExtractedText getExtractedText(ExtractedTextRequest var1, int var2);

    public boolean deleteSurroundingText(int var1, int var2);

    public boolean deleteSurroundingTextInCodePoints(int var1, int var2);

    public boolean setComposingText(CharSequence var1, int var2);

    default public boolean setComposingText(@NonNull CharSequence text, int newCursorPosition, @Nullable TextAttribute textAttribute) {
        return this.setComposingText(text, newCursorPosition);
    }

    public boolean setComposingRegion(int var1, int var2);

    default public boolean setComposingRegion(int start, int end, @Nullable TextAttribute textAttribute) {
        return this.setComposingRegion(start, end);
    }

    public boolean finishComposingText();

    public boolean commitText(CharSequence var1, int var2);

    default public boolean commitText(@NonNull CharSequence text, int newCursorPosition, @Nullable TextAttribute textAttribute) {
        return this.commitText(text, newCursorPosition);
    }

    public boolean commitCompletion(CompletionInfo var1);

    public boolean commitCorrection(CorrectionInfo var1);

    public boolean setSelection(int var1, int var2);

    public boolean performEditorAction(int var1);

    public boolean performContextMenuAction(int var1);

    public boolean beginBatchEdit();

    public boolean endBatchEdit();

    public boolean sendKeyEvent(KeyEvent var1);

    public boolean clearMetaKeyStates(int var1);

    public boolean reportFullscreenMode(boolean var1);

    default public boolean performSpellCheck() {
        return false;
    }

    public boolean performPrivateCommand(String var1, Bundle var2);

    default public void performHandwritingGesture(@NonNull HandwritingGesture gesture, @Nullable Executor executor, @Nullable IntConsumer consumer) {
        if (executor != null && consumer != null) {
            executor.execute(() -> consumer.accept(2));
        }
    }

    default public boolean previewHandwritingGesture(@NonNull PreviewableHandwritingGesture gesture, @Nullable CancellationSignal cancellationSignal) {
        return false;
    }

    public boolean requestCursorUpdates(int var1);

    default public boolean requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter) {
        if (cursorUpdateFilter == 0) {
            return this.requestCursorUpdates(cursorUpdateMode);
        }
        return false;
    }

    default public void requestTextBoundsInfo(@NonNull RectF bounds, @NonNull Executor executor, @NonNull Consumer<TextBoundsInfoResult> consumer) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(consumer);
        executor.execute(() -> consumer.accept(new TextBoundsInfoResult(0)));
    }

    @Nullable
    public Handler getHandler();

    public void closeConnection();

    public boolean commitContent(@NonNull InputContentInfo var1, int var2, @Nullable Bundle var3);

    default public boolean setImeConsumesInput(boolean imeConsumesInput) {
        return false;
    }

    @Nullable
    default public TextSnapshot takeSnapshot() {
        return null;
    }

    default public boolean replaceText(int start, int end, @NonNull CharSequence text, int newCursorPosition, @Nullable TextAttribute textAttribute) {
        Preconditions.checkArgumentNonnegative(start);
        Preconditions.checkArgumentNonnegative(end);
        this.beginBatchEdit();
        this.finishComposingText();
        this.setSelection(start, end);
        this.commitText(text, newCursorPosition, textAttribute);
        this.endBatchEdit();
        return true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CursorUpdateFilter {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CursorUpdateMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HandwritingGestureResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GetTextType {
    }
}

