/*
 * Decompiled with CFR 0.152.
 */
package android.view.input;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.os.Handler;
import android.view.InputEvent;
import android.view.InputEventCompatProcessor;
import android.view.MotionEvent;
import java.util.List;

public class StylusButtonCompatibility
extends InputEventCompatProcessor {
    private static final int STYLUS_BUTTONS_MASK = 96;

    public static boolean isCompatibilityNeeded(Context context) {
        return context.getApplicationInfo().targetSdkVersion < 23;
    }

    public StylusButtonCompatibility(Context context, Handler handler) {
        super(context, handler);
    }

    @Override
    @Nullable
    public List<InputEvent> processInputEventForCompatibility(@NonNull InputEvent inputEvent) {
        if (!(inputEvent instanceof MotionEvent)) {
            return null;
        }
        MotionEvent motion = (MotionEvent)inputEvent;
        int buttonState = motion.getButtonState();
        int compatButtonState = (buttonState & 0x60) >> 4;
        if (compatButtonState == 0) {
            return null;
        }
        motion.setButtonState(buttonState | compatButtonState);
        return List.of(motion);
    }
}

