/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentprotection;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ContentCaptureOptions;
import android.content.pm.ParceledListSlice;
import android.os.Handler;
import android.util.Log;
import android.view.contentcapture.ContentCaptureEvent;
import android.view.contentcapture.IContentCaptureManager;
import android.view.contentcapture.ViewNode;
import android.view.contentprotection.ContentProtectionUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.RingBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class ContentProtectionEventProcessor {
    private static final String TAG = "ContentProtectionEventProcessor";
    private static final Duration MIN_DURATION_BETWEEN_FLUSHING = Duration.ofSeconds(3L);
    private static final Set<Integer> EVENT_TYPES_TO_STORE = Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
    private static final int RESET_LOGIN_TOTAL_EVENTS_TO_PROCESS = 150;
    @NonNull
    private final RingBuffer<ContentCaptureEvent> mEventBuffer;
    @NonNull
    private final Handler mHandler;
    @NonNull
    private final IContentCaptureManager mContentCaptureManager;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final ContentCaptureOptions.ContentProtectionOptions mOptions;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    @Nullable
    public Instant mLastFlushTime;
    private int mResetLoginRemainingEventsToProcess;
    private boolean mAnyGroupFound = false;
    private final List<SearchGroup> mGroupsRequired;
    private final List<SearchGroup> mGroupsOptional;
    private final List<SearchGroup> mGroupsAll;

    public ContentProtectionEventProcessor(@NonNull RingBuffer<ContentCaptureEvent> eventBuffer, @NonNull Handler handler, @NonNull IContentCaptureManager contentCaptureManager, @NonNull String packageName, @NonNull ContentCaptureOptions.ContentProtectionOptions options) {
        this.mEventBuffer = eventBuffer;
        this.mHandler = handler;
        this.mContentCaptureManager = contentCaptureManager;
        this.mPackageName = packageName;
        this.mOptions = options;
        this.mGroupsRequired = options.requiredGroups.stream().map(SearchGroup::new).toList();
        this.mGroupsOptional = options.optionalGroups.stream().map(SearchGroup::new).toList();
        this.mGroupsAll = Stream.of(this.mGroupsRequired, this.mGroupsOptional).flatMap(Collection::stream).toList();
    }

    public void processEvent(@NonNull ContentCaptureEvent event) {
        if (EVENT_TYPES_TO_STORE.contains(event.getType())) {
            this.storeEvent(event);
        }
        if (event.getType() == 1) {
            this.processViewAppearedEvent(event);
        }
    }

    private void storeEvent(@NonNull ContentCaptureEvent event) {
        ViewNode viewNode = event.getViewNode() != null ? event.getViewNode() : new ViewNode();
        viewNode.setTextIdEntry(this.mPackageName);
        event.setViewNode(viewNode);
        this.mEventBuffer.append(event);
    }

    private void processViewAppearedEvent(@NonNull ContentCaptureEvent event) {
        boolean loginDetected;
        ViewNode viewNode = event.getViewNode();
        String eventText = ContentProtectionUtils.getEventTextLower(event);
        String viewNodeText = ContentProtectionUtils.getViewNodeTextLower(viewNode);
        String hintText = ContentProtectionUtils.getHintTextLower(viewNode);
        this.mGroupsAll.stream().filter(group -> !group.mFound).filter(group -> group.matches(eventText) || group.matches(viewNodeText) || group.matches(hintText)).findFirst().ifPresent(group -> {
            group.mFound = true;
            this.mAnyGroupFound = true;
        });
        boolean bl = loginDetected = this.mGroupsRequired.stream().allMatch(group -> group.mFound) && this.mGroupsOptional.stream().filter(group -> group.mFound).count() >= (long)this.mOptions.optionalGroupsThreshold;
        if (loginDetected) {
            this.loginDetected();
        } else {
            this.maybeResetLoginFlags();
        }
    }

    private void loginDetected() {
        if (this.mLastFlushTime == null || Instant.now().isAfter(this.mLastFlushTime.plus(MIN_DURATION_BETWEEN_FLUSHING))) {
            this.flush();
        }
        this.resetLoginFlags();
    }

    private void resetLoginFlags() {
        this.mGroupsAll.forEach(group -> {
            group.mFound = false;
        });
        this.mAnyGroupFound = false;
    }

    private void maybeResetLoginFlags() {
        if (this.mAnyGroupFound) {
            if (this.mResetLoginRemainingEventsToProcess <= 0) {
                this.mResetLoginRemainingEventsToProcess = 150;
            } else {
                --this.mResetLoginRemainingEventsToProcess;
                if (this.mResetLoginRemainingEventsToProcess <= 0) {
                    this.resetLoginFlags();
                }
            }
        }
    }

    private void flush() {
        this.mLastFlushTime = Instant.now();
        ParceledListSlice<ContentCaptureEvent> events = this.clearEvents();
        this.mHandler.post(() -> this.handlerOnLoginDetected(events));
    }

    @NonNull
    private ParceledListSlice<ContentCaptureEvent> clearEvents() {
        List<ContentCaptureEvent> events = Arrays.asList(this.mEventBuffer.toArray());
        this.mEventBuffer.clear();
        return new ParceledListSlice<ContentCaptureEvent>(events);
    }

    private void handlerOnLoginDetected(@NonNull ParceledListSlice<ContentCaptureEvent> events) {
        try {
            this.mContentCaptureManager.onLoginDetected(events);
        }
        catch (Exception ex) {
            Log.e(TAG, "Failed to flush events for: " + this.mPackageName, ex);
        }
    }

    private static class SearchGroup {
        @NonNull
        private final List<String> mSearchStrings;
        public boolean mFound = false;

        SearchGroup(@NonNull List<String> searchStrings) {
            this.mSearchStrings = searchStrings;
        }

        public boolean matches(@Nullable String text) {
            if (text == null) {
                return false;
            }
            return this.mSearchStrings.stream().anyMatch(text::contains);
        }
    }
}

