/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.annotation.NonNull;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.view.View;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class AutofillStateFingerprint {
    ArrayList<AutofillId> mPriorAutofillIds;
    ArrayList<Integer> mViewHashCodes;
    boolean mHideHighlight = false;
    private int mSessionId;
    Map<Integer, AutofillId> mHashToAutofillIdMap = new ArrayMap<Integer, AutofillId>();
    Map<AutofillId, AutofillId> mOldIdsToCurrentAutofillIdMap = new ArrayMap<AutofillId, AutofillId>();
    private ArrayList<AutofillId> mFailedIds = new ArrayList();
    private ArrayList<AutofillValue> mFailedAutofillValues = new ArrayList();
    private boolean mUseRelativePosition;
    private static final String TAG = "AutofillStateFingerprint";

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static AutofillStateFingerprint createInstance() {
        return new AutofillStateFingerprint();
    }

    private AutofillStateFingerprint() {
    }

    void setSessionId(int sessionId) {
        this.mSessionId = sessionId;
    }

    void setUseRelativePosition(boolean useRelativePosition) {
        this.mUseRelativePosition = useRelativePosition;
    }

    void storeStatePriorToAuthentication(AutofillManager.AutofillClient client, Set<AutofillId> autofillIds) {
        if (this.mUseRelativePosition) {
            List<View> autofillableViews = client.autofillClientFindAutofillableViewsByTraversal();
            if (Helper.sDebug) {
                Log.d(TAG, "Autofillable views count prior to auth:" + autofillableViews.size());
            }
            ArrayMap<Integer, View> hashes = this.getFingerprintIds(autofillableViews);
            for (Map.Entry<Integer, View> entry : hashes.entrySet()) {
                View view = entry.getValue();
                if (view != null) {
                    this.mHashToAutofillIdMap.put(entry.getKey(), view.getAutofillId());
                    continue;
                }
                if (!Helper.sDebug) continue;
                Log.d(TAG, "Encountered null view");
            }
        } else {
            if (Helper.sDebug) {
                Log.d(TAG, "Size of autofillId's being stored: " + autofillIds.size() + " list:" + autofillIds);
            }
            AutofillId[] autofillIdsArr = Helper.toArray(autofillIds);
            View[] views = client.autofillClientFindViewsByAutofillIdTraversal(autofillIdsArr);
            for (int i = 0; i < autofillIdsArr.length; ++i) {
                View view = views[i];
                if (view != null) {
                    int id2 = this.getEphemeralFingerprintId(view, 0);
                    AutofillId autofillId = view.getAutofillId();
                    this.mHashToAutofillIdMap.put(id2, autofillId);
                    continue;
                }
                if (!Helper.sDebug) continue;
                Log.d(TAG, "Encountered null view");
            }
        }
    }

    void storeFailedIdsAndValues(@NonNull ArrayList<AutofillId> failedIds, ArrayList<AutofillValue> failedAutofillValues, boolean hideHighlight) {
        for (AutofillId failedId : failedIds) {
            if (failedId != null) {
                failedId.setSessionId(this.mSessionId);
                continue;
            }
            if (!Helper.sDebug) continue;
            Log.d(TAG, "Got null failed ids");
        }
        this.mFailedIds = failedIds;
        this.mFailedAutofillValues = failedAutofillValues;
        this.mHideHighlight = hideHighlight;
    }

    private void dumpCurrentState() {
        Log.d(TAG, "FailedId's: " + this.mFailedIds);
        Log.d(TAG, "Hashes from map" + this.mHashToAutofillIdMap);
    }

    boolean attemptRefill(List<View> currentAutofillableViews, @NonNull AutofillManager autofillManager) {
        AutofillId currentAutofillId;
        if (Helper.sDebug) {
            this.dumpCurrentState();
        }
        ArrayMap<Integer, View> currentHashes = this.getFingerprintIds(currentAutofillableViews);
        HashMap<AutofillId, View> oldFailedIdsToCurrentViewMap = new HashMap<AutofillId, View>();
        for (Map.Entry<Integer, View> entry : currentHashes.entrySet()) {
            View view = entry.getValue();
            int currentHash = entry.getKey();
            currentAutofillId = view.getAutofillId();
            currentAutofillId.setSessionId(this.mSessionId);
            if (this.mHashToAutofillIdMap.containsKey(currentHash)) {
                AutofillId oldAutofillId = this.mHashToAutofillIdMap.get(currentHash);
                oldAutofillId.setSessionId(this.mSessionId);
                this.mOldIdsToCurrentAutofillIdMap.put(oldAutofillId, currentAutofillId);
                Log.i(TAG, "Mapping current autofill id: " + view.getAutofillId() + " to existing autofill id " + oldAutofillId);
                oldFailedIdsToCurrentViewMap.put(oldAutofillId, view);
                continue;
            }
            Log.i(TAG, "Couldn't map current autofill id: " + view.getAutofillId() + " with currentHash:" + currentHash + " for view:" + view);
        }
        int viewsCount = 0;
        View[] views = new View[this.mFailedIds.size()];
        for (int i = 0; i < this.mFailedIds.size(); ++i) {
            AutofillId oldAutofillId = this.mFailedIds.get(i);
            currentAutofillId = this.mOldIdsToCurrentAutofillIdMap.get(oldAutofillId);
            if (currentAutofillId == null && Helper.sDebug) {
                Log.d(TAG, "currentAutofillId = null");
            }
            this.mFailedIds.set(i, currentAutofillId);
            views[i] = (View)oldFailedIdsToCurrentViewMap.get(oldAutofillId);
            if (views[i] == null) continue;
            ++viewsCount;
        }
        if (Helper.sDebug) {
            this.dumpCurrentState();
        }
        Slog.i(TAG, "Attempting refill of views. Found " + viewsCount + " views to refill from previously " + this.mFailedIds.size() + " failed ids:" + this.mFailedIds);
        autofillManager.post(() -> autofillManager.autofill(views, this.mFailedIds, this.mFailedAutofillValues, this.mHideHighlight, true));
        return false;
    }

    ArrayMap<Integer, View> getFingerprintIds(@NonNull List<View> views) {
        ArrayMap<Integer, View> map = new ArrayMap<Integer, View>();
        if (this.mUseRelativePosition) {
            Collections.sort(views, (v1, v2) -> {
                int[] posV2;
                int[] posV1 = v1.getLocationOnScreen();
                int compare = posV1[0] - (posV2 = v2.getLocationOnScreen())[0];
                if (compare != 0) {
                    return compare;
                }
                compare = posV1[1] - posV2[1];
                if (compare != 0) {
                    return compare;
                }
                compare = this.compareTop((View)v1, (View)v2);
                if (compare != 0) {
                    return compare;
                }
                compare = this.compareBottom((View)v1, (View)v2);
                if (compare != 0) {
                    return compare;
                }
                compare = this.compareLeft((View)v1, (View)v2);
                if (compare != 0) {
                    return compare;
                }
                return this.compareRight((View)v1, (View)v2);
            });
        }
        for (int i = 0; i < views.size(); ++i) {
            View view = views.get(i);
            map.put(this.getEphemeralFingerprintId(view, i), view);
        }
        return map;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public int getEphemeralFingerprintId(View v, int position) {
        if (v == null) {
            return -1;
        }
        int inputType = Integer.MIN_VALUE;
        int imeOptions = Integer.MIN_VALUE;
        boolean isSingleLine = false;
        CharSequence hints = "";
        if (v instanceof TextView) {
            TextView tv = (TextView)v;
            inputType = tv.getInputType();
            hints = tv.getHint();
            isSingleLine = tv.isSingleLine();
            imeOptions = tv.getImeOptions();
        }
        CharSequence contentDesc = v.getContentDescription();
        CharSequence tooltip = v.getTooltipText();
        int autofillType = v.getAutofillType();
        Object[] autofillHints = v.getAutofillHints();
        int visibility = v.getVisibility();
        int paddingLeft = v.getPaddingLeft();
        int paddingRight = v.getPaddingRight();
        int paddingTop = v.getPaddingTop();
        int paddingBottom = v.getPaddingBottom();
        int height = v.getHeight();
        int width = v.getWidth();
        int hash = Objects.hash(visibility, inputType, imeOptions, isSingleLine, hints, contentDesc, tooltip, autofillType, Arrays.deepHashCode(autofillHints), paddingBottom, paddingTop, paddingRight, paddingLeft);
        if (this.mUseRelativePosition) {
            hash = Objects.hash(hash, position);
        }
        if (Helper.sDebug) {
            Log.d(TAG, "Hash: " + hash + " for AutofillId:" + v.getAutofillId() + " visibility:" + visibility + " inputType:" + inputType + " imeOptions:" + imeOptions + " isSingleLine:" + isSingleLine + " hints:" + hints + " contentDesc:" + contentDesc + " tooltipText:" + tooltip + " autofillType:" + autofillType + " autofillHints:" + Arrays.toString(autofillHints) + " height:" + height + " width:" + width + " paddingLeft:" + paddingLeft + " paddingRight:" + paddingRight + " paddingTop:" + paddingTop + " paddingBottom:" + paddingBottom + " mUseRelativePosition" + this.mUseRelativePosition + " position:" + position);
        }
        return hash;
    }

    private int compareTop(View v1, View v2) {
        return v1.getTop() - v2.getTop();
    }

    private int compareBottom(View v1, View v2) {
        return v1.getBottom() - v2.getBottom();
    }

    private int compareLeft(View v1, View v2) {
        return v1.getLeft() - v2.getLeft();
    }

    private int compareRight(View v1, View v2) {
        return v1.getRight() - v2.getRight();
    }
}

