/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MergedConfiguration;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.window.ActivityWindowInfo;
import android.window.ClientWindowFrames;
import java.util.Objects;

public class WindowRelayoutResult
implements Parcelable {
    @NonNull
    public final ClientWindowFrames frames;
    @NonNull
    public final MergedConfiguration mergedConfiguration;
    @NonNull
    public final InsetsState insetsState;
    @Nullable
    public InsetsSourceControl.Array activeControls;
    public int syncSeqId;
    @Nullable
    public ActivityWindowInfo activityWindowInfo;
    @NonNull
    public static final Parcelable.Creator<WindowRelayoutResult> CREATOR = new Parcelable.Creator<WindowRelayoutResult>(){

        @Override
        public WindowRelayoutResult createFromParcel(@NonNull Parcel in) {
            return new WindowRelayoutResult(in);
        }

        public WindowRelayoutResult[] newArray(int size) {
            return new WindowRelayoutResult[size];
        }
    };

    public WindowRelayoutResult() {
        this(new ClientWindowFrames(), new MergedConfiguration(), new InsetsState(), new InsetsSourceControl.Array());
    }

    public WindowRelayoutResult(WindowRelayoutResult copyFrom) {
        this(new ClientWindowFrames(copyFrom.frames), new MergedConfiguration(copyFrom.mergedConfiguration), new InsetsState(copyFrom.insetsState, true), copyFrom.activeControls != null ? new InsetsSourceControl.Array(copyFrom.activeControls, true) : null);
        this.syncSeqId = copyFrom.syncSeqId;
        if (copyFrom.activityWindowInfo != null) {
            this.activityWindowInfo = new ActivityWindowInfo(copyFrom.activityWindowInfo);
        }
    }

    public WindowRelayoutResult(@NonNull ClientWindowFrames frames, @NonNull MergedConfiguration mergedConfiguration, @NonNull InsetsState insetsState, @Nullable InsetsSourceControl.Array activeControls) {
        this.frames = Objects.requireNonNull(frames);
        this.mergedConfiguration = Objects.requireNonNull(mergedConfiguration);
        this.insetsState = Objects.requireNonNull(insetsState);
        this.activeControls = activeControls;
    }

    private WindowRelayoutResult(@NonNull Parcel in) {
        this(new ClientWindowFrames(), new MergedConfiguration(), new InsetsState(), null);
        this.readFromParcel(in);
    }

    public void readFromParcel(@NonNull Parcel in) {
        this.frames.readFromParcel(in);
        this.mergedConfiguration.readFromParcel(in);
        this.insetsState.readFromParcel(in);
        this.activeControls = in.readTypedObject(InsetsSourceControl.Array.CREATOR);
        this.syncSeqId = in.readInt();
        this.activityWindowInfo = in.readTypedObject(ActivityWindowInfo.CREATOR);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.frames.writeToParcel(dest, flags);
        this.mergedConfiguration.writeToParcel(dest, flags);
        this.insetsState.writeToParcel(dest, flags);
        dest.writeTypedObject(this.activeControls, flags);
        dest.writeInt(this.syncSeqId);
        dest.writeTypedObject(this.activityWindowInfo, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

