/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import java.util.ArrayList;

public class ViewOverlay {
    OverlayViewGroup mOverlayViewGroup;

    ViewOverlay(Context context, View hostView) {
        this.mOverlayViewGroup = new OverlayViewGroup(context, hostView);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    ViewGroup getOverlayView() {
        return this.mOverlayViewGroup;
    }

    public void add(@NonNull Drawable drawable2) {
        this.mOverlayViewGroup.add(drawable2);
    }

    public void remove(@NonNull Drawable drawable2) {
        this.mOverlayViewGroup.remove(drawable2);
    }

    public void clear() {
        this.mOverlayViewGroup.clear();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    boolean isEmpty() {
        return this.mOverlayViewGroup.isEmpty();
    }

    static class OverlayViewGroup
    extends ViewGroup {
        final View mHostView;
        ArrayList<Drawable> mDrawables = null;

        OverlayViewGroup(Context context, View hostView) {
            super(context);
            this.mHostView = hostView;
            this.mAttachInfo = this.mHostView.mAttachInfo;
            this.mRight = hostView.getWidth();
            this.mBottom = hostView.getHeight();
            this.mRenderNode.setLeftTopRightBottom(0, 0, this.mRight, this.mBottom);
        }

        public void add(@NonNull Drawable drawable2) {
            if (drawable2 == null) {
                throw new IllegalArgumentException("drawable must be non-null");
            }
            if (this.mDrawables == null) {
                this.mDrawables = new ArrayList();
            }
            if (!this.mDrawables.contains(drawable2)) {
                this.mDrawables.add(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback(this);
            }
        }

        public void remove(@NonNull Drawable drawable2) {
            if (drawable2 == null) {
                throw new IllegalArgumentException("drawable must be non-null");
            }
            if (this.mDrawables != null) {
                this.mDrawables.remove(drawable2);
                this.invalidate(drawable2.getBounds());
                drawable2.setCallback(null);
            }
        }

        @Override
        protected boolean verifyDrawable(@NonNull Drawable who) {
            return super.verifyDrawable(who) || this.mDrawables != null && this.mDrawables.contains(who);
        }

        public void add(@NonNull View child) {
            if (child == null) {
                throw new IllegalArgumentException("view must be non-null");
            }
            if (child.getParent() instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)child.getParent();
                if (parent != this.mHostView && parent.getParent() != null && parent.mAttachInfo != null) {
                    int[] parentLocation = new int[2];
                    int[] hostViewLocation = new int[2];
                    parent.getLocationOnScreen(parentLocation);
                    this.mHostView.getLocationOnScreen(hostViewLocation);
                    child.offsetLeftAndRight(parentLocation[0] - hostViewLocation[0]);
                    child.offsetTopAndBottom(parentLocation[1] - hostViewLocation[1]);
                }
                parent.removeView(child);
                if (parent.getLayoutTransition() != null) {
                    parent.getLayoutTransition().cancel(3);
                }
                if (child.getParent() != null) {
                    child.mParent = null;
                }
            }
            super.addView(child);
        }

        public void remove(@NonNull View view) {
            if (view == null) {
                throw new IllegalArgumentException("view must be non-null");
            }
            super.removeView(view);
        }

        public void clear() {
            this.removeAllViews();
            if (this.mDrawables != null) {
                for (Drawable drawable2 : this.mDrawables) {
                    drawable2.setCallback(null);
                }
                this.mDrawables.clear();
            }
        }

        boolean isEmpty() {
            return this.getChildCount() == 0 && (this.mDrawables == null || this.mDrawables.size() == 0);
        }

        @Override
        public void invalidateDrawable(@NonNull Drawable drawable2) {
            this.invalidate(drawable2.getBounds());
        }

        @Override
        protected void dispatchDraw(Canvas canvas) {
            canvas.enableZ();
            super.dispatchDraw(canvas);
            canvas.disableZ();
            int numDrawables = this.mDrawables == null ? 0 : this.mDrawables.size();
            for (int i = 0; i < numDrawables; ++i) {
                this.mDrawables.get(i).draw(canvas);
            }
        }

        @Override
        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        @Override
        public void invalidate(Rect dirty) {
            super.invalidate(dirty);
            if (this.mHostView != null) {
                this.mHostView.invalidate(dirty);
            }
        }

        @Override
        public void invalidate(int l, int t, int r, int b) {
            super.invalidate(l, t, r, b);
            if (this.mHostView != null) {
                this.mHostView.invalidate(l, t, r, b);
            }
        }

        @Override
        public void invalidate() {
            super.invalidate();
            if (this.mHostView != null) {
                this.mHostView.invalidate();
            }
        }

        @Override
        public void invalidate(boolean invalidateCache) {
            super.invalidate(invalidateCache);
            if (this.mHostView != null) {
                this.mHostView.invalidate(invalidateCache);
            }
        }

        @Override
        void invalidateViewProperty(boolean invalidateParent, boolean forceRedraw) {
            super.invalidateViewProperty(invalidateParent, forceRedraw);
            if (this.mHostView != null) {
                this.mHostView.invalidateViewProperty(invalidateParent, forceRedraw);
            }
        }

        @Override
        protected void invalidateParentCaches() {
            super.invalidateParentCaches();
            if (this.mHostView != null) {
                this.mHostView.invalidateParentCaches();
            }
        }

        @Override
        protected void invalidateParentIfNeeded() {
            super.invalidateParentIfNeeded();
            if (this.mHostView != null) {
                this.mHostView.invalidateParentIfNeeded();
            }
        }

        @Override
        public void onDescendantInvalidated(@NonNull View child, @NonNull View target) {
            if (this.mHostView != null) {
                if (this.mHostView instanceof ViewGroup) {
                    ((ViewGroup)this.mHostView).onDescendantInvalidated(this.mHostView, target);
                    super.onDescendantInvalidated(child, target);
                } else {
                    this.invalidate();
                }
            }
        }

        @Override
        public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
            if (this.mHostView != null) {
                dirty.offset(location[0], location[1]);
                if (this.mHostView instanceof ViewGroup) {
                    location[0] = 0;
                    location[1] = 0;
                    super.invalidateChildInParent(location, dirty);
                    return ((ViewGroup)this.mHostView).invalidateChildInParent(location, dirty);
                }
                this.invalidate(dirty);
            }
            return null;
        }

        @Override
        @FlaggedApi(value="android.view.flags.view_velocity_api")
        public float getFrameContentVelocity() {
            if (this.mHostView != null) {
                return this.mHostView.getFrameContentVelocity();
            }
            return super.getFrameContentVelocity();
        }
    }
}

