/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.hardware.input.InputManagerGlobal;
import android.util.ArrayMap;
import android.util.Pools;
import android.view.MotionEvent;
import android.view.VelocityTracker_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public final class VelocityTracker {
    private static final Pools.SynchronizedPool<VelocityTracker> sPool = new Pools.SynchronizedPool(2);
    private static final int ACTIVE_POINTER_ID = -1;
    public static final int VELOCITY_TRACKER_STRATEGY_DEFAULT = -1;
    public static final int VELOCITY_TRACKER_STRATEGY_IMPULSE = 0;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ1 = 1;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ2 = 2;
    public static final int VELOCITY_TRACKER_STRATEGY_LSQ3 = 3;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_DELTA = 4;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_CENTRAL = 5;
    public static final int VELOCITY_TRACKER_STRATEGY_WLSQ2_RECENT = 6;
    public static final int VELOCITY_TRACKER_STRATEGY_INT1 = 7;
    public static final int VELOCITY_TRACKER_STRATEGY_INT2 = 8;
    public static final int VELOCITY_TRACKER_STRATEGY_LEGACY = 9;
    private static final Map<String, Integer> STRATEGIES = new ArrayMap<String, Integer>();
    private long mPtr;
    private final int mStrategy;

    private static native long nativeInitialize(int var0);

    private static native void nativeDispose(long var0);

    private static native void nativeClear(long var0);

    private static native void nativeAddMovement(long var0, MotionEvent var2);

    private static native void nativeComputeCurrentVelocity(long var0, int var2, float var3);

    private static native float nativeGetVelocity(long var0, int var2, int var3);

    private static native boolean nativeIsAxisSupported(int var0);

    private static int toStrategyId(String strStrategy) {
        if (STRATEGIES.containsKey(strStrategy)) {
            return STRATEGIES.get(strStrategy);
        }
        return -1;
    }

    public static VelocityTracker obtain_Original() {
        VelocityTracker instance = sPool.acquire();
        return instance != null ? instance : new VelocityTracker(-1);
    }

    @LayoutlibDelegate
    public static VelocityTracker obtain() {
        return VelocityTracker_Delegate.obtain();
    }

    @Deprecated
    @UnsupportedAppUsage
    public static VelocityTracker obtain_Original(String strategy) {
        if (strategy == null) {
            return VelocityTracker.obtain();
        }
        return new VelocityTracker(VelocityTracker.toStrategyId(strategy));
    }

    @LayoutlibDelegate
    public static VelocityTracker obtain(String string2) {
        return VelocityTracker_Delegate.obtain(string2);
    }

    public static VelocityTracker obtain_Original(int strategy) {
        if (strategy == -1) {
            return VelocityTracker.obtain();
        }
        return new VelocityTracker(strategy);
    }

    @LayoutlibDelegate
    public static VelocityTracker obtain(int n) {
        return VelocityTracker_Delegate.obtain(n);
    }

    public void recycle() {
        if (this.mStrategy == -1) {
            this.clear();
            sPool.release(this);
        }
    }

    public int getStrategyId() {
        return this.mStrategy;
    }

    private VelocityTracker(int strategy) {
        String strategyProperty;
        this.mStrategy = strategy == -1 ? ((strategyProperty = InputManagerGlobal.getInstance().getVelocityTrackerStrategy()) == null || strategyProperty.isEmpty() ? strategy : VelocityTracker.toStrategyId(strategyProperty)) : strategy;
        this.mPtr = VelocityTracker.nativeInitialize(this.mStrategy);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPtr != 0L) {
                VelocityTracker.nativeDispose(this.mPtr);
                this.mPtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean isAxisSupported(int axis) {
        return VelocityTracker.nativeIsAxisSupported(axis);
    }

    public void clear() {
        VelocityTracker.nativeClear(this.mPtr);
    }

    public void addMovement(MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        VelocityTracker.nativeAddMovement(this.mPtr, event);
    }

    public void computeCurrentVelocity(int units) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, maxVelocity);
    }

    public float getXVelocity() {
        return this.getXVelocity(-1);
    }

    public float getYVelocity() {
        return this.getYVelocity(-1);
    }

    public float getXVelocity(int id2) {
        return VelocityTracker.nativeGetVelocity(this.mPtr, 0, id2);
    }

    public float getYVelocity(int id2) {
        return VelocityTracker.nativeGetVelocity(this.mPtr, 1, id2);
    }

    public float getAxisVelocity(int axis, int id2) {
        return VelocityTracker.nativeGetVelocity(this.mPtr, axis, id2);
    }

    public float getAxisVelocity(int axis) {
        return VelocityTracker.nativeGetVelocity(this.mPtr, axis, -1);
    }

    static {
        STRATEGIES.put("impulse", 0);
        STRATEGIES.put("lsq1", 1);
        STRATEGIES.put("lsq2", 2);
        STRATEGIES.put("lsq3", 3);
        STRATEGIES.put("wlsq2-delta", 4);
        STRATEGIES.put("wlsq2-central", 5);
        STRATEGIES.put("wlsq2-recent", 6);
        STRATEGIES.put("int1", 7);
        STRATEGIES.put("int2", 8);
        STRATEGIES.put("legacy", 9);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VelocityTrackerStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VelocityTrackableMotionEventAxis {
    }
}

