/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.ScrollCaptureCallback;
import android.view.View;
import java.io.PrintWriter;
import java.util.Objects;

public class ScrollCaptureTarget {
    private final View mContainingView;
    private final ScrollCaptureCallback mCallback;
    private final Rect mLocalVisibleRect;
    private final Point mPositionInWindow;
    private final int mHint;
    private Rect mScrollBounds;
    private final int[] mTmpIntArr = new int[2];

    public ScrollCaptureTarget(@NonNull View scrollTarget, @NonNull Rect localVisibleRect, @NonNull Point positionInWindow, @NonNull ScrollCaptureCallback callback) {
        this.mContainingView = Objects.requireNonNull(scrollTarget);
        this.mHint = this.mContainingView.getScrollCaptureHint();
        this.mCallback = Objects.requireNonNull(callback);
        this.mLocalVisibleRect = Objects.requireNonNull(localVisibleRect);
        this.mPositionInWindow = Objects.requireNonNull(positionInWindow);
    }

    public int getHint() {
        return this.mHint;
    }

    @NonNull
    public ScrollCaptureCallback getCallback() {
        return this.mCallback;
    }

    @NonNull
    public View getContainingView() {
        return this.mContainingView;
    }

    @NonNull
    public Rect getLocalVisibleRect() {
        return this.mLocalVisibleRect;
    }

    @NonNull
    public Point getPositionInWindow() {
        return this.mPositionInWindow;
    }

    @Nullable
    public Rect getScrollBounds() {
        return this.mScrollBounds;
    }

    public void setScrollBounds(@Nullable Rect scrollBounds) {
        this.mScrollBounds = Rect.copyOrNull(scrollBounds);
        if (this.mScrollBounds == null) {
            return;
        }
        if (!this.mScrollBounds.intersect(0, 0, this.mContainingView.getWidth(), this.mContainingView.getHeight())) {
            this.mScrollBounds.setEmpty();
        }
    }

    public void updatePositionInWindow() {
        this.mContainingView.getLocationInWindow(this.mTmpIntArr);
        this.mPositionInWindow.x = this.mTmpIntArr[0];
        this.mPositionInWindow.y = this.mTmpIntArr[1];
    }

    public String toString() {
        return "ScrollCaptureTarget{view=" + this.mContainingView + ", callback=" + this.mCallback + ", scrollBounds=" + this.mScrollBounds + ", localVisibleRect=" + this.mLocalVisibleRect + ", positionInWindow=" + this.mPositionInWindow + "}";
    }

    void dump(@NonNull PrintWriter writer) {
        View view = this.getContainingView();
        writer.println("view: " + view);
        writer.println("hint: " + this.mHint);
        writer.println("callback: " + this.mCallback);
        writer.println("scrollBounds: " + (this.mScrollBounds == null ? "null" : this.mScrollBounds.toShortString()));
        Point inWindow = this.getPositionInWindow();
        writer.println("positionInWindow: " + (inWindow == null ? "null" : "[" + inWindow.x + "," + inWindow.y + "]"));
        Rect localVisible = this.getLocalVisibleRect();
        writer.println("localVisibleRect: " + (localVisible == null ? "null" : localVisible.toShortString()));
    }
}

