/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.os.Binder;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import android.window.IScreenRecordingCallback;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ScreenRecordingCallbacks {
    private static ScreenRecordingCallbacks sInstance;
    private static final Object sLock;
    private final ArrayMap<Consumer<Integer>, Executor> mCallbacks = new ArrayMap();
    private IScreenRecordingCallback mCallbackNotifier;
    private int mState = 0;

    private ScreenRecordingCallbacks() {
    }

    @NonNull
    private static IWindowManager getWindowManagerService() {
        return Objects.requireNonNull(WindowManagerGlobal.getWindowManagerService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScreenRecordingCallbacks getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new ScreenRecordingCallbacks();
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DETECT_SCREEN_RECORDING")
    int addCallback(@NonNull Executor executor, @NonNull Consumer<Integer> callback) {
        Object object = sLock;
        synchronized (object) {
            if (this.mCallbackNotifier == null) {
                this.mCallbackNotifier = new IScreenRecordingCallback.Stub(){

                    @Override
                    public void onScreenRecordingStateChanged(boolean visibleInScreenRecording) {
                        int state = visibleInScreenRecording ? 1 : 0;
                        ScreenRecordingCallbacks.this.notifyCallbacks(state);
                    }
                };
                try {
                    boolean visibleInScreenRecording = ScreenRecordingCallbacks.getWindowManagerService().registerScreenRecordingCallback(this.mCallbackNotifier);
                    this.mState = visibleInScreenRecording ? 1 : 0;
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
            this.mCallbacks.put(callback, executor);
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DETECT_SCREEN_RECORDING")
    void removeCallback(@NonNull Consumer<Integer> callback) {
        Object object = sLock;
        synchronized (object) {
            this.mCallbacks.remove(callback);
            if (this.mCallbacks.isEmpty()) {
                try {
                    ScreenRecordingCallbacks.getWindowManagerService().unregisterScreenRecordingCallback(this.mCallbackNotifier);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                this.mCallbackNotifier = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCallbacks(int state) {
        ArrayList<Runnable> callbacks;
        Object object = sLock;
        synchronized (object) {
            this.mState = state;
            if (this.mCallbacks.isEmpty()) {
                return;
            }
            callbacks = new ArrayList<Runnable>();
            for (int i = 0; i < this.mCallbacks.size(); ++i) {
                Consumer<Integer> callback = this.mCallbacks.keyAt(i);
                Executor executor = this.mCallbacks.valueAt(i);
                callbacks.add(() -> executor.execute(() -> callback.accept(state)));
            }
        }
        long token = Binder.clearCallingIdentity();
        try {
            for (int i = 0; i < callbacks.size(); ++i) {
                ((Runnable)callbacks.get(i)).run();
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    static {
        sLock = new Object();
    }
}

