/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.RecordingCanvas;
import android.media.Image;
import android.media.ImageReader;
import android.view.AttachInfo_Accessor;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import com.android.internal.lang.System_Delegate;
import java.nio.ByteBuffer;

public class LayoutlibRenderer {
    private final ThreadedRenderer mDelegateRenderer;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ImageReader mImageReader;
    private Image mNativeImage;

    LayoutlibRenderer(Context context, boolean translucent, String name) {
        this.mDelegateRenderer = new ThreadedRenderer(context, translucent, name);
    }

    public void draw(final ViewGroup viewGroup) {
        ViewRootImpl rootView = AttachInfo_Accessor.getRootView(viewGroup);
        if (rootView == null) {
            return;
        }
        rootView.mAttachInfo.mDrawingTime = System_Delegate.currentTimeMillis();
        this.mDelegateRenderer.draw(viewGroup, rootView.mAttachInfo, new ThreadedRenderer.DrawCallbacks(){

            @Override
            public void onPreDraw(RecordingCanvas canvas) {
                AttachInfo_Accessor.dispatchOnPreDraw(viewGroup);
                canvas.scale(LayoutlibRenderer.this.scaleX, LayoutlibRenderer.this.scaleY);
                canvas.drawColor(0, BlendMode.CLEAR);
            }

            @Override
            public void onPostDraw(RecordingCanvas canvas) {
            }
        });
        this.mDelegateRenderer.fence();
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.mDelegateRenderer.invalidateRoot();
    }

    public void setup(int width, int height, View rootView) {
        ViewRootImpl viewRoot = rootView.mAttachInfo.mViewRootImpl;
        if (viewRoot == null) {
            return;
        }
        if (this.mImageReader == null) {
            this.mImageReader = ImageReader.newInstance(width, height, 1, 1);
            this.mDelegateRenderer.setSurface(this.mImageReader.getSurface());
        }
        this.mNativeImage = this.mImageReader.acquireLatestImage();
        this.mDelegateRenderer.setup(width, height, rootView.mAttachInfo, viewRoot.mWindowAttributes.surfaceInsets);
    }

    public ByteBuffer getBuffer() {
        Image.Plane[] planes = this.mNativeImage.getPlanes();
        return planes[0].getBuffer();
    }

    public void reset() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
    }

    public ThreadedRenderer getThreadedRenderer() {
        return this.mDelegateRenderer;
    }

    public void destroy() {
        this.mDelegateRenderer.destroy();
    }
}

