/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.KeyboardShortcutInfo;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class KeyboardShortcutGroup
implements Parcelable {
    private final CharSequence mLabel;
    private final List<KeyboardShortcutInfo> mItems;
    private boolean mSystemGroup;
    private CharSequence mPackageName;
    @NonNull
    public static final Parcelable.Creator<KeyboardShortcutGroup> CREATOR = new Parcelable.Creator<KeyboardShortcutGroup>(){

        @Override
        public KeyboardShortcutGroup createFromParcel(Parcel source) {
            return new KeyboardShortcutGroup(source);
        }

        public KeyboardShortcutGroup[] newArray(int size) {
            return new KeyboardShortcutGroup[size];
        }
    };

    public KeyboardShortcutGroup(@Nullable CharSequence label, @NonNull List<KeyboardShortcutInfo> items) {
        this.mLabel = label;
        this.mItems = new ArrayList<KeyboardShortcutInfo>((Collection)Preconditions.checkNotNull(items));
    }

    public KeyboardShortcutGroup(@Nullable CharSequence label) {
        this(label, Collections.emptyList());
    }

    public KeyboardShortcutGroup(@Nullable CharSequence label, @NonNull List<KeyboardShortcutInfo> items, boolean isSystemGroup) {
        this.mLabel = label;
        this.mItems = new ArrayList<KeyboardShortcutInfo>((Collection)Preconditions.checkNotNull(items));
        this.mSystemGroup = isSystemGroup;
    }

    public KeyboardShortcutGroup(@Nullable CharSequence label, boolean isSystemGroup) {
        this(label, Collections.emptyList(), isSystemGroup);
    }

    private KeyboardShortcutGroup(Parcel source) {
        this.mItems = new ArrayList<KeyboardShortcutInfo>();
        this.mLabel = source.readCharSequence();
        source.readTypedList(this.mItems, KeyboardShortcutInfo.CREATOR);
        this.mSystemGroup = source.readInt() == 1;
        this.mPackageName = source.readCharSequence();
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public List<KeyboardShortcutInfo> getItems() {
        return this.mItems;
    }

    public boolean isSystemGroup() {
        return this.mSystemGroup;
    }

    public void setPackageName(CharSequence packageName) {
        this.mPackageName = packageName;
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void addItem(KeyboardShortcutInfo item) {
        this.mItems.add(item);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeCharSequence(this.mLabel);
        dest.writeTypedList(this.mItems);
        dest.writeInt(this.mSystemGroup ? 1 : 0);
        dest.writeCharSequence(this.mPackageName);
    }
}

