/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.Nullable;
import android.content.res.CompatibilityInfo;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseSetArray;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsAnimationSpec;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InternalInsetsAnimationController;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.animation.Interpolator;
import android.view.inputmethod.ImeTracker;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Objects;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class InsetsAnimationControlImpl
implements InternalInsetsAnimationController,
InsetsAnimationControlRunner {
    private static final String TAG = "InsetsAnimationCtrlImpl";
    private final Rect mTmpFrame = new Rect();
    private final WindowInsetsAnimationControlListener mListener;
    private final SparseArray<InsetsSourceControl> mControls;
    private final SparseSetArray<InsetsSourceControl> mSideControlsMap = new SparseSetArray();
    private final Insets mHiddenInsets;
    private final Insets mShownInsets;
    private final Matrix mTmpMatrix = new Matrix();
    private final InsetsState mInitialInsetsState;
    private final int mAnimationType;
    private int mLayoutInsetsDuringAnimation;
    private final int mTypes;
    private int mControllingTypes;
    private final InsetsAnimationControlCallbacks mController;
    private final InsetsAnimationControlRunner.SurfaceParamsApplier mSurfaceParamsApplier;
    private final WindowInsetsAnimation mAnimation;
    private final long mDurationMs;
    private final Interpolator mInterpolator;
    private final boolean mHasZeroInsetsIme;
    private final CompatibilityInfo.Translator mTranslator;
    @Nullable
    private final ImeTracker.Token mStatsToken;
    private Insets mCurrentInsets;
    private Insets mPendingInsets;
    private float mPendingFraction;
    private boolean mFinished;
    private boolean mCancelling;
    private boolean mCancelled;
    private boolean mShownOnFinish;
    private float mCurrentAlpha = 1.0f;
    private float mPendingAlpha = 1.0f;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private boolean mReadyDispatched;
    private Boolean mPerceptible;

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public InsetsAnimationControlImpl(SparseArray<InsetsSourceControl> controls, @Nullable Rect frame, @Nullable Rect bounds, InsetsState state, WindowInsetsAnimationControlListener listener, int types, InsetsAnimationControlCallbacks controller, InsetsAnimationControlRunner.SurfaceParamsApplier surfaceParamsApplier, InsetsAnimationSpec insetsAnimationSpec, int animationType, int layoutInsetsDuringAnimation, CompatibilityInfo.Translator translator, @Nullable ImeTracker.Token statsToken) {
        this.mControls = controls;
        this.mListener = listener;
        this.mTypes = types;
        this.mControllingTypes = types;
        this.mController = controller;
        this.mSurfaceParamsApplier = surfaceParamsApplier;
        this.mInitialInsetsState = new InsetsState(state, true);
        if (frame != null && bounds != null) {
            SparseIntArray idSideMap = new SparseIntArray();
            this.mCurrentInsets = this.getInsetsFromState(this.mInitialInsetsState, frame, bounds, null);
            this.mHiddenInsets = this.calculateInsets(this.mInitialInsetsState, frame, bounds, controls, false, null);
            this.mShownInsets = this.calculateInsets(this.mInitialInsetsState, frame, bounds, controls, true, idSideMap);
            boolean bl = this.mHasZeroInsetsIme = this.mShownInsets.bottom == 0 && this.controlsType(WindowInsets.Type.ime());
            if (this.mHasZeroInsetsIme) {
                idSideMap.put(InsetsSource.ID_IME, 4);
            }
            InsetsAnimationControlImpl.buildSideControlsMap(idSideMap, this.mSideControlsMap, controls);
        } else {
            this.mCurrentInsets = this.calculateInsets(this.mInitialInsetsState, controls, true);
            this.mHiddenInsets = this.calculateInsets(null, controls, false);
            this.mShownInsets = this.calculateInsets(null, controls, true);
            this.mHasZeroInsetsIme = this.mShownInsets.bottom == 0 && this.controlsType(WindowInsets.Type.ime());
            InsetsAnimationControlImpl.buildSideControlsMap(this.mSideControlsMap, controls);
        }
        this.mPendingInsets = this.mCurrentInsets;
        this.mDurationMs = insetsAnimationSpec.getDurationMs(this.mHasZeroInsetsIme);
        this.mInterpolator = insetsAnimationSpec.getInsetsInterpolator(this.mHasZeroInsetsIme);
        this.mAnimation = new WindowInsetsAnimation(this.mTypes, this.mInterpolator, this.mDurationMs);
        this.mAnimation.setAlpha(this.getCurrentAlpha());
        this.mAnimationType = animationType;
        this.mLayoutInsetsDuringAnimation = layoutInsetsDuringAnimation;
        this.mTranslator = translator;
        this.mStatsToken = statsToken;
        if (ImeTracker.DEBUG_IME_VISIBILITY && (types & WindowInsets.Type.ime()) != 0) {
            EventLog.writeEvent(32006, this.mStatsToken != null ? this.mStatsToken.getTag() : "TOKEN_NONE", this.mAnimationType, Float.valueOf(this.mCurrentAlpha), "Current:" + this.mCurrentInsets, "Shown:" + this.mShownInsets, "Hidden:" + this.mHiddenInsets);
        }
        this.mController.startAnimation(this, listener, types, this.mAnimation, new WindowInsetsAnimation.Bounds(this.mHiddenInsets, this.mShownInsets));
    }

    private boolean calculatePerceptible(Insets currentInsets, float currentAlpha) {
        return 100 * currentInsets.left >= 5 * (this.mShownInsets.left - this.mHiddenInsets.left) && 100 * currentInsets.top >= 5 * (this.mShownInsets.top - this.mHiddenInsets.top) && 100 * currentInsets.right >= 5 * (this.mShownInsets.right - this.mHiddenInsets.right) && 100 * currentInsets.bottom >= 5 * (this.mShownInsets.bottom - this.mHiddenInsets.bottom) && currentAlpha >= 0.5f;
    }

    @Override
    public boolean hasZeroInsetsIme() {
        return this.mHasZeroInsetsIme;
    }

    @Override
    public long getDurationMs() {
        return this.mDurationMs;
    }

    @Override
    public Interpolator getInsetsInterpolator() {
        return this.mInterpolator;
    }

    @Override
    public void setReadyDispatched(boolean dispatched) {
        this.mReadyDispatched = dispatched;
    }

    @Override
    public Insets getHiddenStateInsets() {
        return this.mHiddenInsets;
    }

    @Override
    public Insets getShownStateInsets() {
        return this.mShownInsets;
    }

    @Override
    public Insets getCurrentInsets() {
        return this.mCurrentInsets;
    }

    @Override
    public float getCurrentAlpha() {
        return this.mCurrentAlpha;
    }

    @Override
    public int getTypes() {
        return this.mTypes;
    }

    @Override
    public int getControllingTypes() {
        return this.mControllingTypes;
    }

    @Override
    public void notifyControlRevoked(int types) {
        this.mControllingTypes &= ~types;
    }

    @Override
    public void updateSurfacePosition(SparseArray<InsetsSourceControl> controls) {
        for (int i = controls.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = controls.valueAt(i);
            InsetsSourceControl c = this.mControls.get(control.getId());
            if (c == null) continue;
            Point position = control.getSurfacePosition();
            c.setSurfacePosition(position.x, position.y);
        }
    }

    @Override
    public boolean willUpdateSurface() {
        return !this.mFinished && !this.mCancelled;
    }

    @Override
    public int getAnimationType() {
        return this.mAnimationType;
    }

    @Override
    public InsetsAnimationControlRunner.SurfaceParamsApplier getSurfaceParamsApplier() {
        return this.mSurfaceParamsApplier;
    }

    @Override
    @Nullable
    public ImeTracker.Token getStatsToken() {
        return this.mStatsToken;
    }

    @Override
    public void setInsetsAndAlpha(Insets insets, float alpha, float fraction2) {
        this.setInsetsAndAlpha(insets, alpha, fraction2, false);
    }

    private void setInsetsAndAlpha(Insets insets, float alpha, float fraction2, boolean allowWhenFinished) {
        if (!allowWhenFinished && this.mFinished) {
            throw new IllegalStateException("Can't change insets on an animation that is finished.");
        }
        if (this.mCancelled) {
            throw new IllegalStateException("Can't change insets on an animation that is cancelled.");
        }
        this.mPendingFraction = InsetsAnimationControlImpl.sanitize(fraction2);
        this.mPendingInsets = this.sanitize(insets);
        this.mPendingAlpha = InsetsAnimationControlImpl.sanitize(alpha);
        this.mController.scheduleApplyChangeInsets(this);
        boolean perceptible = this.calculatePerceptible(this.mPendingInsets, this.mPendingAlpha);
        if (this.mPerceptible == null || perceptible != this.mPerceptible) {
            this.mController.reportPerceptible(this.mTypes, perceptible);
            this.mPerceptible = perceptible;
        }
    }

    @Override
    @VisibleForTesting
    public boolean applyChangeInsets(@Nullable InsetsState outState) {
        if (this.mCancelled) {
            return false;
        }
        Insets offset = Insets.subtract(this.mShownInsets, this.mPendingInsets);
        ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams> params = new ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams>();
        this.updateLeashesForSide(1, offset.left, params, outState, this.mPendingAlpha);
        this.updateLeashesForSide(2, offset.top, params, outState, this.mPendingAlpha);
        this.updateLeashesForSide(3, offset.right, params, outState, this.mPendingAlpha);
        this.updateLeashesForSide(4, offset.bottom, params, outState, this.mPendingAlpha);
        this.mSurfaceParamsApplier.applySurfaceParams(params.toArray(new SyncRtSurfaceTransactionApplier.SurfaceParams[params.size()]));
        this.mCurrentInsets = this.mPendingInsets;
        this.mAnimation.setFraction(this.mPendingFraction);
        this.mCurrentAlpha = this.mPendingAlpha;
        this.mAnimation.setAlpha(this.mPendingAlpha);
        if (this.mFinished) {
            this.mController.notifyFinished(this, this.mShownOnFinish);
            this.releaseLeashes();
        }
        return this.mFinished;
    }

    private void releaseLeashes() {
        for (int i = this.mControls.size() - 1; i >= 0; --i) {
            InsetsSourceControl c = this.mControls.valueAt(i);
            if (c == null) continue;
            c.release(this.mController::releaseSurfaceControlFromRt);
        }
    }

    @Override
    public void finish(boolean shown) {
        if (this.mCancelled || this.mFinished) {
            return;
        }
        this.mShownOnFinish = shown;
        this.mFinished = true;
        Insets insets = shown ? this.mShownInsets : this.mHiddenInsets;
        this.setInsetsAndAlpha(insets, this.mPendingAlpha, 1.0f, true);
        this.mListener.onFinished(this);
        if (ImeTracker.DEBUG_IME_VISIBILITY && (this.mTypes & WindowInsets.Type.ime()) != 0) {
            EventLog.writeEvent(32007, this.mStatsToken != null ? this.mStatsToken.getTag() : "TOKEN_NONE", this.mAnimationType, Float.valueOf(this.mCurrentAlpha), shown ? 1 : 0, Objects.toString(insets));
        }
    }

    @Override
    @VisibleForTesting
    public float getCurrentFraction() {
        return this.mAnimation.getFraction();
    }

    @Override
    public void cancel() {
        if (this.mFinished) {
            return;
        }
        this.mPendingInsets = this.mLayoutInsetsDuringAnimation == 0 ? this.mShownInsets : this.mHiddenInsets;
        this.mPendingAlpha = 1.0f;
        this.mCancelling = true;
        this.applyChangeInsets(null);
        this.mCancelled = true;
        this.mListener.onCancelled(this.mReadyDispatched ? this : null);
        if (ImeTracker.DEBUG_IME_VISIBILITY && (this.mTypes & WindowInsets.Type.ime()) != 0) {
            EventLog.writeEvent(32008, this.mStatsToken != null ? this.mStatsToken.getTag() : "TOKEN_NONE", this.mAnimationType, Objects.toString(this.mPendingInsets));
        }
        this.releaseLeashes();
    }

    @Override
    public boolean isFinished() {
        return this.mFinished;
    }

    @Override
    public boolean isCancelled() {
        return this.mCancelled;
    }

    @Override
    public WindowInsetsAnimation getAnimation() {
        return this.mAnimation;
    }

    @Override
    public void updateLayoutInsetsDuringAnimation(int layoutInsetsDuringAnimation) {
        this.mLayoutInsetsDuringAnimation = layoutInsetsDuringAnimation;
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mCancelled);
        proto.write(1133871366146L, this.mFinished);
        proto.write(1138166333443L, Objects.toString(this.mTmpMatrix));
        proto.write(1138166333444L, Objects.toString(this.mPendingInsets));
        proto.write(1108101562373L, this.mPendingFraction);
        proto.write(1133871366150L, this.mShownOnFinish);
        proto.write(1108101562375L, this.mCurrentAlpha);
        proto.write(1108101562376L, this.mPendingAlpha);
        proto.end(token);
    }

    SparseArray<InsetsSourceControl> getControls() {
        return this.mControls;
    }

    private Insets getInsetsFromState(InsetsState state, Rect frame, Rect bounds, @Nullable SparseIntArray idSideMap) {
        return state.calculateInsets(frame, bounds, null, false, 16, 0, 0, 2, 0, idSideMap).getInsets(this.mTypes);
    }

    private Insets calculateInsets(InsetsState state, Rect frame, Rect bounds, SparseArray<InsetsSourceControl> controls, boolean shown, @Nullable SparseIntArray idSideMap) {
        for (int i = controls.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = controls.valueAt(i);
            if (control == null) continue;
            state.setSourceVisible(control.getId(), shown);
        }
        return this.getInsetsFromState(state, frame, bounds, idSideMap);
    }

    private Insets calculateInsets(InsetsState state, SparseArray<InsetsSourceControl> controls, boolean shownOrCurrent) {
        Insets insets = Insets.NONE;
        if (!shownOrCurrent) {
            return insets;
        }
        for (int i = controls.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = controls.valueAt(i);
            if (control == null || state != null && !state.isSourceOrDefaultVisible(control.getId(), control.getType())) continue;
            insets = Insets.max(insets, control.getInsetsHint());
        }
        return insets;
    }

    private Insets sanitize(Insets insets) {
        if (insets == null) {
            insets = this.getCurrentInsets();
        }
        if (this.hasZeroInsetsIme()) {
            return insets;
        }
        return Insets.max(Insets.min(insets, this.mShownInsets), this.mHiddenInsets);
    }

    private static float sanitize(float alpha) {
        return alpha >= 1.0f ? 1.0f : (alpha <= 0.0f ? 0.0f : alpha);
    }

    private void updateLeashesForSide(int side, int offset, ArrayList<SyncRtSurfaceTransactionApplier.SurfaceParams> surfaceParams, @Nullable InsetsState outState, float alpha) {
        ArraySet<InsetsSourceControl> controls = this.mSideControlsMap.get(side);
        if (controls == null) {
            return;
        }
        boolean visible = this.mFinished ? this.mShownOnFinish : (this.mCancelling ? this.mLayoutInsetsDuringAnimation == 0 : this.mAnimationType != 0 || this.mPendingFraction != 0.0f);
        for (int i = controls.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = controls.valueAt(i);
            InsetsSource source = this.mInitialInsetsState.peekSource(control.getId());
            SurfaceControl leash = control.getLeash();
            this.mTmpMatrix.setTranslate(control.getSurfacePosition().x, control.getSurfacePosition().y);
            if (source != null) {
                this.mTmpFrame.set(source.getFrame());
            }
            this.addTranslationToMatrix(side, offset, this.mTmpMatrix, this.mTmpFrame);
            if (outState != null && source != null) {
                outState.addSource(new InsetsSource(source).setVisible(visible).setFrame(this.mTmpFrame));
            }
            if (leash == null) continue;
            SyncRtSurfaceTransactionApplier.SurfaceParams params = new SyncRtSurfaceTransactionApplier.SurfaceParams.Builder(leash).withAlpha(alpha).withMatrix(this.mTmpMatrix).withVisibility(visible).build();
            surfaceParams.add(params);
        }
    }

    private void addTranslationToMatrix(int side, int offset, Matrix m, Rect frame) {
        float surfaceOffset = this.mTranslator != null ? this.mTranslator.translateLengthInAppWindowToScreen(offset) : (float)offset;
        switch (side) {
            case 1: {
                m.postTranslate(-surfaceOffset, 0.0f);
                frame.offset(-offset, 0);
                break;
            }
            case 2: {
                m.postTranslate(0.0f, -surfaceOffset);
                frame.offset(0, -offset);
                break;
            }
            case 3: {
                m.postTranslate(surfaceOffset, 0.0f);
                frame.offset(offset, 0);
                break;
            }
            case 4: {
                m.postTranslate(0.0f, surfaceOffset);
                frame.offset(0, offset);
            }
        }
    }

    private static void buildSideControlsMap(SparseIntArray idSideMap, SparseSetArray<InsetsSourceControl> sideControlsMap, SparseArray<InsetsSourceControl> controls) {
        for (int i = idSideMap.size() - 1; i >= 0; --i) {
            int type = idSideMap.keyAt(i);
            int side = idSideMap.valueAt(i);
            InsetsSourceControl control = controls.get(type);
            if (control == null) continue;
            sideControlsMap.add(side, control);
        }
    }

    private static void buildSideControlsMap(SparseSetArray<InsetsSourceControl> sideControlsMap, SparseArray<InsetsSourceControl> controls) {
        for (int i = controls.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = controls.valueAt(i);
            if (control == null) continue;
            int side = InsetsSource.getInsetSide(control.getInsetsHint());
            if (side == 0 && control.getType() == WindowInsets.Type.ime()) {
                side = 4;
            }
            sideControlsMap.add(side, control);
        }
    }
}

