/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ClipData;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.WindowRelayoutResult;
import android.view.inputmethod.ImeTracker;
import android.window.InputTransferToken;
import android.window.OnBackInvokedCallbackInfo;
import java.util.ArrayList;
import java.util.List;

public interface IWindowSession
extends IInterface {
    public int addToDisplay(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, InputChannel var6, WindowRelayoutResult var7) throws RemoteException;

    public int addToDisplayAsUser(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, int var6, InputChannel var7, WindowRelayoutResult var8) throws RemoteException;

    public int addToDisplayWithoutInputChannel(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, WindowRelayoutResult var5) throws RemoteException;

    public void remove(IBinder var1) throws RemoteException;

    public int relayout(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, int var6, int var7, int var8, WindowRelayoutResult var9, SurfaceControl var10) throws RemoteException;

    public void relayoutAsync(IWindow var1, WindowManager.LayoutParams var2, int var3, int var4, int var5, int var6, int var7, int var8) throws RemoteException;

    public boolean outOfMemory(IWindow var1) throws RemoteException;

    public void setInsets(IWindow var1, int var2, Rect var3, Rect var4, Region var5) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:135:1:135:25")
    public void finishDrawing(IWindow var1, SurfaceControl.Transaction var2, int var3) throws RemoteException;

    public IBinder performDrag(IWindow var1, int var2, SurfaceControl var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, ClipData var11) throws RemoteException;

    public boolean dropForAccessibility(IWindow var1, int var2, int var3) throws RemoteException;

    public void reportDropResult(IWindow var1, boolean var2) throws RemoteException;

    public void cancelDragAndDrop(IBinder var1, boolean var2) throws RemoteException;

    public void dragRecipientEntered(IWindow var1) throws RemoteException;

    public void dragRecipientExited(IWindow var1) throws RemoteException;

    public void setWallpaperPosition(IBinder var1, float var2, float var3, float var4, float var5) throws RemoteException;

    public void setWallpaperZoomOut(IBinder var1, float var2) throws RemoteException;

    public void setShouldZoomOutWallpaper(IBinder var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:211:1:211:25")
    public void wallpaperOffsetsComplete(IBinder var1) throws RemoteException;

    public void setWallpaperDisplayOffset(IBinder var1, int var2, int var3) throws RemoteException;

    public void sendWallpaperCommand(IBinder var1, String var2, int var3, int var4, int var5, Bundle var6, boolean var7) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowSession.aidl:222:1:222:25")
    public void wallpaperCommandComplete(IBinder var1, Bundle var2) throws RemoteException;

    public void onRectangleOnScreenRequested(IBinder var1, Rect var2, int var3) throws RemoteException;

    public IWindowId getWindowId(IBinder var1) throws RemoteException;

    public void pokeDrawLock(IBinder var1) throws RemoteException;

    public boolean startMovingTask(IWindow var1, float var2, float var3) throws RemoteException;

    public void finishMovingTask(IWindow var1) throws RemoteException;

    public void updateTapExcludeRegion(IWindow var1, Region var2) throws RemoteException;

    public void updateRequestedVisibleTypes(IWindow var1, int var2, ImeTracker.Token var3) throws RemoteException;

    public void updateAnimatingTypes(IWindow var1, int var2, ImeTracker.Token var3) throws RemoteException;

    public void reportSystemGestureExclusionChanged(IWindow var1, List<Rect> var2) throws RemoteException;

    public void reportDecorViewGestureInterceptionChanged(IWindow var1, boolean var2) throws RemoteException;

    public void reportKeepClearAreasChanged(IWindow var1, List<Rect> var2, List<Rect> var3) throws RemoteException;

    public void grantInputChannel(int var1, SurfaceControl var2, IBinder var3, InputTransferToken var4, int var5, int var6, int var7, int var8, IBinder var9, InputTransferToken var10, String var11, InputChannel var12) throws RemoteException;

    public void updateInputChannel(IBinder var1, InputTransferToken var2, int var3, SurfaceControl var4, int var5, int var6, int var7, Region var8) throws RemoteException;

    public void grantEmbeddedWindowFocus(IWindow var1, InputTransferToken var2, boolean var3) throws RemoteException;

    public void generateDisplayHash(IWindow var1, Rect var2, String var3, RemoteCallback var4) throws RemoteException;

    public void setOnBackInvokedCallbackInfo(IWindow var1, OnBackInvokedCallbackInfo var2) throws RemoteException;

    public void clearTouchableRegion(IWindow var1) throws RemoteException;

    public boolean cancelDraw(IWindow var1, int var2) throws RemoteException;

    public boolean moveFocusToAdjacentWindow(IWindow var1, int var2) throws RemoteException;

    public void notifyImeWindowVisibilityChangedFromClient(IWindow var1, boolean var2, ImeTracker.Token var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSession {
        public static final String DESCRIPTOR = "android.view.IWindowSession";
        static final int TRANSACTION_addToDisplay = 1;
        static final int TRANSACTION_addToDisplayAsUser = 2;
        static final int TRANSACTION_addToDisplayWithoutInputChannel = 3;
        static final int TRANSACTION_remove = 4;
        static final int TRANSACTION_relayout = 5;
        static final int TRANSACTION_relayoutAsync = 6;
        static final int TRANSACTION_outOfMemory = 7;
        static final int TRANSACTION_setInsets = 8;
        static final int TRANSACTION_finishDrawing = 9;
        static final int TRANSACTION_performDrag = 10;
        static final int TRANSACTION_dropForAccessibility = 11;
        static final int TRANSACTION_reportDropResult = 12;
        static final int TRANSACTION_cancelDragAndDrop = 13;
        static final int TRANSACTION_dragRecipientEntered = 14;
        static final int TRANSACTION_dragRecipientExited = 15;
        static final int TRANSACTION_setWallpaperPosition = 16;
        static final int TRANSACTION_setWallpaperZoomOut = 17;
        static final int TRANSACTION_setShouldZoomOutWallpaper = 18;
        static final int TRANSACTION_wallpaperOffsetsComplete = 19;
        static final int TRANSACTION_setWallpaperDisplayOffset = 20;
        static final int TRANSACTION_sendWallpaperCommand = 21;
        static final int TRANSACTION_wallpaperCommandComplete = 22;
        static final int TRANSACTION_onRectangleOnScreenRequested = 23;
        static final int TRANSACTION_getWindowId = 24;
        static final int TRANSACTION_pokeDrawLock = 25;
        static final int TRANSACTION_startMovingTask = 26;
        static final int TRANSACTION_finishMovingTask = 27;
        static final int TRANSACTION_updateTapExcludeRegion = 28;
        static final int TRANSACTION_updateRequestedVisibleTypes = 29;
        static final int TRANSACTION_updateAnimatingTypes = 30;
        static final int TRANSACTION_reportSystemGestureExclusionChanged = 31;
        static final int TRANSACTION_reportDecorViewGestureInterceptionChanged = 32;
        static final int TRANSACTION_reportKeepClearAreasChanged = 33;
        static final int TRANSACTION_grantInputChannel = 34;
        static final int TRANSACTION_updateInputChannel = 35;
        static final int TRANSACTION_grantEmbeddedWindowFocus = 36;
        static final int TRANSACTION_generateDisplayHash = 37;
        static final int TRANSACTION_setOnBackInvokedCallbackInfo = 38;
        static final int TRANSACTION_clearTouchableRegion = 39;
        static final int TRANSACTION_cancelDraw = 40;
        static final int TRANSACTION_moveFocusToAdjacentWindow = 41;
        static final int TRANSACTION_notifyImeWindowVisibilityChangedFromClient = 42;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowSession) {
                return (IWindowSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addToDisplay";
                }
                case 2: {
                    return "addToDisplayAsUser";
                }
                case 3: {
                    return "addToDisplayWithoutInputChannel";
                }
                case 4: {
                    return "remove";
                }
                case 5: {
                    return "relayout";
                }
                case 6: {
                    return "relayoutAsync";
                }
                case 7: {
                    return "outOfMemory";
                }
                case 8: {
                    return "setInsets";
                }
                case 9: {
                    return "finishDrawing";
                }
                case 10: {
                    return "performDrag";
                }
                case 11: {
                    return "dropForAccessibility";
                }
                case 12: {
                    return "reportDropResult";
                }
                case 13: {
                    return "cancelDragAndDrop";
                }
                case 14: {
                    return "dragRecipientEntered";
                }
                case 15: {
                    return "dragRecipientExited";
                }
                case 16: {
                    return "setWallpaperPosition";
                }
                case 17: {
                    return "setWallpaperZoomOut";
                }
                case 18: {
                    return "setShouldZoomOutWallpaper";
                }
                case 19: {
                    return "wallpaperOffsetsComplete";
                }
                case 20: {
                    return "setWallpaperDisplayOffset";
                }
                case 21: {
                    return "sendWallpaperCommand";
                }
                case 22: {
                    return "wallpaperCommandComplete";
                }
                case 23: {
                    return "onRectangleOnScreenRequested";
                }
                case 24: {
                    return "getWindowId";
                }
                case 25: {
                    return "pokeDrawLock";
                }
                case 26: {
                    return "startMovingTask";
                }
                case 27: {
                    return "finishMovingTask";
                }
                case 28: {
                    return "updateTapExcludeRegion";
                }
                case 29: {
                    return "updateRequestedVisibleTypes";
                }
                case 30: {
                    return "updateAnimatingTypes";
                }
                case 31: {
                    return "reportSystemGestureExclusionChanged";
                }
                case 32: {
                    return "reportDecorViewGestureInterceptionChanged";
                }
                case 33: {
                    return "reportKeepClearAreasChanged";
                }
                case 34: {
                    return "grantInputChannel";
                }
                case 35: {
                    return "updateInputChannel";
                }
                case 36: {
                    return "grantEmbeddedWindowFocus";
                }
                case 37: {
                    return "generateDisplayHash";
                }
                case 38: {
                    return "setOnBackInvokedCallbackInfo";
                }
                case 39: {
                    return "clearTouchableRegion";
                }
                case 40: {
                    return "cancelDraw";
                }
                case 41: {
                    return "moveFocusToAdjacentWindow";
                }
                case 42: {
                    return "notifyImeWindowVisibilityChangedFromClient";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    InputChannel _arg5 = new InputChannel();
                    WindowRelayoutResult _arg6 = new WindowRelayoutResult();
                    data.enforceNoDataAvail();
                    int _result = this.addToDisplay(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg5, 1);
                    reply.writeTypedObject(_arg6, 1);
                    break;
                }
                case 2: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    InputChannel _arg6 = new InputChannel();
                    WindowRelayoutResult _arg7 = new WindowRelayoutResult();
                    data.enforceNoDataAvail();
                    int _result = this.addToDisplayAsUser(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg6, 1);
                    reply.writeTypedObject(_arg7, 1);
                    break;
                }
                case 3: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    WindowRelayoutResult _arg4 = new WindowRelayoutResult();
                    data.enforceNoDataAvail();
                    int _result = this.addToDisplayWithoutInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg4, 1);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.remove(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    WindowRelayoutResult _arg8 = new WindowRelayoutResult();
                    SurfaceControl _arg9 = new SurfaceControl();
                    data.enforceNoDataAvail();
                    int _result = this.relayout(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    reply.writeTypedObject(_arg8, 1);
                    reply.writeTypedObject(_arg9, 1);
                    break;
                }
                case 6: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    WindowManager.LayoutParams _arg1 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.relayoutAsync(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 7: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.outOfMemory(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    Rect _arg3 = data.readTypedObject(Rect.CREATOR);
                    Region _arg4 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInsets(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 9: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    SurfaceControl.Transaction _arg1 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishDrawing(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    float _arg6 = data.readFloat();
                    float _arg7 = data.readFloat();
                    float _arg8 = data.readFloat();
                    float _arg9 = data.readFloat();
                    ClipData _arg10 = data.readTypedObject(ClipData.CREATOR);
                    data.enforceNoDataAvail();
                    IBinder _result = this.performDrag(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 11: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.dropForAccessibility(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportDropResult(_arg0, _arg1);
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.cancelDragAndDrop(_arg0, _arg1);
                    break;
                }
                case 14: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.dragRecipientEntered(_arg0);
                    break;
                }
                case 15: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.dragRecipientExited(_arg0);
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setWallpaperPosition(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setWallpaperZoomOut(_arg0, _arg1);
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldZoomOutWallpaper(_arg0, _arg1);
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.wallpaperOffsetsComplete(_arg0);
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWallpaperDisplayOffset(_arg0, _arg1, _arg2);
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    Bundle _arg5 = data.readTypedObject(Bundle.CREATOR);
                    boolean _arg6 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.sendWallpaperCommand(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.wallpaperCommandComplete(_arg0, _arg1);
                    break;
                }
                case 23: {
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRectangleOnScreenRequested(_arg0, _arg1, _arg2);
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IWindowId _result = this.getWindowId(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.pokeDrawLock(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    data.enforceNoDataAvail();
                    boolean _result = this.startMovingTask(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.finishMovingTask(_arg0);
                    break;
                }
                case 28: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    Region _arg1 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateTapExcludeRegion(_arg0, _arg1);
                    break;
                }
                case 29: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateRequestedVisibleTypes(_arg0, _arg1, _arg2);
                    break;
                }
                case 30: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateAnimatingTypes(_arg0, _arg1, _arg2);
                    break;
                }
                case 31: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    ArrayList<Rect> _arg1 = data.createTypedArrayList(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportSystemGestureExclusionChanged(_arg0, _arg1);
                    break;
                }
                case 32: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportDecorViewGestureInterceptionChanged(_arg0, _arg1);
                    break;
                }
                case 33: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    ArrayList<Rect> _arg1 = data.createTypedArrayList(Rect.CREATOR);
                    ArrayList<Rect> _arg2 = data.createTypedArrayList(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportKeepClearAreasChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = data.readTypedObject(SurfaceControl.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    InputTransferToken _arg3 = data.readTypedObject(InputTransferToken.CREATOR);
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    int _arg7 = data.readInt();
                    IBinder _arg8 = data.readStrongBinder();
                    InputTransferToken _arg9 = data.readTypedObject(InputTransferToken.CREATOR);
                    String _arg10 = data.readString();
                    InputChannel _arg11 = new InputChannel();
                    data.enforceNoDataAvail();
                    this.grantInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10, _arg11);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg11, 1);
                    break;
                }
                case 35: {
                    IBinder _arg0 = data.readStrongBinder();
                    InputTransferToken _arg1 = data.readTypedObject(InputTransferToken.CREATOR);
                    int _arg2 = data.readInt();
                    SurfaceControl _arg3 = data.readTypedObject(SurfaceControl.CREATOR);
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    Region _arg7 = data.readTypedObject(Region.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateInputChannel(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 36: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    InputTransferToken _arg1 = data.readTypedObject(InputTransferToken.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.grantEmbeddedWindowFocus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    String _arg2 = data.readString();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.generateDisplayHash(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 38: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    OnBackInvokedCallbackInfo _arg1 = data.readTypedObject(OnBackInvokedCallbackInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.setOnBackInvokedCallbackInfo(_arg0, _arg1);
                    break;
                }
                case 39: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.clearTouchableRegion(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.cancelDraw(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 41: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.moveFocusToAdjacentWindow(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyImeWindowVisibilityChangedFromClient(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 41;
        }

        private static class Proxy
        implements IWindowSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int requestedVisibleTypes, InputChannel outInputChannel, WindowRelayoutResult result) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    _data.writeInt(requestedVisibleTypes);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        result.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, int requestedVisibleTypes, InputChannel outInputChannel, WindowRelayoutResult result) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    _data.writeInt(userId);
                    _data.writeInt(requestedVisibleTypes);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        result.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, WindowRelayoutResult result) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(layerStackId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        result.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(IBinder clientToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int relayout(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, int seq, int lastSyncSeqId, WindowRelayoutResult outRelayoutResult, SurfaceControl outSurface) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(requestedWidth);
                    _data.writeInt(requestedHeight);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeInt(lastSyncSeqId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                    if (0 != _reply.readInt()) {
                        outRelayoutResult.readFromParcel(_reply);
                    }
                    if (0 != _reply.readInt()) {
                        outSurface.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayoutAsync(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, int seq, int lastSyncSeqId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(requestedWidth);
                    _data.writeInt(requestedHeight);
                    _data.writeInt(viewVisibility);
                    _data.writeInt(flags);
                    _data.writeInt(seq);
                    _data.writeInt(lastSyncSeqId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean outOfMemory(IWindow window) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(touchableInsets);
                    _data.writeTypedObject(contentInsets, 0);
                    _data.writeTypedObject(visibleInsets, 0);
                    _data.writeTypedObject(touchableRegion, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction, int seqId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(postDrawTransaction, 0);
                    _data.writeInt(seqId);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder performDrag(IWindow window, int flags, SurfaceControl surface, int touchSource, int touchDeviceId, int touchPointerId, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(flags);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(touchSource);
                    _data.writeInt(touchDeviceId);
                    _data.writeInt(touchPointerId);
                    _data.writeFloat(touchX);
                    _data.writeFloat(touchY);
                    _data.writeFloat(thumbCenterX);
                    _data.writeFloat(thumbCenterY);
                    _data.writeTypedObject(data, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean dropForAccessibility(IWindow window, int x, int y) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportDropResult(IWindow window, boolean consumed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeBoolean(consumed);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(dragToken);
                    _data.writeBoolean(skipAnimation);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragRecipientEntered(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragRecipientExited(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeFloat(x);
                    _data.writeFloat(y);
                    _data.writeFloat(xstep);
                    _data.writeFloat(ystep);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperZoomOut(IBinder windowToken, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeFloat(scale);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeBoolean(shouldZoom);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wallpaperOffsetsComplete(IBinder window) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    _data.writeString(action);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeInt(z);
                    _data.writeTypedObject(extras, 0);
                    _data.writeBoolean(sync);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void wallpaperCommandComplete(IBinder window, Bundle result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRectangleOnScreenRequested(IBinder token, Rect rectangle, int source) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(rectangle, 0);
                    _data.writeInt(source);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowId getWindowId(IBinder window) throws RemoteException {
                IWindowId _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = IWindowId.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pokeDrawLock(IBinder window) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(window);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startMovingTask(IWindow window, float startX, float startY) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeFloat(startX);
                    _data.writeFloat(startY);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishMovingTask(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateTapExcludeRegion(IWindow window, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(region, 0);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRequestedVisibleTypes(IWindow window, int requestedVisibleTypes, ImeTracker.Token imeStatsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(requestedVisibleTypes);
                    _data.writeTypedObject(imeStatsToken, 0);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateAnimatingTypes(IWindow window, int animatingTypes, ImeTracker.Token imeStatsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(animatingTypes);
                    _data.writeTypedObject(imeStatsToken, 0);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedList(exclusionRects, 0);
                    boolean bl = this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportDecorViewGestureInterceptionChanged(IWindow window, boolean intercepted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeBoolean(intercepted);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportKeepClearAreasChanged(IWindow window, List<Rect> restricted, List<Rect> unrestricted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedList(restricted, 0);
                    _data.writeTypedList(unrestricted, 0);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantInputChannel(int displayId, SurfaceControl surface, IBinder clientToken, InputTransferToken hostInputTransferToken, int flags, int privateFlags, int inputFeatures, int type, IBinder windowToken, InputTransferToken embeddedInputTransferToken, String inputHandleName, InputChannel outInputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(surface, 0);
                    _data.writeStrongBinder(clientToken);
                    _data.writeTypedObject(hostInputTransferToken, 0);
                    _data.writeInt(flags);
                    _data.writeInt(privateFlags);
                    _data.writeInt(inputFeatures);
                    _data.writeInt(type);
                    _data.writeStrongBinder(windowToken);
                    _data.writeTypedObject(embeddedInputTransferToken, 0);
                    _data.writeString(inputHandleName);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateInputChannel(IBinder channelToken, InputTransferToken hostInputTransferToken, int displayId, SurfaceControl surface, int flags, int privateFlags, int inputFeatures, Region region) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(channelToken);
                    _data.writeTypedObject(hostInputTransferToken, 0);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(surface, 0);
                    _data.writeInt(flags);
                    _data.writeInt(privateFlags);
                    _data.writeInt(inputFeatures);
                    _data.writeTypedObject(region, 0);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantEmbeddedWindowFocus(IWindow window, InputTransferToken inputToken, boolean grantFocus) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(inputToken, 0);
                    _data.writeBoolean(grantFocus);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(boundsInWindow, 0);
                    _data.writeString(hashAlgorithm);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnBackInvokedCallbackInfo(IWindow window, OnBackInvokedCallbackInfo callbackInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeTypedObject(callbackInfo, 0);
                    boolean bl = this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearTouchableRegion(IWindow window) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancelDraw(IWindow window, int seqId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeInt(seqId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean moveFocusToAdjacentWindow(IWindow fromWindow, int direction) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(fromWindow);
                    _data.writeInt(direction);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyImeWindowVisibilityChangedFromClient(IWindow window, boolean visible, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(window);
                    _data.writeBoolean(visible);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(42, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowSession {
        @Override
        public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int requestedVisibleTypes, InputChannel outInputChannel, WindowRelayoutResult result) throws RemoteException {
            return 0;
        }

        @Override
        public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, int requestedVisibleTypes, InputChannel outInputChannel, WindowRelayoutResult result) throws RemoteException {
            return 0;
        }

        @Override
        public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, WindowRelayoutResult result) throws RemoteException {
            return 0;
        }

        @Override
        public void remove(IBinder clientToken) throws RemoteException {
        }

        @Override
        public int relayout(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, int seq, int lastSyncSeqId, WindowRelayoutResult outRelayoutResult, SurfaceControl outSurface) throws RemoteException {
            return 0;
        }

        @Override
        public void relayoutAsync(IWindow window, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, int seq, int lastSyncSeqId) throws RemoteException {
        }

        @Override
        public boolean outOfMemory(IWindow window) throws RemoteException {
            return false;
        }

        @Override
        public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) throws RemoteException {
        }

        @Override
        public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction, int seqId) throws RemoteException {
        }

        @Override
        public IBinder performDrag(IWindow window, int flags, SurfaceControl surface, int touchSource, int touchDeviceId, int touchPointerId, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) throws RemoteException {
            return null;
        }

        @Override
        public boolean dropForAccessibility(IWindow window, int x, int y) throws RemoteException {
            return false;
        }

        @Override
        public void reportDropResult(IWindow window, boolean consumed) throws RemoteException {
        }

        @Override
        public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) throws RemoteException {
        }

        @Override
        public void dragRecipientEntered(IWindow window) throws RemoteException {
        }

        @Override
        public void dragRecipientExited(IWindow window) throws RemoteException {
        }

        @Override
        public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) throws RemoteException {
        }

        @Override
        public void setWallpaperZoomOut(IBinder windowToken, float scale) throws RemoteException {
        }

        @Override
        public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) throws RemoteException {
        }

        @Override
        public void wallpaperOffsetsComplete(IBinder window) throws RemoteException {
        }

        @Override
        public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) throws RemoteException {
        }

        @Override
        public void sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) throws RemoteException {
        }

        @Override
        public void wallpaperCommandComplete(IBinder window, Bundle result) throws RemoteException {
        }

        @Override
        public void onRectangleOnScreenRequested(IBinder token, Rect rectangle, int source) throws RemoteException {
        }

        @Override
        public IWindowId getWindowId(IBinder window) throws RemoteException {
            return null;
        }

        @Override
        public void pokeDrawLock(IBinder window) throws RemoteException {
        }

        @Override
        public boolean startMovingTask(IWindow window, float startX, float startY) throws RemoteException {
            return false;
        }

        @Override
        public void finishMovingTask(IWindow window) throws RemoteException {
        }

        @Override
        public void updateTapExcludeRegion(IWindow window, Region region) throws RemoteException {
        }

        @Override
        public void updateRequestedVisibleTypes(IWindow window, int requestedVisibleTypes, ImeTracker.Token imeStatsToken) throws RemoteException {
        }

        @Override
        public void updateAnimatingTypes(IWindow window, int animatingTypes, ImeTracker.Token imeStatsToken) throws RemoteException {
        }

        @Override
        public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) throws RemoteException {
        }

        @Override
        public void reportDecorViewGestureInterceptionChanged(IWindow window, boolean intercepted) throws RemoteException {
        }

        @Override
        public void reportKeepClearAreasChanged(IWindow window, List<Rect> restricted, List<Rect> unrestricted) throws RemoteException {
        }

        @Override
        public void grantInputChannel(int displayId, SurfaceControl surface, IBinder clientToken, InputTransferToken hostInputTransferToken, int flags, int privateFlags, int inputFeatures, int type, IBinder windowToken, InputTransferToken embeddedInputTransferToken, String inputHandleName, InputChannel outInputChannel) throws RemoteException {
        }

        @Override
        public void updateInputChannel(IBinder channelToken, InputTransferToken hostInputTransferToken, int displayId, SurfaceControl surface, int flags, int privateFlags, int inputFeatures, Region region) throws RemoteException {
        }

        @Override
        public void grantEmbeddedWindowFocus(IWindow window, InputTransferToken inputToken, boolean grantFocus) throws RemoteException {
        }

        @Override
        public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void setOnBackInvokedCallbackInfo(IWindow window, OnBackInvokedCallbackInfo callbackInfo) throws RemoteException {
        }

        @Override
        public void clearTouchableRegion(IWindow window) throws RemoteException {
        }

        @Override
        public boolean cancelDraw(IWindow window, int seqId) throws RemoteException {
            return false;
        }

        @Override
        public boolean moveFocusToAdjacentWindow(IWindow fromWindow, int direction) throws RemoteException {
            return false;
        }

        @Override
        public void notifyImeWindowVisibilityChangedFromClient(IWindow window, boolean visible, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

