/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipDescription;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import android.view.DragAndDropPermissions;
import android.view.inputmethod.InputContentInfo;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;

public class ContentInfo
implements Parcelable {
    public static final int SOURCE_APP = 0;
    public static final int SOURCE_CLIPBOARD = 1;
    public static final int SOURCE_INPUT_METHOD = 2;
    public static final int SOURCE_DRAG_AND_DROP = 3;
    public static final int SOURCE_AUTOFILL = 4;
    public static final int SOURCE_PROCESS_TEXT = 5;
    public static final int FLAG_CONVERT_TO_PLAIN_TEXT = 1;
    @NonNull
    private final ClipData mClip;
    private final int mSource;
    private final int mFlags;
    @Nullable
    private final Uri mLinkUri;
    @Nullable
    private final Bundle mExtras;
    @Nullable
    private final InputContentInfo mInputContentInfo;
    @Nullable
    private final DragAndDropPermissions mDragAndDropPermissions;
    @NonNull
    public static final Parcelable.Creator<ContentInfo> CREATOR = new Parcelable.Creator<ContentInfo>(){

        @Override
        public ContentInfo createFromParcel(Parcel parcel) {
            ClipData clip = ClipData.CREATOR.createFromParcel(parcel);
            int source = parcel.readInt();
            int flags = parcel.readInt();
            Uri linkUri = Uri.CREATOR.createFromParcel(parcel);
            Bundle extras = parcel.readBundle();
            InputContentInfo inputContentInfo = null;
            if (parcel.readInt() != 0) {
                inputContentInfo = InputContentInfo.CREATOR.createFromParcel(parcel);
            }
            DragAndDropPermissions dragAndDropPermissions = null;
            if (parcel.readInt() != 0) {
                dragAndDropPermissions = DragAndDropPermissions.CREATOR.createFromParcel(parcel);
            }
            return new Builder(clip, source).setFlags(flags).setLinkUri(linkUri).setExtras(extras).setInputContentInfo(inputContentInfo).setDragAndDropPermissions(dragAndDropPermissions).build();
        }

        public ContentInfo[] newArray(int size) {
            return new ContentInfo[size];
        }
    };

    static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "SOURCE_APP";
            }
            case 1: {
                return "SOURCE_CLIPBOARD";
            }
            case 2: {
                return "SOURCE_INPUT_METHOD";
            }
            case 3: {
                return "SOURCE_DRAG_AND_DROP";
            }
            case 4: {
                return "SOURCE_AUTOFILL";
            }
            case 5: {
                return "SOURCE_PROCESS_TEXT";
            }
        }
        return String.valueOf(source);
    }

    static String flagsToString(int flags) {
        if ((flags & 1) != 0) {
            return "FLAG_CONVERT_TO_PLAIN_TEXT";
        }
        return String.valueOf(flags);
    }

    private ContentInfo(Builder b) {
        this.mClip = Objects.requireNonNull(b.mClip);
        this.mSource = Preconditions.checkArgumentInRange(b.mSource, 0, 5, "source");
        this.mFlags = Preconditions.checkFlagsArgument(b.mFlags, 1);
        this.mLinkUri = b.mLinkUri;
        this.mExtras = b.mExtras;
        this.mInputContentInfo = b.mInputContentInfo;
        this.mDragAndDropPermissions = b.mDragAndDropPermissions;
    }

    public void releasePermissions() {
        if (this.mInputContentInfo != null) {
            this.mInputContentInfo.releasePermission();
        }
        if (this.mDragAndDropPermissions != null) {
            this.mDragAndDropPermissions.release();
        }
    }

    @NonNull
    public String toString() {
        return "ContentInfo{clip=" + this.mClip + ", source=" + ContentInfo.sourceToString(this.mSource) + ", flags=" + ContentInfo.flagsToString(this.mFlags) + ", linkUri=" + this.mLinkUri + ", extras=" + this.mExtras + "}";
    }

    @NonNull
    public ClipData getClip() {
        return this.mClip;
    }

    public int getSource() {
        return this.mSource;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @Nullable
    public Uri getLinkUri() {
        return this.mLinkUri;
    }

    @Nullable
    @SuppressLint(value={"NullableCollection"})
    public Bundle getExtras() {
        return this.mExtras;
    }

    @NonNull
    public Pair<ContentInfo, ContentInfo> partition(@NonNull Predicate<ClipData.Item> itemPredicate) {
        if (this.mClip.getItemCount() == 1) {
            boolean matched = itemPredicate.test(this.mClip.getItemAt(0));
            return Pair.create(matched ? this : null, matched ? null : this);
        }
        ArrayList<ClipData.Item> acceptedItems = new ArrayList<ClipData.Item>();
        ArrayList<ClipData.Item> remainingItems = new ArrayList<ClipData.Item>();
        for (int i = 0; i < this.mClip.getItemCount(); ++i) {
            ClipData.Item item = this.mClip.getItemAt(i);
            if (itemPredicate.test(item)) {
                acceptedItems.add(item);
                continue;
            }
            remainingItems.add(item);
        }
        if (acceptedItems.isEmpty()) {
            return Pair.create(null, this);
        }
        if (remainingItems.isEmpty()) {
            return Pair.create(this, null);
        }
        ContentInfo accepted = new Builder(this).setClip(new ClipData(new ClipDescription(this.mClip.getDescription()), acceptedItems)).build();
        ContentInfo remaining = new Builder(this).setClip(new ClipData(new ClipDescription(this.mClip.getDescription()), remainingItems)).build();
        return Pair.create(accepted, remaining);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mClip.writeToParcel(dest, flags);
        dest.writeInt(this.mSource);
        dest.writeInt(this.mFlags);
        Uri.writeToParcel(dest, this.mLinkUri);
        dest.writeBundle(this.mExtras);
        if (this.mInputContentInfo == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mInputContentInfo.writeToParcel(dest, flags);
        }
        if (this.mDragAndDropPermissions == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mDragAndDropPermissions.writeToParcel(dest, flags);
        }
    }

    public static class Builder {
        @NonNull
        private ClipData mClip;
        private int mSource;
        private int mFlags;
        @Nullable
        private Uri mLinkUri;
        @Nullable
        private Bundle mExtras;
        @Nullable
        private InputContentInfo mInputContentInfo;
        @Nullable
        private DragAndDropPermissions mDragAndDropPermissions;

        public Builder(@NonNull ContentInfo other) {
            this.mClip = other.mClip;
            this.mSource = other.mSource;
            this.mFlags = other.mFlags;
            this.mLinkUri = other.mLinkUri;
            this.mExtras = other.mExtras;
            this.mInputContentInfo = other.mInputContentInfo;
            this.mDragAndDropPermissions = other.mDragAndDropPermissions;
        }

        public Builder(@NonNull ClipData clip, int source) {
            this.mClip = clip;
            this.mSource = source;
        }

        @NonNull
        public Builder setClip(@NonNull ClipData clip) {
            this.mClip = clip;
            return this;
        }

        @NonNull
        public Builder setSource(int source) {
            this.mSource = source;
            return this;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        @NonNull
        public Builder setLinkUri(@Nullable Uri linkUri) {
            this.mLinkUri = linkUri;
            return this;
        }

        @NonNull
        public Builder setExtras(@SuppressLint(value={"NullableCollection"}) @Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setInputContentInfo(@Nullable InputContentInfo inputContentInfo) {
            this.mInputContentInfo = inputContentInfo;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setDragAndDropPermissions(@Nullable DragAndDropPermissions permissions) {
            this.mDragAndDropPermissions = permissions;
            return this;
        }

        @NonNull
        public ContentInfo build() {
            return new ContentInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }
}

