/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.uwb.UwbAddress;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.uwb_fira_3_0_25q4")
public class LogicalLinkParams
implements Parcelable {
    private final byte[] mDestinationAddress;
    private final int mLogicalLinkClassLength;
    public static final int LINK_LAYER_MODE_CONNECTION_LESS_NON_SECURE = 0;
    public static final int LINK_LAYER_MODE_CONNECTION_LESS_SECURE = 1;
    public static final int LINK_LAYER_MODE_CONNECTION_ORIENTED_NON_SECURE = 2;
    public static final int LINK_LAYER_MODE_CONNECTION_ORIENTED_SECURE = 3;
    public static final int LINK_LAYER_MODE_CONNECTION_LESS_UWBS_UWBS = 4;
    public static final int LINK_LAYER_MODE_CONNECTION_ORIENTED_UWBS_UWBS = 5;
    private final int mLinkLayerModeSelector;
    public static final int LOGICAL_LINK_STATUS_OK = 0;
    public static final int LOGICAL_LINK_STATUS_FAILED = 1;
    public static final int LOGICAL_LINK_CLOSE_REASON_REMOTE = 0;
    public static final int LOGICAL_LINK_CLOSE_REASON_TIMEOUT = 1;
    public static final int LOGICAL_LINK_CLOSE_REASON_TRANSMISSION_ERROR = 2;
    public static final int LOGICAL_LINK_CLOSE_REASON_SECURE_COMPONENT = 3;
    public static final int LOGICAL_LINK_CLOSE_REASON_UNKNOWN_REASON = 4;
    public static final int LOGICAL_LINK_CLOSE_REASON_HOST_INITIATED = 5;
    public static final int LOGICAL_LINK_STATUS_ACCEPTED = 0;
    public static final int LOGICAL_LINK_STATUS_REJECTED = 1;
    public static final int LOGICAL_LINK_STATUS_CO_CONNECTED = 2;
    public static final int LOGICAL_LINK_STATUS_ERROR = 3;
    public static final int CONNECT_ID_UNSPECIFIED = -1;
    @NonNull
    public static final Parcelable.Creator<LogicalLinkParams> CREATOR = new Parcelable.Creator<LogicalLinkParams>(){

        @Override
        public LogicalLinkParams createFromParcel(Parcel in) {
            return new Builder(in.readInt(), UwbAddress.fromBytes(in.createByteArray())).setLogicalLinkClassLength(in.readInt()).build();
        }

        public LogicalLinkParams[] newArray(int size) {
            return new LogicalLinkParams[size];
        }
    };

    private LogicalLinkParams(Builder builder) {
        this.mLinkLayerModeSelector = builder.mLinkLayerModeSelector;
        this.mDestinationAddress = builder.mDestinationAddress;
        this.mLogicalLinkClassLength = builder.mLogicalLinkClassLength;
    }

    @NonNull
    public int getLinkLayerModeSelector() {
        return this.mLinkLayerModeSelector;
    }

    @NonNull
    public byte[] getDestinationAddress() {
        return this.mDestinationAddress;
    }

    @NonNull
    public int getLogicalLinkClassLength() {
        return this.mLogicalLinkClassLength;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogicalLinkParams) {
            LogicalLinkParams other = (LogicalLinkParams)obj;
            return this.mLinkLayerModeSelector == other.mLinkLayerModeSelector && Arrays.equals(this.mDestinationAddress, other.mDestinationAddress) && this.mLogicalLinkClassLength == other.mLogicalLinkClassLength;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mLinkLayerModeSelector, Arrays.hashCode(this.mDestinationAddress), this.mLogicalLinkClassLength);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "LogicalLinkParams{linkLayerModeSelector=" + this.mLinkLayerModeSelector + ", destinationAddress=" + UwbAddress.fromBytes(this.mDestinationAddress) + ", logicalLinkClassLength=" + this.mLogicalLinkClassLength + '}';
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mLinkLayerModeSelector);
        dest.writeByteArray(this.mDestinationAddress);
        dest.writeInt(this.mLogicalLinkClassLength);
    }

    public static class Builder {
        private int mLinkLayerModeSelector;
        private byte[] mDestinationAddress = new byte[8];
        private int mLogicalLinkClassLength = 0;

        public Builder(int linkLayerModeSelector, @NonNull UwbAddress destinationAddress) {
            this.mLinkLayerModeSelector = linkLayerModeSelector;
            byte[] addressBytes = destinationAddress.toBytes();
            if (addressBytes.length == 2) {
                byte[] extendedAddress = new byte[8];
                System.arraycopy(addressBytes, 0, extendedAddress, 0, 2);
                this.mDestinationAddress = extendedAddress;
            } else {
                this.mDestinationAddress = addressBytes;
            }
        }

        @NonNull
        public Builder setLogicalLinkClassLength(int logicalLinkClassLength) {
            this.mLogicalLinkClassLength = logicalLinkClassLength;
            return this;
        }

        @NonNull
        public LogicalLinkParams build() {
            return new LogicalLinkParams(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LogicalLinkStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LogicalLinkClosureReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LogicalLinkStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LinkLayerMode {
    }
}

