/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.uwb.UwbAddress;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.uwb_fira_3_0_25q4")
public class LogicalLinkConnectionRequest
implements Parcelable {
    private final int mConnectId;
    private final int mLinkLayerModeSelector;
    private final byte[] mSourceAddress;
    @NonNull
    public static final Parcelable.Creator<LogicalLinkConnectionRequest> CREATOR = new Parcelable.Creator<LogicalLinkConnectionRequest>(){

        @Override
        public LogicalLinkConnectionRequest createFromParcel(Parcel in) {
            byte[] sourceAddress = in.createByteArray();
            if (sourceAddress == null) {
                throw new IllegalArgumentException("sourceAddress in parcel is null");
            }
            return new Builder(in.readInt(), in.readInt(), UwbAddress.fromBytes(sourceAddress)).build();
        }

        public LogicalLinkConnectionRequest[] newArray(int size) {
            return new LogicalLinkConnectionRequest[size];
        }
    };

    private LogicalLinkConnectionRequest(Builder builder) {
        this.mConnectId = builder.mConnectId;
        this.mLinkLayerModeSelector = builder.mLinkLayerModeSelector;
        this.mSourceAddress = builder.mSourceAddress;
    }

    public int getConnectId() {
        return this.mConnectId;
    }

    public int getLinkLayerModeSelector() {
        return this.mLinkLayerModeSelector;
    }

    @NonNull
    public UwbAddress getSourceAddress() {
        return UwbAddress.fromBytes(this.mSourceAddress);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mConnectId);
        dest.writeInt(this.mLinkLayerModeSelector);
        dest.writeByteArray(this.mSourceAddress);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogicalLinkConnectionRequest)) {
            return false;
        }
        LogicalLinkConnectionRequest other = (LogicalLinkConnectionRequest)obj;
        return this.mConnectId == other.mConnectId && this.mLinkLayerModeSelector == other.mLinkLayerModeSelector && Arrays.equals(this.mSourceAddress, other.mSourceAddress);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mSourceAddress), this.mConnectId, this.mLinkLayerModeSelector);
    }

    public String toString() {
        return "LogicalLinkConnectionRequest{sourceAddress=" + UwbAddress.fromBytes(this.mSourceAddress) + ", connectId=" + this.mConnectId + ", linkLayerModeSelector=" + this.mLinkLayerModeSelector + '}';
    }

    public static class Builder {
        private byte[] mSourceAddress = new byte[8];
        private int mConnectId;
        private int mLinkLayerModeSelector;

        public Builder(int connectId, int linkLayerModeSelector, @NonNull UwbAddress sourceAddress) {
            this.mConnectId = connectId;
            this.mLinkLayerModeSelector = linkLayerModeSelector;
            this.mSourceAddress = sourceAddress.toBytes();
        }

        @NonNull
        public LogicalLinkConnectionRequest build() {
            return new LogicalLinkConnectionRequest(this);
        }
    }
}

