/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.SystemClock;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

@SystemApi
@RavenwoodKeepWholeClass
public class StatsEvent {
    @VisibleForTesting
    public static final byte TYPE_INT = 0;
    @VisibleForTesting
    public static final byte TYPE_LONG = 1;
    @VisibleForTesting
    public static final byte TYPE_STRING = 2;
    @VisibleForTesting
    public static final byte TYPE_LIST = 3;
    @VisibleForTesting
    public static final byte TYPE_FLOAT = 4;
    @VisibleForTesting
    public static final byte TYPE_BOOLEAN = 5;
    @VisibleForTesting
    public static final byte TYPE_BYTE_ARRAY = 6;
    @VisibleForTesting
    public static final byte TYPE_OBJECT = 7;
    @VisibleForTesting
    public static final byte TYPE_KEY_VALUE_PAIRS = 8;
    @VisibleForTesting
    public static final byte TYPE_ATTRIBUTION_CHAIN = 9;
    @VisibleForTesting
    public static final byte TYPE_ERRORS = 15;
    @VisibleForTesting
    public static final int ERROR_NO_TIMESTAMP = 1;
    @VisibleForTesting
    public static final int ERROR_NO_ATOM_ID = 2;
    @VisibleForTesting
    public static final int ERROR_OVERFLOW = 4;
    @VisibleForTesting
    public static final int ERROR_ATTRIBUTION_CHAIN_TOO_LONG = 8;
    @VisibleForTesting
    public static final int ERROR_TOO_MANY_KEY_VALUE_PAIRS = 16;
    @VisibleForTesting
    public static final int ERROR_ANNOTATION_DOES_NOT_FOLLOW_FIELD = 32;
    @VisibleForTesting
    public static final int ERROR_INVALID_ANNOTATION_ID = 64;
    @VisibleForTesting
    public static final int ERROR_ANNOTATION_ID_TOO_LARGE = 128;
    @VisibleForTesting
    public static final int ERROR_TOO_MANY_ANNOTATIONS = 256;
    @VisibleForTesting
    public static final int ERROR_TOO_MANY_FIELDS = 512;
    @VisibleForTesting
    public static final int ERROR_ATTRIBUTION_UIDS_TAGS_SIZES_NOT_EQUAL = 4096;
    @VisibleForTesting
    public static final int ERROR_ATOM_ID_INVALID_POSITION = 8192;
    @VisibleForTesting
    public static final int ERROR_LIST_TOO_LONG = 16384;
    @VisibleForTesting
    public static final int MAX_ANNOTATION_COUNT = 15;
    @VisibleForTesting
    public static final int MAX_ATTRIBUTION_NODES = 127;
    @VisibleForTesting
    public static final int MAX_NUM_ELEMENTS = 127;
    @VisibleForTesting
    public static final int MAX_KEY_VALUE_PAIRS = 127;
    private static final int LOGGER_ENTRY_MAX_PAYLOAD = 4068;
    private static final int MAX_PUSH_PAYLOAD_SIZE = 4064;
    private static final int MAX_PULL_PAYLOAD_SIZE = 51200;
    private final int mAtomId;
    private final byte[] mPayload;
    private Buffer mBuffer;
    private final int mNumBytes;

    private StatsEvent(int atomId, @Nullable Buffer buffer, @NonNull byte[] payload, int numBytes) {
        this.mAtomId = atomId;
        this.mBuffer = buffer;
        this.mPayload = payload;
        this.mNumBytes = numBytes;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder(Buffer.obtain());
    }

    public int getAtomId() {
        return this.mAtomId;
    }

    @NonNull
    public byte[] getBytes() {
        return this.mPayload;
    }

    public int getNumBytes() {
        return this.mNumBytes;
    }

    public void release() {
        if (this.mBuffer != null) {
            this.mBuffer.release();
            this.mBuffer = null;
        }
    }

    private static class Buffer {
        private static AtomicReference<Buffer> sPool = new AtomicReference();
        private byte[] mBytes;
        private boolean mOverflow = false;
        private int mMaxSize = 51200;
        private static final int INITIAL_BUFFER_SIZE = 512;

        @NonNull
        private static Buffer obtain() {
            Buffer buffer = sPool.getAndSet(null);
            if (buffer == null) {
                buffer = new Buffer();
            } else {
                buffer.reset();
            }
            return buffer;
        }

        private Buffer() {
            ByteBuffer tempBuffer = ByteBuffer.allocateDirect(512);
            this.mBytes = tempBuffer.hasArray() ? tempBuffer.array() : new byte[512];
        }

        @NonNull
        private byte[] getBytes() {
            return this.mBytes;
        }

        private void release() {
            if (this.mMaxSize <= 4064) {
                sPool.compareAndSet(null, this);
            }
        }

        private void reset() {
            this.mOverflow = false;
            this.mMaxSize = 51200;
        }

        private void setMaxSize(int maxSize, int numBytesWritten) {
            this.mMaxSize = maxSize;
            if (numBytesWritten > maxSize) {
                this.mOverflow = true;
            }
        }

        private boolean hasOverflowed() {
            return this.mOverflow;
        }

        private boolean hasEnoughSpace(int index, int numBytes) {
            int totalBytesNeeded = index + numBytes;
            if (totalBytesNeeded > this.mMaxSize) {
                this.mOverflow = true;
                return false;
            }
            if (this.mBytes.length < this.mMaxSize && totalBytesNeeded > this.mBytes.length) {
                int newSize = this.mBytes.length;
                while ((newSize *= 2) <= totalBytesNeeded) {
                }
                if (newSize > this.mMaxSize) {
                    newSize = this.mMaxSize;
                }
                this.mBytes = Arrays.copyOf(this.mBytes, newSize);
            }
            return true;
        }

        private int putByte(int index, byte value) {
            if (this.hasEnoughSpace(index, 1)) {
                this.mBytes[index] = value;
                return 1;
            }
            return 0;
        }

        private int putBoolean(int index, boolean value) {
            return this.putByte(index, (byte)(value ? 1 : 0));
        }

        private int putInt(int index, int value) {
            if (this.hasEnoughSpace(index, 4)) {
                this.mBytes[index] = (byte)value;
                this.mBytes[index + 1] = (byte)(value >> 8);
                this.mBytes[index + 2] = (byte)(value >> 16);
                this.mBytes[index + 3] = (byte)(value >> 24);
                return 4;
            }
            return 0;
        }

        private int putLong(int index, long value) {
            if (this.hasEnoughSpace(index, 8)) {
                this.mBytes[index] = (byte)value;
                this.mBytes[index + 1] = (byte)(value >> 8);
                this.mBytes[index + 2] = (byte)(value >> 16);
                this.mBytes[index + 3] = (byte)(value >> 24);
                this.mBytes[index + 4] = (byte)(value >> 32);
                this.mBytes[index + 5] = (byte)(value >> 40);
                this.mBytes[index + 6] = (byte)(value >> 48);
                this.mBytes[index + 7] = (byte)(value >> 56);
                return 8;
            }
            return 0;
        }

        private int putFloat(int index, float value) {
            return this.putInt(index, Float.floatToIntBits(value));
        }

        private int putByteArray(int index, @NonNull byte[] value) {
            int numBytes = value.length;
            if (this.hasEnoughSpace(index, numBytes)) {
                System.arraycopy(value, 0, this.mBytes, index, numBytes);
                return numBytes;
            }
            return 0;
        }
    }

    public static class Builder {
        private static final int POS_NUM_ELEMENTS = 1;
        private static final int POS_TIMESTAMP_NS = 2;
        private static final int POS_ATOM_ID = 11;
        private final Buffer mBuffer;
        private long mTimestampNs;
        private int mAtomId;
        private byte mCurrentAnnotationCount;
        private int mPos;
        private int mPosLastField;
        private byte mLastType;
        private int mNumElements;
        private int mErrorMask;
        private boolean mUsePooledBuffer = false;

        private Builder(Buffer buffer) {
            this.mBuffer = buffer;
            this.mCurrentAnnotationCount = 0;
            this.mAtomId = 0;
            this.mTimestampNs = SystemClock.elapsedRealtimeNanos();
            this.mNumElements = 0;
            this.mPos = 0;
            this.writeTypeId((byte)7);
            this.mPos = 2;
            this.writeLong(this.mTimestampNs);
        }

        @NonNull
        public Builder setAtomId(int atomId) {
            if (0 == this.mAtomId) {
                this.mAtomId = atomId;
                if (1 == this.mNumElements) {
                    this.writeInt(atomId);
                } else {
                    this.mErrorMask |= 0x2000;
                }
            }
            return this;
        }

        @NonNull
        public Builder writeBoolean(boolean value) {
            this.writeTypeId((byte)5);
            this.mPos += this.mBuffer.putBoolean(this.mPos, value);
            ++this.mNumElements;
            return this;
        }

        @NonNull
        public Builder writeInt(int value) {
            this.writeTypeId((byte)0);
            this.mPos += this.mBuffer.putInt(this.mPos, value);
            ++this.mNumElements;
            return this;
        }

        @NonNull
        public Builder writeLong(long value) {
            this.writeTypeId((byte)1);
            this.mPos += this.mBuffer.putLong(this.mPos, value);
            ++this.mNumElements;
            return this;
        }

        @NonNull
        public Builder writeFloat(float value) {
            this.writeTypeId((byte)4);
            this.mPos += this.mBuffer.putFloat(this.mPos, value);
            ++this.mNumElements;
            return this;
        }

        @NonNull
        public Builder writeString(@NonNull String value) {
            byte[] valueBytes = Builder.stringToBytes(value);
            this.writeByteArray(valueBytes, (byte)2);
            return this;
        }

        @NonNull
        public Builder writeByteArray(@NonNull byte[] value) {
            this.writeByteArray(value, (byte)6);
            return this;
        }

        private void writeByteArray(@NonNull byte[] value, byte typeId) {
            this.writeTypeId(typeId);
            int numBytes = value.length;
            this.mPos += this.mBuffer.putInt(this.mPos, numBytes);
            this.mPos += this.mBuffer.putByteArray(this.mPos, value);
            ++this.mNumElements;
        }

        @NonNull
        public Builder writeAttributionChain(@NonNull int[] uids, @NonNull String[] tags) {
            int numUids = uids.length;
            byte numTags = (byte)tags.length;
            if (numUids != numTags) {
                this.mErrorMask |= 0x1000;
            } else if (numUids > 127) {
                this.mErrorMask |= 8;
            } else {
                this.writeTypeId((byte)9);
                this.mPos += this.mBuffer.putByte(this.mPos, (byte)numUids);
                for (int i = 0; i < numUids; ++i) {
                    this.mPos += this.mBuffer.putInt(this.mPos, uids[i]);
                    byte[] tagBytes = Builder.stringToBytes(tags[i]);
                    this.mPos += this.mBuffer.putInt(this.mPos, tagBytes.length);
                    this.mPos += this.mBuffer.putByteArray(this.mPos, tagBytes);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @NonNull
        public Builder writeKeyValuePairs(@Nullable SparseIntArray intMap, @Nullable SparseLongArray longMap, @Nullable SparseArray<String> stringMap, @Nullable SparseArray<Float> floatMap) {
            int floatMapSize;
            int stringMapSize;
            int longMapSize;
            int intMapSize = null == intMap ? 0 : intMap.size();
            int totalCount = intMapSize + (longMapSize = null == longMap ? 0 : longMap.size()) + (stringMapSize = null == stringMap ? 0 : stringMap.size()) + (floatMapSize = null == floatMap ? 0 : floatMap.size());
            if (totalCount > 127) {
                this.mErrorMask |= 0x10;
            } else {
                int key;
                int i;
                this.writeTypeId((byte)8);
                this.mPos += this.mBuffer.putByte(this.mPos, (byte)totalCount);
                for (i = 0; i < intMapSize; ++i) {
                    key = intMap.keyAt(i);
                    int value = intMap.valueAt(i);
                    this.mPos += this.mBuffer.putInt(this.mPos, key);
                    this.writeTypeId((byte)0);
                    this.mPos += this.mBuffer.putInt(this.mPos, value);
                }
                for (i = 0; i < longMapSize; ++i) {
                    key = longMap.keyAt(i);
                    long value = longMap.valueAt(i);
                    this.mPos += this.mBuffer.putInt(this.mPos, key);
                    this.writeTypeId((byte)1);
                    this.mPos += this.mBuffer.putLong(this.mPos, value);
                }
                for (i = 0; i < stringMapSize; ++i) {
                    key = stringMap.keyAt(i);
                    String value = stringMap.valueAt(i);
                    this.mPos += this.mBuffer.putInt(this.mPos, key);
                    this.writeTypeId((byte)2);
                    byte[] valueBytes = Builder.stringToBytes(value);
                    this.mPos += this.mBuffer.putInt(this.mPos, valueBytes.length);
                    this.mPos += this.mBuffer.putByteArray(this.mPos, valueBytes);
                }
                for (i = 0; i < floatMapSize; ++i) {
                    key = floatMap.keyAt(i);
                    float value = floatMap.valueAt(i).floatValue();
                    this.mPos += this.mBuffer.putInt(this.mPos, key);
                    this.writeTypeId((byte)4);
                    this.mPos += this.mBuffer.putFloat(this.mPos, value);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder writeBooleanArray(@NonNull boolean[] elements) {
            int numElements = elements.length;
            if (this.writeArrayInfo((byte)numElements, (byte)5)) {
                for (int i = 0; i < numElements; ++i) {
                    this.mPos += this.mBuffer.putBoolean(this.mPos, elements[i]);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder writeIntArray(@NonNull int[] elements) {
            int numElements = elements.length;
            if (this.writeArrayInfo((byte)numElements, (byte)0)) {
                for (int i = 0; i < numElements; ++i) {
                    this.mPos += this.mBuffer.putInt(this.mPos, elements[i]);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder writeLongArray(@NonNull long[] elements) {
            int numElements = elements.length;
            if (this.writeArrayInfo((byte)numElements, (byte)1)) {
                for (int i = 0; i < numElements; ++i) {
                    this.mPos += this.mBuffer.putLong(this.mPos, elements[i]);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder writeFloatArray(@NonNull float[] elements) {
            int numElements = elements.length;
            if (this.writeArrayInfo((byte)numElements, (byte)4)) {
                for (int i = 0; i < numElements; ++i) {
                    this.mPos += this.mBuffer.putFloat(this.mPos, elements[i]);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @RequiresApi(value=33)
        @NonNull
        public Builder writeStringArray(@NonNull String[] elements) {
            int numElements = elements.length;
            if (this.writeArrayInfo((byte)numElements, (byte)2)) {
                for (int i = 0; i < numElements; ++i) {
                    byte[] elementBytes = Builder.stringToBytes(elements[i]);
                    this.mPos += this.mBuffer.putInt(this.mPos, elementBytes.length);
                    this.mPos += this.mBuffer.putByteArray(this.mPos, elementBytes);
                }
                ++this.mNumElements;
            }
            return this;
        }

        @NonNull
        public Builder addBooleanAnnotation(byte annotationId, boolean value) {
            if (this.mNumElements < 2) {
                this.mErrorMask |= 0x20;
            } else if (this.mCurrentAnnotationCount >= 15) {
                this.mErrorMask |= 0x100;
            } else {
                this.mPos += this.mBuffer.putByte(this.mPos, annotationId);
                this.mPos += this.mBuffer.putByte(this.mPos, (byte)5);
                this.mPos += this.mBuffer.putBoolean(this.mPos, value);
                this.mCurrentAnnotationCount = (byte)(this.mCurrentAnnotationCount + 1);
                this.writeAnnotationCount();
            }
            return this;
        }

        @NonNull
        public Builder addIntAnnotation(byte annotationId, int value) {
            if (this.mNumElements < 2) {
                this.mErrorMask |= 0x20;
            } else if (this.mCurrentAnnotationCount >= 15) {
                this.mErrorMask |= 0x100;
            } else {
                this.mPos += this.mBuffer.putByte(this.mPos, annotationId);
                this.mPos += this.mBuffer.putByte(this.mPos, (byte)0);
                this.mPos += this.mBuffer.putInt(this.mPos, value);
                this.mCurrentAnnotationCount = (byte)(this.mCurrentAnnotationCount + 1);
                this.writeAnnotationCount();
            }
            return this;
        }

        @NonNull
        public Builder usePooledBuffer() {
            this.mUsePooledBuffer = true;
            this.mBuffer.setMaxSize(4064, this.mPos);
            return this;
        }

        @NonNull
        public StatsEvent build() {
            if (0L == this.mTimestampNs) {
                this.mErrorMask |= 1;
            }
            if (0 == this.mAtomId) {
                this.mErrorMask |= 2;
            }
            if (this.mBuffer.hasOverflowed()) {
                this.mErrorMask |= 4;
            }
            if (this.mNumElements > 127) {
                this.mErrorMask |= 0x200;
            }
            if (0 == this.mErrorMask) {
                this.mBuffer.putByte(1, (byte)this.mNumElements);
            } else {
                this.mPos = 11;
                this.mPos += this.mBuffer.putByte(this.mPos, (byte)0);
                this.mPos += this.mBuffer.putInt(this.mPos, this.mAtomId);
                this.mPos += this.mBuffer.putByte(this.mPos, (byte)15);
                this.mPos += this.mBuffer.putInt(this.mPos, this.mErrorMask);
                this.mBuffer.putByte(1, (byte)3);
            }
            int size = this.mPos;
            if (this.mUsePooledBuffer) {
                return new StatsEvent(this.mAtomId, this.mBuffer, this.mBuffer.getBytes(), size);
            }
            byte[] payload = new byte[size];
            System.arraycopy(this.mBuffer.getBytes(), 0, payload, 0, size);
            this.mBuffer.release();
            return new StatsEvent(this.mAtomId, null, payload, size);
        }

        private void writeTypeId(byte typeId) {
            this.mPosLastField = this.mPos;
            this.mLastType = typeId;
            this.mCurrentAnnotationCount = 0;
            byte encodedId = (byte)(typeId & 0xF);
            this.mPos += this.mBuffer.putByte(this.mPos, encodedId);
        }

        private void writeAnnotationCount() {
            byte encodedId = (byte)(this.mCurrentAnnotationCount << 4 | this.mLastType & 0xF);
            this.mBuffer.putByte(this.mPosLastField, encodedId);
        }

        @NonNull
        private static byte[] stringToBytes(@Nullable String value) {
            return (null == value ? "" : value).getBytes(StandardCharsets.UTF_8);
        }

        private boolean writeArrayInfo(byte numElements, byte elementTypeId) {
            if (numElements > 127) {
                this.mErrorMask |= 0x4000;
                return false;
            }
            this.writeTypeId((byte)3);
            this.mPos += this.mBuffer.putByte(this.mPos, numElements);
            byte encodedId = (byte)(elementTypeId & 0xF);
            this.mPos += this.mBuffer.putByte(this.mPos, encodedId);
            return true;
        }
    }
}

