/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.Resources;
import android.view.Display;

public class DisplayUtils {
    public static int getDisplayUniqueIdConfigIndex(Resources res, String displayUniqueId) {
        int index = -1;
        if (displayUniqueId == null || displayUniqueId.isEmpty()) {
            return index;
        }
        String[] ids = res.getStringArray(17236055);
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            if (!displayUniqueId.equals(ids[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    public static Display.Mode getMaximumResolutionDisplayMode(Display.Mode[] modes) {
        if (modes == null || modes.length == 0) {
            return null;
        }
        int maxWidth = 0;
        Display.Mode target = null;
        for (Display.Mode mode : modes) {
            if (mode.getPhysicalWidth() <= maxWidth) continue;
            maxWidth = mode.getPhysicalWidth();
            target = mode;
        }
        return target;
    }

    public static float getPhysicalPixelDisplaySizeRatio(int physicalWidth, int physicalHeight, int currentWidth, int currentHeight) {
        if (physicalWidth == currentWidth && physicalHeight == currentHeight) {
            return 1.0f;
        }
        float widthRatio = (float)currentWidth / (float)physicalWidth;
        float heightRatio = (float)currentHeight / (float)physicalHeight;
        return Math.min(widthRatio, heightRatio);
    }
}

