/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.AtomicFile;
import java.io.FileOutputStream;
import java.io.IOException;

@RavenwoodKeepWholeClass
public class AtomicFileOutputStream
extends FileOutputStream
implements AutoCloseable {
    private static final String TAG = "AtomicFileOutputStream";
    private final AtomicFile mFile;
    private final FileOutputStream mOutStream;
    private boolean mWritingSuccessful;
    private boolean mClosed;

    public AtomicFileOutputStream(AtomicFile file) throws IOException {
        this(file, file.startWrite());
    }

    private AtomicFileOutputStream(AtomicFile file, FileOutputStream oStream) throws IOException {
        super(oStream.getFD());
        this.mFile = file;
        this.mOutStream = oStream;
    }

    public void markSuccess() {
        if (this.mWritingSuccessful) {
            throw new IllegalStateException("AtomicFileOutputStream success is already marked");
        }
        this.mWritingSuccessful = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        FileOutputStream fileOutputStream = this.mOutStream;
        synchronized (fileOutputStream) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
        }
        if (this.mWritingSuccessful) {
            this.mFile.finishWrite(this.mOutStream);
        } else {
            this.mFile.failWrite(this.mOutStream);
        }
    }

    public String toString() {
        return "AtomicFileOutputStream[mFile=" + this.mFile + ", mWritingSuccessful=" + this.mWritingSuccessful + ", mClosed=" + this.mClosed + "]";
    }
}

