/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.PathMotion;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionPropagation;
import android.transition.TransitionValues;
import android.transition.TransitionValuesMaps;
import android.util.AndroidRuntimeException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import java.util.ArrayList;

public class TransitionSet
extends Transition {
    private static final int FLAG_CHANGE_INTERPOLATOR = 1;
    private static final int FLAG_CHANGE_PROPAGATION = 2;
    private static final int FLAG_CHANGE_PATH_MOTION = 4;
    static final int FLAG_CHANGE_EPICENTER = 8;
    ArrayList<Transition> mTransitions = new ArrayList();
    private boolean mPlayTogether = true;
    int mCurrentListeners;
    boolean mStarted = false;
    private int mChangeFlags = 0;
    public static final int ORDERING_TOGETHER = 0;
    public static final int ORDERING_SEQUENTIAL = 1;

    public TransitionSet() {
    }

    public TransitionSet(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TransitionSet);
        int ordering = a.getInt(0, 0);
        this.setOrdering(ordering);
        a.recycle();
    }

    public TransitionSet setOrdering(int ordering) {
        switch (ordering) {
            case 1: {
                this.mPlayTogether = false;
                break;
            }
            case 0: {
                this.mPlayTogether = true;
                break;
            }
            default: {
                throw new AndroidRuntimeException("Invalid parameter for TransitionSet ordering: " + ordering);
            }
        }
        return this;
    }

    public int getOrdering() {
        return this.mPlayTogether ? 0 : 1;
    }

    public TransitionSet addTransition(Transition transition2) {
        if (transition2 != null) {
            this.addTransitionInternal(transition2);
            if (this.mDuration >= 0L) {
                transition2.setDuration(this.mDuration);
            }
            if ((this.mChangeFlags & 1) != 0) {
                transition2.setInterpolator(this.getInterpolator());
            }
            if ((this.mChangeFlags & 2) != 0) {
                transition2.setPropagation(this.getPropagation());
            }
            if ((this.mChangeFlags & 4) != 0) {
                transition2.setPathMotion(this.getPathMotion());
            }
            if ((this.mChangeFlags & 8) != 0) {
                transition2.setEpicenterCallback(this.getEpicenterCallback());
            }
        }
        return this;
    }

    private void addTransitionInternal(Transition transition2) {
        this.mTransitions.add(transition2);
        transition2.mParent = this;
    }

    public int getTransitionCount() {
        return this.mTransitions.size();
    }

    public Transition getTransitionAt(int index) {
        if (index < 0 || index >= this.mTransitions.size()) {
            return null;
        }
        return this.mTransitions.get(index);
    }

    @Override
    public TransitionSet setDuration(long duration) {
        super.setDuration(duration);
        if (this.mDuration >= 0L && this.mTransitions != null) {
            int numTransitions = this.mTransitions.size();
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).setDuration(duration);
            }
        }
        return this;
    }

    @Override
    public TransitionSet setStartDelay(long startDelay) {
        return (TransitionSet)super.setStartDelay(startDelay);
    }

    @Override
    public TransitionSet setInterpolator(TimeInterpolator interpolator2) {
        this.mChangeFlags |= 1;
        if (this.mTransitions != null) {
            int numTransitions = this.mTransitions.size();
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).setInterpolator(interpolator2);
            }
        }
        return (TransitionSet)super.setInterpolator(interpolator2);
    }

    @Override
    public TransitionSet addTarget(View target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(target);
        }
        return (TransitionSet)super.addTarget(target);
    }

    @Override
    public TransitionSet addTarget(int targetId) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(targetId);
        }
        return (TransitionSet)super.addTarget(targetId);
    }

    @Override
    public TransitionSet addTarget(String targetName) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(targetName);
        }
        return (TransitionSet)super.addTarget(targetName);
    }

    @Override
    public TransitionSet addTarget(Class targetType) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).addTarget(targetType);
        }
        return (TransitionSet)super.addTarget(targetType);
    }

    @Override
    public TransitionSet addListener(Transition.TransitionListener listener) {
        return (TransitionSet)super.addListener(listener);
    }

    @Override
    public TransitionSet removeTarget(int targetId) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(targetId);
        }
        return (TransitionSet)super.removeTarget(targetId);
    }

    @Override
    public TransitionSet removeTarget(View target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(target);
        }
        return (TransitionSet)super.removeTarget(target);
    }

    @Override
    public TransitionSet removeTarget(Class target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(target);
        }
        return (TransitionSet)super.removeTarget(target);
    }

    @Override
    public TransitionSet removeTarget(String target) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).removeTarget(target);
        }
        return (TransitionSet)super.removeTarget(target);
    }

    @Override
    public Transition excludeTarget(View target, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(target, exclude);
        }
        return super.excludeTarget(target, exclude);
    }

    @Override
    public Transition excludeTarget(String targetName, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(targetName, exclude);
        }
        return super.excludeTarget(targetName, exclude);
    }

    @Override
    public Transition excludeTarget(int targetId, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(targetId, exclude);
        }
        return super.excludeTarget(targetId, exclude);
    }

    @Override
    public Transition excludeTarget(Class type, boolean exclude) {
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            this.mTransitions.get(i).excludeTarget(type, exclude);
        }
        return super.excludeTarget(type, exclude);
    }

    @Override
    public TransitionSet removeListener(Transition.TransitionListener listener) {
        return (TransitionSet)super.removeListener(listener);
    }

    @Override
    public void setPathMotion(PathMotion pathMotion) {
        super.setPathMotion(pathMotion);
        this.mChangeFlags |= 4;
        if (this.mTransitions != null) {
            for (int i = 0; i < this.mTransitions.size(); ++i) {
                this.mTransitions.get(i).setPathMotion(pathMotion);
            }
        }
    }

    public TransitionSet removeTransition(Transition transition2) {
        this.mTransitions.remove(transition2);
        transition2.mParent = null;
        return this;
    }

    private void setupStartEndListeners() {
        TransitionSetListener listener = new TransitionSetListener(this);
        for (Transition childTransition : this.mTransitions) {
            childTransition.addListener(listener);
        }
        this.mCurrentListeners = this.mTransitions.size();
    }

    @Override
    protected void createAnimators(ViewGroup sceneRoot, TransitionValuesMaps startValues, TransitionValuesMaps endValues, ArrayList<TransitionValues> startValuesList, ArrayList<TransitionValues> endValuesList) {
        long startDelay = this.getStartDelay();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            Transition childTransition = this.mTransitions.get(i);
            if (startDelay > 0L && (this.mPlayTogether || i == 0)) {
                long childStartDelay = childTransition.getStartDelay();
                if (childStartDelay > 0L) {
                    childTransition.setStartDelay(startDelay + childStartDelay);
                } else {
                    childTransition.setStartDelay(startDelay);
                }
            }
            childTransition.createAnimators(sceneRoot, startValues, endValues, startValuesList, endValuesList);
        }
    }

    @Override
    protected void runAnimators() {
        if (this.mTransitions.isEmpty()) {
            this.start();
            this.end();
            return;
        }
        this.setupStartEndListeners();
        int numTransitions = this.mTransitions.size();
        if (!this.mPlayTogether) {
            for (int i = 1; i < numTransitions; ++i) {
                Transition previousTransition = this.mTransitions.get(i - 1);
                final Transition nextTransition = this.mTransitions.get(i);
                previousTransition.addListener(new TransitionListenerAdapter(this){

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        nextTransition.runAnimators();
                        transition2.removeListener(this);
                    }
                });
            }
            Transition firstTransition = this.mTransitions.get(0);
            if (firstTransition != null) {
                firstTransition.runAnimators();
            }
        } else {
            for (int i = 0; i < numTransitions; ++i) {
                this.mTransitions.get(i).runAnimators();
            }
        }
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        if (this.isValidTarget(transitionValues.view)) {
            for (Transition childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view)) continue;
                childTransition.captureStartValues(transitionValues);
                transitionValues.targetedTransitions.add(childTransition);
            }
        }
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        if (this.isValidTarget(transitionValues.view)) {
            for (Transition childTransition : this.mTransitions) {
                if (!childTransition.isValidTarget(transitionValues.view)) continue;
                childTransition.captureEndValues(transitionValues);
                transitionValues.targetedTransitions.add(childTransition);
            }
        }
    }

    @Override
    void capturePropagationValues(TransitionValues transitionValues) {
        super.capturePropagationValues(transitionValues);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).capturePropagationValues(transitionValues);
        }
    }

    @Override
    public void pause(View sceneRoot) {
        super.pause(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).pause(sceneRoot);
        }
    }

    @Override
    public void resume(View sceneRoot) {
        super.resume(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).resume(sceneRoot);
        }
    }

    @Override
    protected void cancel() {
        super.cancel();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).cancel();
        }
    }

    @Override
    void forceToEnd(ViewGroup sceneRoot) {
        super.forceToEnd(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).forceToEnd(sceneRoot);
        }
    }

    @Override
    TransitionSet setSceneRoot(ViewGroup sceneRoot) {
        super.setSceneRoot(sceneRoot);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setSceneRoot(sceneRoot);
        }
        return this;
    }

    @Override
    void setCanRemoveViews(boolean canRemoveViews) {
        super.setCanRemoveViews(canRemoveViews);
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setCanRemoveViews(canRemoveViews);
        }
    }

    @Override
    public void setPropagation(TransitionPropagation propagation) {
        super.setPropagation(propagation);
        this.mChangeFlags |= 2;
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setPropagation(propagation);
        }
    }

    @Override
    public void setEpicenterCallback(Transition.EpicenterCallback epicenterCallback) {
        super.setEpicenterCallback(epicenterCallback);
        this.mChangeFlags |= 8;
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            this.mTransitions.get(i).setEpicenterCallback(epicenterCallback);
        }
    }

    @Override
    String toString(String indent) {
        String result = super.toString(indent);
        for (int i = 0; i < this.mTransitions.size(); ++i) {
            result = result + "\n" + this.mTransitions.get(i).toString(indent + "  ");
        }
        return result;
    }

    @Override
    public TransitionSet clone() {
        TransitionSet clone = (TransitionSet)super.clone();
        clone.mTransitions = new ArrayList();
        int numTransitions = this.mTransitions.size();
        for (int i = 0; i < numTransitions; ++i) {
            clone.addTransitionInternal(this.mTransitions.get(i).clone());
        }
        return clone;
    }

    static class TransitionSetListener
    extends TransitionListenerAdapter {
        TransitionSet mTransitionSet;

        TransitionSetListener(TransitionSet transitionSet) {
            this.mTransitionSet = transitionSet;
        }

        @Override
        public void onTransitionStart(Transition transition2) {
            if (!this.mTransitionSet.mStarted) {
                this.mTransitionSet.start();
                this.mTransitionSet.mStarted = true;
            }
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            --this.mTransitionSet.mCurrentListeners;
            if (this.mTransitionSet.mCurrentListeners == 0) {
                this.mTransitionSet.mStarted = false;
                this.mTransitionSet.end();
            }
            transition2.removeListener(this);
        }
    }
}

