/*
 * Decompiled with CFR 0.152.
 */
package android.tracing.perfetto;

import android.tracing.perfetto.DataSource;
import android.tracing.perfetto.FlushCallbackArguments;
import android.tracing.perfetto.StartCallbackArguments;
import android.tracing.perfetto.StopCallbackArguments;
import com.android.internal.annotations.VisibleForTesting;

public abstract class DataSourceInstance
implements AutoCloseable {
    private final DataSource mDataSource;
    private final int mInstanceIndex;

    public DataSourceInstance(DataSource dataSource, int instanceIndex) {
        this.mDataSource = dataSource;
        this.mInstanceIndex = instanceIndex;
    }

    protected void onStart(StartCallbackArguments args) {
    }

    protected void onFlush(FlushCallbackArguments args) {
    }

    protected void onStop(StopCallbackArguments args) {
    }

    public void stopDone() {
        this.mDataSource.stopDoneDataSourceInstance(this.mInstanceIndex);
    }

    @Override
    public void close() {
        this.release();
    }

    @VisibleForTesting
    public void release() {
        this.mDataSource.releaseDataSourceInstance(this.mInstanceIndex);
    }

    public int getInstanceIndex() {
        return this.mInstanceIndex;
    }
}

