/*
 * Decompiled with CFR 0.152.
 */
package android.tracing.perfetto;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.tracing.perfetto.CreateIncrementalStateArgs;
import android.tracing.perfetto.CreateTlsStateArgs;
import android.tracing.perfetto.DataSourceInstance;
import android.tracing.perfetto.DataSourceParams;
import android.tracing.perfetto.TraceFunction;
import android.tracing.perfetto.TracingContext;
import android.util.proto.ProtoInputStream;
import com.android.tools.layoutlib.create.OverrideMethod;

public abstract class DataSource<DataSourceInstanceType extends DataSourceInstance, TlsStateType, IncrementalStateType> {
    protected final long mNativeObj;
    public final String name;

    @NonNull
    public abstract DataSourceInstanceType createInstance(ProtoInputStream var1, int var2);

    public DataSource(String name) {
        this.name = name;
        this.mNativeObj = DataSource.nativeCreate(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(TraceFunction<DataSourceInstanceType, TlsStateType, IncrementalStateType> fun) {
        boolean startedIterator = DataSource.nativePerfettoDsTraceIterateBegin(this.mNativeObj);
        if (!startedIterator) {
            return;
        }
        try {
            do {
                int instanceIndex = DataSource.nativeGetPerfettoDsInstanceIndex(this.mNativeObj);
                TracingContext ctx = new TracingContext(this, instanceIndex);
                fun.trace(ctx);
                DataSource.nativeWritePackets(this.mNativeObj, ctx.getAndClearAllPendingTracePackets());
            } while (DataSource.nativePerfettoDsTraceIterateNext(this.mNativeObj));
        }
        finally {
            DataSource.nativePerfettoDsTraceIterateBreak(this.mNativeObj);
        }
    }

    public void flush() {
        DataSource.nativeFlushAll(this.mNativeObj);
    }

    @Nullable
    public TlsStateType createTlsState(CreateTlsStateArgs<DataSourceInstanceType> args) {
        return null;
    }

    @Nullable
    public IncrementalStateType createIncrementalState(CreateIncrementalStateArgs<DataSourceInstanceType> args) {
        return null;
    }

    public void register(DataSourceParams params) {
        DataSource.nativeRegisterDataSource(this.mNativeObj, params.bufferExhaustedPolicy, params.willNotifyOnStop, params.noFlush, params.postponeStop);
    }

    @Nullable
    public DataSourceInstanceType getDataSourceInstanceLocked(int instanceIndex) {
        return (DataSourceInstanceType)DataSource.nativeGetPerfettoInstanceLocked(this.mNativeObj, instanceIndex);
    }

    protected void releaseDataSourceInstance(int instanceIndex) {
        DataSource.nativeReleasePerfettoInstanceLocked(this.mNativeObj, instanceIndex);
    }

    @NonNull
    private DataSourceInstanceType createInstance(byte[] rawConfig, int instanceIndex) {
        ProtoInputStream inputStream = new ProtoInputStream(rawConfig);
        return this.createInstance(inputStream, instanceIndex);
    }

    protected void stopDoneDataSourceInstance(int instanceIndex) {
        DataSource.nativeStopDonePerfettoInstanceLocked(this.mNativeObj, instanceIndex);
    }

    private static void nativeRegisterDataSource(long l, int n, boolean bl, boolean bl2, boolean bl3) {
        OverrideMethod.invokeV("android.tracing.perfetto.DataSource#nativeRegisterDataSource(JIZZZ)V", true, null);
    }

    private static long nativeCreate(DataSource dataSource, String string2) {
        return OverrideMethod.invokeL("android.tracing.perfetto.DataSource#nativeCreate(Landroid/tracing/perfetto/DataSource;Ljava/lang/String;)J", true, null);
    }

    private static void nativeFlushAll(long l) {
        OverrideMethod.invokeV("android.tracing.perfetto.DataSource#nativeFlushAll(J)V", true, null);
    }

    private static long nativeGetFinalizer() {
        return OverrideMethod.invokeL("android.tracing.perfetto.DataSource#nativeGetFinalizer()J", true, null);
    }

    private static DataSourceInstance nativeGetPerfettoInstanceLocked(long l, int n) {
        return (DataSourceInstance)OverrideMethod.invokeA("android.tracing.perfetto.DataSource#nativeGetPerfettoInstanceLocked(JI)Landroid/tracing/perfetto/DataSourceInstance;", true, null);
    }

    private static void nativeReleasePerfettoInstanceLocked(long l, int n) {
        OverrideMethod.invokeV("android.tracing.perfetto.DataSource#nativeReleasePerfettoInstanceLocked(JI)V", true, null);
    }

    private static void nativeStopDonePerfettoInstanceLocked(long l, int n) {
        OverrideMethod.invokeV("android.tracing.perfetto.DataSource#nativeStopDonePerfettoInstanceLocked(JI)V", true, null);
    }

    private static boolean nativePerfettoDsTraceIterateBegin(long l) {
        return OverrideMethod.invokeI("android.tracing.perfetto.DataSource#nativePerfettoDsTraceIterateBegin(J)Z", true, null) != 0;
    }

    private static boolean nativePerfettoDsTraceIterateNext(long l) {
        return OverrideMethod.invokeI("android.tracing.perfetto.DataSource#nativePerfettoDsTraceIterateNext(J)Z", true, null) != 0;
    }

    private static void nativePerfettoDsTraceIterateBreak(long l) {
        OverrideMethod.invokeV("android.tracing.perfetto.DataSource#nativePerfettoDsTraceIterateBreak(J)V", true, null);
    }

    private static int nativeGetPerfettoDsInstanceIndex(long l) {
        return OverrideMethod.invokeI("android.tracing.perfetto.DataSource#nativeGetPerfettoDsInstanceIndex(J)I", true, null);
    }

    private static void nativeWritePackets(long l, byte[][] byArray) {
        OverrideMethod.invokeV("android.tracing.perfetto.DataSource#nativeWritePackets(J[[B)V", true, null);
    }
}

