/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.style.ParagraphStyle;

@RavenwoodKeepWholeClass
public interface AlignmentSpan
extends ParagraphStyle {
    public Layout.Alignment getAlignment();

    public static class Standard
    implements AlignmentSpan,
    ParcelableSpan {
        private final Layout.Alignment mAlignment;

        public Standard(@NonNull Layout.Alignment align) {
            this.mAlignment = align;
        }

        public Standard(@NonNull Parcel src) {
            this.mAlignment = Layout.Alignment.valueOf(src.readString());
        }

        @Override
        public int getSpanTypeId() {
            return this.getSpanTypeIdInternal();
        }

        @Override
        public int getSpanTypeIdInternal() {
            return 1;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            this.writeToParcelInternal(dest, flags);
        }

        @Override
        public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
            dest.writeString(this.mAlignment.name());
        }

        @Override
        public Layout.Alignment getAlignment() {
            return this.mAlignment;
        }

        public String toString() {
            return "AlignmentSpan.Standard{alignment=" + (Object)((Object)this.getAlignment()) + '}';
        }
    }
}

