/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.icu.util.Calendar;
import android.icu.util.ULocale;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.format.DateUtilsBridge;
import android.util.LruCache;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.libcore.Flags;
import java.text.FieldPosition;
import java.util.TimeZone;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
@RavenwoodKeepWholeClass
public class DateIntervalFormat {
    private static final LruCache<String, android.icu.text.DateIntervalFormat> CACHED_FORMATTERS = new LruCache(8);

    private DateIntervalFormat() {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static String formatDateRange(long startMs, long endMs, int flags, String olsonId) {
        if ((flags & 0x2000) != 0) {
            olsonId = "UTC";
        }
        TimeZone tz = olsonId != null ? TimeZone.getTimeZone(olsonId) : TimeZone.getDefault();
        android.icu.util.TimeZone icuTimeZone = DateUtilsBridge.icuTimeZone(tz);
        ULocale icuLocale = ULocale.getDefault();
        return DateIntervalFormat.formatDateRange(icuLocale, icuTimeZone, startMs, endMs, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static String formatDateRange(ULocale icuLocale, android.icu.util.TimeZone icuTimeZone, long startMs, long endMs, int flags) {
        Calendar startCalendar = DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, startMs);
        Calendar endCalendar = startMs == endMs ? startCalendar : DateUtilsBridge.createIcuCalendar(icuTimeZone, icuLocale, endMs);
        if (DateIntervalFormat.isExactlyMidnight(endCalendar)) {
            boolean endsDayAfterStart;
            boolean showTime = (flags & 1) == 1;
            boolean bl = endsDayAfterStart = DateUtilsBridge.dayDistance(startCalendar, endCalendar) == 1;
            if (!showTime && startMs != endMs || endsDayAfterStart && !DateUtilsBridge.isDisplayMidnightUsingSkeleton(startCalendar)) {
                endCalendar.add(5, -1);
            }
        }
        String skeleton = DateUtilsBridge.toSkeleton(startCalendar, endCalendar, flags);
        LruCache<String, android.icu.text.DateIntervalFormat> lruCache = CACHED_FORMATTERS;
        synchronized (lruCache) {
            android.icu.text.DateIntervalFormat formatter = DateIntervalFormat.getFormatter(skeleton, icuLocale, icuTimeZone);
            return formatter.format(startCalendar, endCalendar, new StringBuffer(), new FieldPosition(0)).toString();
        }
    }

    private static android.icu.text.DateIntervalFormat getFormatter(String skeleton, ULocale locale, android.icu.util.TimeZone icuTimeZone) {
        String key = skeleton + "\t" + locale + "\t" + icuTimeZone;
        android.icu.text.DateIntervalFormat formatter = CACHED_FORMATTERS.get(key);
        if (formatter != null) {
            return formatter;
        }
        formatter = android.icu.text.DateIntervalFormat.getInstance(skeleton, locale);
        formatter.setTimeZone(icuTimeZone);
        CACHED_FORMATTERS.put(key, formatter);
        return formatter;
    }

    private static boolean isExactlyMidnight(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static boolean isLibcoreVFlagEnabled() {
        return Flags.vApis();
    }
}

