/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.NonNull;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.text.CharacterIterator;

@RavenwoodKeepWholeClass
public class CharSequenceCharacterIterator
implements CharacterIterator {
    private final int mBeginIndex;
    private final int mEndIndex;
    private int mIndex;
    private final CharSequence mCharSeq;

    public CharSequenceCharacterIterator(@NonNull CharSequence text, int start, int end) {
        this.mCharSeq = text;
        this.mBeginIndex = this.mIndex = start;
        this.mEndIndex = end;
    }

    @Override
    public char first() {
        this.mIndex = this.mBeginIndex;
        return this.current();
    }

    @Override
    public char last() {
        if (this.mBeginIndex == this.mEndIndex) {
            this.mIndex = this.mEndIndex;
            return '\uffff';
        }
        this.mIndex = this.mEndIndex - 1;
        return this.mCharSeq.charAt(this.mIndex);
    }

    @Override
    public char current() {
        return this.mIndex == this.mEndIndex ? (char)'\uffff' : this.mCharSeq.charAt(this.mIndex);
    }

    @Override
    public char next() {
        ++this.mIndex;
        if (this.mIndex >= this.mEndIndex) {
            this.mIndex = this.mEndIndex;
            return '\uffff';
        }
        return this.mCharSeq.charAt(this.mIndex);
    }

    @Override
    public char previous() {
        if (this.mIndex <= this.mBeginIndex) {
            return '\uffff';
        }
        --this.mIndex;
        return this.mCharSeq.charAt(this.mIndex);
    }

    @Override
    public char setIndex(int position) {
        if (this.mBeginIndex <= position && position <= this.mEndIndex) {
            this.mIndex = position;
            return this.current();
        }
        throw new IllegalArgumentException("invalid position");
    }

    @Override
    public int getBeginIndex() {
        return this.mBeginIndex;
    }

    @Override
    public int getEndIndex() {
        return this.mEndIndex;
    }

    @Override
    public int getIndex() {
        return this.mIndex;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

